/*
 * Decompiled with CFR 0.152.
 */
package br.com.bb.cdg.assinador.panels;

import br.com.bb.cdg.assinador.SignerCertificate;
import br.com.bb.cdg.assinador.SignerException;
import br.com.bb.cdg.assinador.applet.AppletException;
import br.com.bb.cdg.assinador.applet.BaseSignerApplet;
import br.com.bb.cdg.assinador.panels.ActivePanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.swing.Box;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.bouncycastle.util.encoders.Base64;

public class CertListPanel
extends ActivePanel {
    private String mDefaultCertLabel;
    private byte[] mDefaultCertID;
    private final JComboBox mCerts = new JComboBox();
    private final JLabel mIssuedTo = new JLabel();
    private final JLabel mIssuedBy = new JLabel();
    private final JLabel mValidFrom = new JLabel();
    private final JLabel mValidTo = new JLabel();

    public CertListPanel(BaseSignerApplet applet) {
        super(applet);
        this.initialize();
        this.mCerts.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (e.getKeyChar() == '\n' && !CertListPanel.this.mCerts.isPopupVisible()) {
                    CertListPanel.this.getApplet().ok();
                }
            }
        });
    }

    private void initialize() {
        this.setLayout(new BorderLayout());
        this.mCerts.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                CertListPanel.this.setSelectedCert((SignerCertificate)CertListPanel.this.mCerts.getSelectedItem());
            }
        });
        this.mCerts.getAccessibleContext().setAccessibleName("Selecione um certificado");
        this.setSelectedCert(null);
        this.add((Component)this.mCerts, "North");
        JPanel pnl = new JPanel();
        pnl.setLayout(new GridLayout(4, 1));
        JPanel p = new JPanel(new FlowLayout(0, 0, 0));
        p.add(new JLabel("Emitido para:  "));
        p.add(this.mIssuedTo);
        pnl.add(p);
        p = new JPanel(new FlowLayout(0, 0, 0));
        p.add(new JLabel("Emitido por:  "));
        p.add(this.mIssuedBy);
        pnl.add(p);
        p = new JPanel(new FlowLayout(0, 0, 0));
        p.add(new JLabel("Validade do certificado: de "));
        p.add(this.mValidFrom);
        p.add(new JLabel(" at\u00e9 "));
        p.add(this.mValidTo);
        pnl.add(p);
        Box box = Box.createVerticalBox();
        box.add(Box.createGlue());
        box.add(pnl);
        box.add(Box.createGlue());
        Box box2 = Box.createHorizontalBox();
        box2.add(Box.createHorizontalStrut(12));
        box2.add(box);
        box2.add(Box.createGlue());
        this.add((Component)new JScrollPane(box2), "Center");
    }

    public void init() throws AppletException {
        DefaultComboBoxModel mdl = (DefaultComboBoxModel)this.mCerts.getModel();
        mdl.removeAllElements();
        try {
            SignerCertificate[] certs = this.getApplet().getSigner().getPublicCerts();
            int i = 0;
            while (i < certs.length) {
                SignerCertificate cert = certs[i];
                mdl.addElement(cert);
                if ((this.mDefaultCertLabel == null || this.mDefaultCertLabel.equals(cert.getLabel())) && (this.mDefaultCertID == null || Arrays.equals(cert.getID(), this.mDefaultCertID))) {
                    mdl.setSelectedItem(cert);
                }
                ++i;
            }
        }
        catch (SignerException e) {
            mdl.removeAllElements();
            System.err.println("Erro ao carregar certificados: " + e);
            throw new AppletException("Erro ao carregar certificados: " + e);
        }
        if (mdl.getSize() <= 0) {
            throw new AppletException("Nenhum certificado aceit\u00e1vel encontrado.");
        }
    }

    public List validateDataState() {
        ArrayList<String> l = new ArrayList<String>();
        if (this.mCerts.getSelectedItem() == null) {
            l.add("Selecione um certificado.");
        }
        return l;
    }

    public int getCertCount() {
        return this.mCerts.getItemCount();
    }

    public SignerCertificate getSelectedCert() {
        int i = this.mCerts.getSelectedIndex();
        if (i == -1) {
            return null;
        }
        return (SignerCertificate)this.mCerts.getModel().getElementAt(i);
    }

    public void setSelectedCert(SignerCertificate cert) {
        if (cert == null) {
            this.mCerts.setSelectedItem(null);
            this.mIssuedTo.setText("");
            this.mIssuedBy.setText("");
            this.mValidFrom.setText("          ");
            this.mValidTo.setText("          ");
            return;
        }
        if (this.mCerts.getSelectedItem() != cert) {
            this.mCerts.setSelectedItem(cert);
        }
        SimpleDateFormat df = new SimpleDateFormat("dd/MM/yyyy");
        this.mIssuedTo.setText(cert.getSubjectName());
        this.mIssuedBy.setText(cert.getIssuerName());
        try {
            this.mValidFrom.setText(df.format(cert.getX509Certificate().getNotBefore()));
            this.mValidTo.setText(df.format(cert.getX509Certificate().getNotAfter()));
        }
        catch (SignerException e) {
            System.err.println("Erro ao carregar validade do certificado: " + e);
        }
    }

    public String getSelectedCertID() {
        SignerCertificate c = this.getSelectedCert();
        if (c == null) {
            return null;
        }
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        DataOutputStream dout = new DataOutputStream(out);
        try {
            dout.writeUTF(c.getLabel());
            byte[] id = c.getID();
            if (id != null && id.length > 0) {
                dout.write(id);
            }
        }
        catch (IOException e) {
            System.out.println("Erro ao gerar id de certificado: " + e);
            return null;
        }
        return new String(Base64.encode((byte[])out.toByteArray()));
    }

    public SignerCertificate getDefaultCert() {
        if ((this.mDefaultCertLabel == null || this.mDefaultCertLabel.length() == 0) && this.mDefaultCertID == null) {
            return null;
        }
        DefaultComboBoxModel mdl = (DefaultComboBoxModel)this.mCerts.getModel();
        int i = 0;
        while (i < mdl.getSize()) {
            SignerCertificate cert = (SignerCertificate)mdl.getElementAt(i);
            if (this.mDefaultCertLabel.equals(cert.getLabel()) && (this.mDefaultCertID == null || Arrays.equals(cert.getID(), this.mDefaultCertID))) {
                return cert;
            }
            ++i;
        }
        return null;
    }

    public void setDefaultCertID(String defaultCert) {
        if (defaultCert == null || defaultCert.length() == 0) {
            this.mDefaultCertLabel = null;
            this.mDefaultCertID = null;
            return;
        }
        try {
            DataInputStream in = new DataInputStream(new ByteArrayInputStream(Base64.decode((String)defaultCert)));
            this.mDefaultCertLabel = in.readUTF();
            if (in.available() > 0) {
                this.mDefaultCertID = new byte[in.available()];
                in.readFully(this.mDefaultCertID);
            } else {
                this.mDefaultCertID = null;
            }
            in.close();
        }
        catch (IOException e) {
            System.out.println("Identifica\u00e7\u00e3o de certificado \u00e8 inv\u00e1lida: " + e);
            return;
        }
        SignerCertificate cert = this.getDefaultCert();
        if (cert != null) {
            this.mCerts.getModel().setSelectedItem(cert);
        }
    }

    public boolean isDefaultCertPresent() {
        return this.getDefaultCert() != null;
    }
}

