/*
 * Decompiled with CFR 0.152.
 */
package br.com.bb.cdg.assinador.sunJCE;

import br.com.bb.cdg.assinador.BaseSigner;
import br.com.bb.cdg.assinador.SignerCertificate;
import br.com.bb.cdg.assinador.SignerException;
import br.com.bb.cdg.assinador.SignerKey;
import br.com.bb.cdg.assinador.SignerLoginException;
import br.com.bb.cdg.assinador.SignerTokenListener;
import br.com.bb.cdg.assinador.sunJCE.SunSignerCertificate;
import br.com.bb.cdg.assinador.sunJCE.SunSignerPrivateKey;
import br.com.bb.cdg.assinador.sunJCE.SunSignerPublicKey;
import br.com.bb.cdg.assinador.sunJCE.SunTokenListenerThread;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.PrivateKey;
import java.security.Signature;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.security.interfaces.RSAPublicKey;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import javax.crypto.Cipher;
import javax.crypto.CipherOutputStream;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.engines.RSAEngine;
import org.bouncycastle.crypto.params.RSAKeyParameters;
import org.bouncycastle.util.encoders.Hex;

public class SunSigner
extends BaseSigner {
    private KeyStore mKeyStore;
    private SunTokenListenerThread mTokenListenerThread;

    public SunSigner(String configDir) throws SignerException {
        super(configDir);
        try {
            this.mKeyStore = KeyStore.getInstance(this.getConfigDir());
            this.mKeyStore.load(null, null);
        }
        catch (GeneralSecurityException e) {
            throw new SignerException("Erro ao inicializar reposit\u00f3rio.", e);
        }
        catch (IOException e) {
            throw new SignerException("Erro ao ler reposit\u00f3rio.", e);
        }
    }

    KeyStore getKeyStore() {
        return this.mKeyStore;
    }

    public void close() {
        this.mKeyStore = null;
    }

    public byte[] encrypt(byte[] data, SignerKey key) throws SignerException {
        try {
            Cipher c;
            if (key instanceof SunSignerPrivateKey) {
                c = Cipher.getInstance("RSA/ECB/PKCS1Padding", this.mKeyStore.getProvider());
                c.init(1, ((SunSignerPrivateKey)key).getPrivateKey());
            } else if (key instanceof SunSignerPublicKey) {
                c = Cipher.getInstance("RSA/ECB/PKCS1Padding", "SunJCE");
                c.init(1, ((SunSignerPublicKey)key).getPublicKey());
            } else {
                throw new SignerException("Inst\u00e2ncia inv\u00e1lida de chave para criptografia.");
            }
            return c.doFinal(data);
        }
        catch (GeneralSecurityException e) {
            throw new SignerException("Erro ao criptografar dados.", e);
        }
    }

    public void encrypt(InputStream in, OutputStream out, SignerKey key) throws SignerException {
        try {
            int size;
            Cipher c;
            if (key instanceof SunSignerPrivateKey) {
                c = Cipher.getInstance("RSA/ECB/PKCS1Padding", this.mKeyStore.getProvider());
                c.init(1, ((SunSignerPrivateKey)key).getPrivateKey());
            } else if (key instanceof SunSignerPublicKey) {
                c = Cipher.getInstance("RSA/ECB/PKCS1Padding", "SunJCE");
                c.init(1, ((SunSignerPublicKey)key).getPublicKey());
            } else {
                throw new SignerException("Inst\u00e2ncia inv\u00e1lida de chave para criptografia.");
            }
            CipherOutputStream cout = new CipherOutputStream(out, c);
            byte[] buffer = new byte[4096];
            while ((size = in.read(buffer)) != -1) {
                cout.write(buffer, 0, size);
            }
            cout.flush();
            return;
        }
        catch (GeneralSecurityException e) {
            throw new SignerException("Erro ao criptografar dados.", e);
        }
        catch (IOException e) {
            throw new SignerException("Erro ao criptografar dados.", e);
        }
    }

    public byte[] decrypt(byte[] data, SignerKey key) throws SignerException {
        try {
            if (!(key instanceof SunSignerPrivateKey)) {
                if (key instanceof SunSignerPublicKey) {
                    RSAEngine e = new RSAEngine();
                    RSAPublicKey pk = (RSAPublicKey)((SunSignerPublicKey)key).getPublicKey();
                    e.init(false, (CipherParameters)new RSAKeyParameters(false, pk.getModulus(), pk.getPublicExponent()));
                    return e.processBlock(data, 0, data.length);
                }
                throw new SignerException("Inst\u00e2ncia inv\u00e1lida de chave para criptografia.");
            }
            Cipher c = Cipher.getInstance("RSA/ECB/PKCS1Padding", this.mKeyStore.getProvider());
            c.init(2, ((SunSignerPrivateKey)key).getPrivateKey());
            return c.doFinal(data);
        }
        catch (GeneralSecurityException e) {
            throw new SignerException("Erro ao descriptografar dados.", e);
        }
    }

    public void decrypt(InputStream in, OutputStream out, SignerKey key) throws SignerException {
        try {
            int size;
            Cipher c;
            if (key instanceof SunSignerPrivateKey) {
                c = Cipher.getInstance("RSA/ECB/PKCS1Padding", this.mKeyStore.getProvider());
                c.init(2, ((SunSignerPrivateKey)key).getPrivateKey());
            } else if (key instanceof SunSignerPublicKey) {
                c = Cipher.getInstance("RSA/ECB/PKCS1Padding", "SunJCE");
                c.init(2, ((SunSignerPublicKey)key).getPublicKey());
            } else {
                throw new SignerException("Inst\u00e2ncia inv\u00e1lida de chave para criptografia.");
            }
            CipherOutputStream cout = new CipherOutputStream(out, c);
            byte[] buffer = new byte[4096];
            while ((size = in.read(buffer)) != -1) {
                cout.write(buffer, 0, size);
            }
            cout.flush();
            return;
        }
        catch (GeneralSecurityException e) {
            throw new SignerException("Erro ao descriptografar dados.", e);
        }
        catch (IOException e) {
            throw new SignerException("Erro ao descriptografar dados.", e);
        }
    }

    public void detectToken(SignerTokenListener stl) {
        if (this.mTokenListenerThread == null) {
            this.mTokenListenerThread = new SunTokenListenerThread(this, stl);
            this.mTokenListenerThread.start();
        } else {
            this.mTokenListenerThread.addListener(stl);
        }
    }

    public SignerCertificate getPublicCert(String label, byte[] id) throws SignerException {
        ArrayList<SunSignerCertificate> list = new ArrayList<SunSignerCertificate>();
        try {
            Enumeration<String> e = this.mKeyStore.aliases();
            while (e.hasMoreElements()) {
                byte[] certId;
                String certLabel = e.nextElement();
                if (!label.equals(certLabel)) continue;
                Certificate c = this.mKeyStore.getCertificate(certLabel);
                SunSignerCertificate cert = new SunSignerCertificate(this, (X509Certificate)c, certLabel);
                if (id != null && ((certId = cert.getID()) == null || !Arrays.equals(id, certId))) continue;
                list.add(cert);
            }
        }
        catch (KeyStoreException e) {
            throw new SignerException("Erro ao recuperar certificados.", e);
        }
        if (list.size() == 0) {
            throw new SignerException("N\u00e3o encontrado nenhum certificado.");
        }
        if (list.size() > 1) {
            throw new SignerException("N\u00famero inv\u00e1lido de certificados encontrados.");
        }
        return (SignerCertificate)list.get(0);
    }

    public SignerCertificate[] getPublicCerts() throws SignerException {
        ArrayList<SunSignerCertificate> list = new ArrayList<SunSignerCertificate>();
        try {
            Enumeration<String> e = this.mKeyStore.aliases();
            while (e.hasMoreElements()) {
                String label = e.nextElement();
                Certificate c = this.mKeyStore.getCertificate(label);
                SunSignerCertificate cert = new SunSignerCertificate(this, (X509Certificate)c, label);
                if (!cert.isICP()) continue;
                list.add(cert);
            }
        }
        catch (KeyStoreException e) {
            throw new SignerException("Erro ao recuperar certificados.", e);
        }
        SignerCertificate[] arr = new SignerCertificate[list.size()];
        return list.toArray(arr);
    }

    protected PrivateKey getPrivateKey(SunSignerCertificate cert) throws SignerException {
        try {
            return (PrivateKey)this.mKeyStore.getKey(cert.getLabel(), null);
        }
        catch (GeneralSecurityException e) {
            throw new SignerException("Erro ao carregar a chave privada.", e);
        }
    }

    public boolean isActive() {
        return this.mKeyStore != null;
    }

    public boolean isLogginNeeded() {
        return false;
    }

    public void login(char[] pin) throws SignerLoginException, SignerException {
    }

    public void logout() throws SignerException {
    }

    public byte[] sign(byte[] data, SignerCertificate cert) throws SignerException {
        try {
            Signature s = Signature.getInstance("SHA1withRSA", this.mKeyStore.getProvider());
            s.initSign(((SunSignerPrivateKey)cert.getPrivateKey()).getPrivateKey());
            s.update(data);
            return s.sign();
        }
        catch (GeneralSecurityException e) {
            throw new SignerException("Erro ao assinar dados.", e);
        }
    }

    public byte[] sign(InputStream in, SignerCertificate cert) throws SignerException {
        try {
            int size;
            Signature s = Signature.getInstance("SHA1withRSA", this.mKeyStore.getProvider());
            s.initSign(((SunSignerPrivateKey)cert.getPrivateKey()).getPrivateKey());
            byte[] buffer = new byte[4096];
            while ((size = in.read(buffer)) != -1) {
                s.update(buffer, 0, size);
            }
            return s.sign();
        }
        catch (GeneralSecurityException e) {
            throw new SignerException("Erro ao assinar dados.", e);
        }
        catch (IOException e) {
            throw new SignerException("Erro ao assinar dados.", e);
        }
    }

    public boolean verify(byte[] data, byte[] signature, SignerCertificate cert) throws SignerException {
        try {
            Signature s = Signature.getInstance("SHA1withRSA", this.mKeyStore.getProvider());
            s.initVerify(((SunSignerPublicKey)cert.getPublicKey()).getPublicKey());
            s.update(data);
            return s.verify(signature);
        }
        catch (GeneralSecurityException e) {
            throw new SignerException("Erro ao verificar assinatura dos dados.", e);
        }
    }

    public boolean verify(InputStream in, byte[] signature, SignerCertificate cert) throws SignerException {
        try {
            int size;
            Signature s = Signature.getInstance("SHA1withRSA", this.mKeyStore.getProvider());
            s.initVerify(((SunSignerPublicKey)cert.getPublicKey()).getPublicKey());
            byte[] buffer = new byte[4096];
            while ((size = in.read(buffer)) != -1) {
                s.update(buffer, 0, size);
            }
            return s.verify(signature);
        }
        catch (GeneralSecurityException e) {
            throw new SignerException("Erro ao verificar assinatura dos dados.", e);
        }
        catch (IOException e) {
            throw new SignerException("Erro ao verificar assinatura dos dados.", e);
        }
    }

    public static void main(String[] args) throws Exception {
        byte[] data = "Teste do Bruno".getBytes();
        SunSigner ss = new SunSigner("Windows-MY");
        SignerCertificate[] sc = ss.getPublicCerts();
        SignerCertificate c1 = sc[0];
        SignerCertificate c2 = ss.getPublicCert(String.valueOf(c1.getLabel()), c1.getID());
        System.out.println("Certificado: " + c2.getLabel());
        System.out.println("Assinatura: " + ss.verify(data, ss.sign(data, c1), c2));
        byte[] enc = ss.encrypt(data, c1.getPublicKey());
        System.out.println("Enc: " + new String(Hex.encode((byte[])enc)));
        byte[] dec = ss.decrypt(enc, c1.getPrivateKey());
        System.out.println("Dec: " + new String(Hex.encode((byte[])dec)));
        System.out.println("Dec: " + new String(dec));
    }
}

