/*
 * Decompiled with CFR 0.152.
 */
package br.com.bb.cdg.assinador.sunJCE;

import br.com.bb.cdg.assinador.SignerTokenListener;
import br.com.bb.cdg.assinador.sunJCE.SunSigner;
import br.com.bb.cdg.assinador.util.SignerTokenEventDispatcher;
import br.com.bb.cdg.assinador.util.TaskThread;
import iaik.pkcs.pkcs11.wrapper.PKCS11Exception;
import java.security.InvalidParameterException;
import java.security.KeyStore;
import java.security.KeyStoreException;

public class SunTokenListenerThread
extends TaskThread {
    private final SunSigner mSigner;
    private SignerTokenListener mListeners;

    protected SunTokenListenerThread(SunSigner signer) {
        super("TokenListener");
        if (signer == null) {
            throw new InvalidParameterException("Assinador invalido.");
        }
        this.mSigner = signer;
    }

    protected SunTokenListenerThread(SunSigner signer, SignerTokenListener stl) {
        super("TokenListener");
        if (signer == null) {
            throw new InvalidParameterException("Assinador invalido.");
        }
        if (stl == null) {
            throw new InvalidParameterException("Listener invalido.");
        }
        this.mSigner = signer;
        this.mListeners = stl;
    }

    protected void addListener(SignerTokenListener stl) {
        this.mListeners = SignerTokenEventDispatcher.add(this.mListeners, stl);
        if (this.mSigner.isActive() && this.isRunning()) {
            this.mListeners.tokenInserted(this.mSigner);
        }
    }

    protected void removeListener(SignerTokenListener stl) {
        this.mListeners = SignerTokenEventDispatcher.remove(this.mListeners, stl);
    }

    public void run() {
        try {
            if (this.mSigner.getKeyStore().size() > 0 && this.mListeners != null) {
                this.mListeners.tokenInserted(this.mSigner);
            }
        }
        catch (KeyStoreException keyStoreException) {
            // empty catch block
        }
        super.run();
    }

    public boolean isRunning() {
        return this.mSigner.isActive() && super.isRunning();
    }

    public void process() throws Exception {
        if (this.mListeners == null) {
            Thread.sleep(500L);
            return;
        }
        KeyStore ks = this.mSigner.getKeyStore();
        int startSize = ks.size();
        ks.load(null, null);
        int endSize = ks.size();
        if (startSize == endSize) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            return;
        }
        this.mListeners.tokenEvent(this.mSigner);
        if (startSize < endSize) {
            if (this.mListeners != null) {
                this.mListeners.tokenInserted(this.mSigner);
            }
        } else if (this.mListeners != null) {
            this.mListeners.tokenRemoved(this.mSigner);
        }
    }

    public void processException(Exception e) {
        if (e instanceof PKCS11Exception && ((PKCS11Exception)e).getErrorCode() == 400L) {
            return;
        }
        super.processException(e);
    }
}

