/*
 * Decompiled with CFR 0.152.
 */
package br.com.bb.cdg.assinador.util;

import br.com.bb.cdg.assinador.SignerCertificate;
import br.com.bb.cdg.assinador.SignerException;
import br.com.bb.cdg.assinador.SignerIcpData;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.CertificateParsingException;
import java.security.cert.X509Certificate;
import java.util.Collection;
import java.util.Enumeration;
import java.util.List;
import java.util.zip.CRC32;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.DERObject;
import org.bouncycastle.asn1.DERObjectIdentifier;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.DERSet;
import org.bouncycastle.asn1.DERString;
import org.bouncycastle.asn1.DERTaggedObject;

public class IcpUtils {
    public static X509Certificate parseCert(byte[] data) throws SignerException {
        try {
            CertificateFactory cf = CertificateFactory.getInstance("X.509");
            ByteArrayInputStream in = new ByteArrayInputStream(data);
            return (X509Certificate)cf.generateCertificate(in);
        }
        catch (CertificateException e) {
            throw new SignerException("Erro ao carregar dados do certificado.", e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean isA3(X509Certificate cert) {
        try {
            ASN1InputStream ais = new ASN1InputStream(cert.getExtensionValue("2.5.29.32"));
            DERObject o = ais.readObject();
            if (!(o instanceof DEROctetString)) {
                return false;
            }
            ais = new ASN1InputStream(((DEROctetString)o).getOctets());
            DERSequence s = (DERSequence)ais.readObject();
            int i = 0;
            while (true) {
                if (i >= s.size()) {
                    return false;
                }
                DERSequence ds = (DERSequence)s.getObjectAt(i);
                DERObjectIdentifier oid = (DERObjectIdentifier)ds.getObjectAt(0);
                if (oid.getId().startsWith("2.16.76.1.2.3.")) {
                    return true;
                }
                ++i;
            }
        }
        catch (IOException e) {
            return false;
        }
    }

    public static int buildIssuerID(byte[] issuerObjectData) {
        if (issuerObjectData != null && issuerObjectData.length > 0) {
            CRC32 c32 = new CRC32();
            c32.update(issuerObjectData);
            return (int)c32.getValue();
        }
        return 0;
    }

    public static int buildIssuerID(X509Certificate cert) {
        return IcpUtils.buildIssuerID(cert.getIssuerX500Principal().getEncoded());
    }

    public static SignerIcpData loadCertData(X509Certificate cert) throws SignerException {
        Collection<List<?>> c;
        block9: {
            c = cert.getSubjectAlternativeNames();
            if (c != null) break block9;
            return null;
        }
        try {
            for (List<?> ls : c) {
                String str;
                ASN1InputStream d;
                DERSequence der;
                DERObjectIdentifier id;
                if ((Integer)ls.get(0) != 0 || !"2.16.76.1.3.1".equals((id = (DERObjectIdentifier)(der = (DERSequence)(d = new ASN1InputStream((InputStream)new ByteArrayInputStream((byte[])ls.get(1)))).readObject()).getObjectAt(0)).getId())) continue;
                DERTaggedObject tobj = (DERTaggedObject)der.getObjectAt(1);
                DERObject data = (tobj = (DERTaggedObject)tobj.getObject()).getObject();
                if (data instanceof DERString) {
                    str = ((DERString)tobj.getObject()).getString();
                } else if (data instanceof DEROctetString) {
                    str = new String(((DEROctetString)tobj.getObject()).getOctets(), "ISO-8859-1");
                } else {
                    throw new SignerException("Dados de pessoa fisica em formato invalido.");
                }
                return new SignerIcpData(str);
            }
        }
        catch (CertificateParsingException e) {
            throw new SignerException(e);
        }
        catch (IOException e) {
            throw new SignerException(e);
        }
        return null;
    }

    public static String extractFieldName(byte[] data) {
        DERSequence seq;
        try {
            ASN1InputStream in = new ASN1InputStream((InputStream)new ByteArrayInputStream(data));
            seq = (DERSequence)in.readObject();
        }
        catch (IOException e) {
            System.err.println("Erro ao ler dados de identificador: " + e + ".");
            return null;
        }
        Enumeration e = seq.getObjects();
        while (e.hasMoreElements()) {
            DERObjectIdentifier id;
            DERSequence pair;
            DERSet set;
            Object o = e.nextElement();
            if (!(o instanceof DERSet) || (set = (DERSet)o).size() < 1 || (pair = (DERSequence)set.getObjectAt(0)).size() < 2 || !"2.5.4.3".equals((id = (DERObjectIdentifier)pair.getObjectAt(0)).getId())) continue;
            return ((DERString)pair.getObjectAt(1)).getString();
        }
        return null;
    }

    public static String getCertSerialNumber(SignerCertificate cert) throws SignerException {
        if (cert == null) {
            return null;
        }
        String hexadecimal = cert.getX509Certificate().getSerialNumber().toString(16);
        if (hexadecimal.length() < 32) {
            int falta = 32 - hexadecimal.length();
            StringBuffer b = new StringBuffer(32);
            int i = 0;
            while (i < falta) {
                b.append('0');
                ++i;
            }
            b.append(hexadecimal);
            hexadecimal = b.toString();
        }
        return hexadecimal;
    }
}

