/*
 * Decompiled with CFR 0.152.
 */
package br.com.bb.cdg.assinador.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import java.util.Date;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.ASN1Set;
import org.bouncycastle.asn1.DEREncodable;
import org.bouncycastle.asn1.DERInteger;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.DEROutputStream;
import org.bouncycastle.asn1.DERSet;
import org.bouncycastle.asn1.DERUTCTime;
import org.bouncycastle.asn1.pkcs.Attribute;
import org.bouncycastle.asn1.pkcs.ContentInfo;
import org.bouncycastle.asn1.pkcs.IssuerAndSerialNumber;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.bouncycastle.asn1.pkcs.SignedData;
import org.bouncycastle.asn1.pkcs.SignerInfo;
import org.bouncycastle.asn1.util.ASN1Dump;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.asn1.x509.X509CertificateStructure;
import org.bouncycastle.asn1.x509.X509ObjectIdentifiers;

public class PKCS7 {
    private PKCS7() {
    }

    public static byte[] generatePKCS7Signature(byte[] sign, byte[] data, X509Certificate cert) throws IOException, CertificateEncodingException {
        AlgorithmIdentifier digAlg = new AlgorithmIdentifier(X509ObjectIdentifiers.id_SHA1);
        AlgorithmIdentifier digAlgEnc = new AlgorithmIdentifier(PKCSObjectIdentifiers.rsaEncryption);
        ASN1Sequence certAsn1 = (ASN1Sequence)new ASN1InputStream((InputStream)new ByteArrayInputStream(cert.getEncoded())).readObject();
        X509CertificateStructure certStr = new X509CertificateStructure(certAsn1);
        IssuerAndSerialNumber isn = new IssuerAndSerialNumber(certStr.getIssuer(), certStr.getSerialNumber());
        Attribute[] atts = new Attribute[]{new Attribute(PKCSObjectIdentifiers.pkcs_9_at_signingTime, (ASN1Set)new DERSet(new ASN1Encodable[]{new DERUTCTime(new Date())}))};
        SignerInfo signerinfo = new SignerInfo(new DERInteger(1), isn, digAlg, (ASN1Set)new DERSet((ASN1Encodable[])atts), digAlgEnc, (ASN1OctetString)new DEROctetString(sign), null);
        DERInteger version = new DERInteger(1);
        DERSet digestAlgorithms = new DERSet((ASN1Encodable[])new AlgorithmIdentifier[]{digAlg});
        ContentInfo contentInfo = new ContentInfo(PKCSObjectIdentifiers.data, (DEREncodable)(data == null ? null : new DEROctetString(data)));
        DERSet certificates = new DERSet(new ASN1Encodable[]{certAsn1});
        DERSet signerInfos = new DERSet((ASN1Encodable[])new SignerInfo[]{signerinfo});
        SignedData signedData = new SignedData(version, (ASN1Set)digestAlgorithms, contentInfo, (ASN1Set)certificates, null, (ASN1Set)signerInfos);
        ContentInfo body = new ContentInfo(PKCSObjectIdentifiers.signedData, (DEREncodable)signedData);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        DEROutputStream dout = new DEROutputStream((OutputStream)out);
        dout.writeObject((Object)body);
        dout.close();
        return out.toByteArray();
    }

    public static void printPKCS7Signature(String file, DEREncodable der) throws IOException {
        String dump = ASN1Dump.dumpAsString((Object)der);
        System.out.println(dump);
        FileOutputStream out = new FileOutputStream(new File(new File("/Desenvolvimento/max/pkcs7/"), file), false);
        out.write(dump.getBytes());
        out.close();
        DEROutputStream dout = new DEROutputStream((OutputStream)new FileOutputStream(new File(new File("/Desenvolvimento/max/pkcs7/"), String.valueOf(file) + ".p7"), false));
        dout.writeObject((Object)der);
        dout.close();
    }

    public static byte[] contentPKCS7Signature(byte[] sign, X509Certificate cert) throws IOException {
        ASN1Sequence certAsn1 = (ASN1Sequence)new ASN1InputStream((InputStream)new ByteArrayInputStream(sign)).readObject();
        SignedData signedData = new SignedData(certAsn1);
        DERSet derSet = (DERSet)signedData.getSignerInfos();
        SignerInfo signerinfo = (SignerInfo)derSet.getObjectAt(0);
        return null;
    }
}

