/*
 * Decompiled with CFR 0.152.
 */
package br.com.bb.cdg.assinador.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.security.Provider;
import java.security.Security;
import java.security.SignatureException;
import java.security.cert.CRLException;
import java.util.Arrays;
import org.bouncycastle.jce.PKCS7SignedData;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import sun.misc.BASE64Decoder;

class VerifyP7s {
    private static char[] Base64Map = new char[]{'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '+', '/', '='};

    VerifyP7s() {
    }

    public static void main(String[] args) {
        if (args.length < 2) {
            VerifyP7s.usage();
        }
        Security.addProvider((Provider)new BouncyCastleProvider());
        FileInputStream freader = null;
        File f = new File(args[1]);
        int sizecontent = (int)f.length();
        byte[] bytes = new byte[sizecontent];
        try {
            freader = new FileInputStream(f);
            System.out.print("\nContent Bytes: " + freader.read(bytes, 0, sizecontent));
            freader.close();
        }
        catch (IOException ioe) {
            System.out.println(ioe.toString());
            return;
        }
        File p7s = new File(args[0]);
        int size = (int)p7s.length();
        byte[] bytessig = new byte[size];
        try {
            freader = new FileInputStream(p7s);
            System.out.println("  PKCS#7 bytes: " + freader.read(bytessig, 0, size));
            freader.close();
        }
        catch (IOException ioe) {
            System.out.println(ioe.toString());
            return;
        }
        if (VerifyP7s.isBase64Encoded(bytessig)) {
            System.out.println("Signature file is BASE64 encoded");
            try {
                BASE64Decoder dec = new BASE64Decoder();
                byte[] bdecoded = dec.decodeBuffer(new String(bytessig));
                if (VerifyP7s.isVerified(bdecoded, bytes)) {
                    System.out.println("Verified pkcs#7 data: \"" + args[0] + "\" as BASE64-encoded DER file\n" + "against content file \"" + args[1] + "\"");
                }
                System.out.println("Failed to verify " + args[0] + " as valid pkcs#7 detached signature.");
            }
            catch (Exception exc) {
                System.out.println("Failed to verify " + args[0] + " as valid pkcs#7 detached signature.");
                return;
            }
        } else if (VerifyP7s.isVerified(bytessig, bytes)) {
            System.out.println("Verified pkcs#7 data: \"" + args[0] + "\" as binary DER file\n" + "against content file \"" + args[1] + "\"");
        } else {
            System.out.println("Failed to verify " + args[0] + " as valid pkcs#7 detached signature.");
        }
    }

    private static byte[] toUnicode(byte[] bytes) {
        byte[] ucbytes = new byte[2 * bytes.length];
        int j = 0;
        while (j < bytes.length) {
            ucbytes[2 * j] = bytes[j];
            ucbytes[2 * j + 1] = 0;
            ++j;
        }
        return ucbytes;
    }

    private static final boolean isVerified(byte[] sig, byte[] content) {
        block6: {
            PKCS7SignedData pkcs7 = new PKCS7SignedData(sig);
            pkcs7.update(content, 0, content.length);
            boolean verified = pkcs7.verify();
            if (verified) break block6;
            pkcs7 = new PKCS7SignedData(sig);
            pkcs7.update(VerifyP7s.toUnicode(content), 0, 2 * content.length);
            verified = pkcs7.verify();
            if (verified) {
                System.out.println("\nUNICODE-encoding of signed content was verified.");
                return true;
            }
            return false;
        }
        try {
            System.out.println("ANSI-encoding of signed content was verified.");
            return true;
        }
        catch (CRLException crle) {
            return false;
        }
        catch (SignatureException sigex) {
            return false;
        }
        catch (Exception secex) {
            return false;
        }
    }

    private static final boolean isBase64Encoded(byte[] data) {
        Arrays.sort(Base64Map);
        int i = 0;
        while (i < data.length) {
            if (Arrays.binarySearch(Base64Map, (char)data[i]) < 0 && !Character.isWhitespace((char)data[i])) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private static void usage() {
        System.out.println("Usage:\n java VerifyP7s  <pkcs #7 signature file> <contentfile> ");
        System.exit(1);
    }
}

