/*
 * Decompiled with CFR 0.152.
 */
package iaik.pkcs.pkcs11.objects;

import iaik.pkcs.pkcs11.Session;
import iaik.pkcs.pkcs11.TokenException;
import iaik.pkcs.pkcs11.objects.Attribute;
import iaik.pkcs.pkcs11.objects.Clock;
import iaik.pkcs.pkcs11.objects.HardwareFeatureTypeAttribute;
import iaik.pkcs.pkcs11.objects.LongAttribute;
import iaik.pkcs.pkcs11.objects.MonotonicCounter;
import iaik.pkcs.pkcs11.objects.Object;
import iaik.pkcs.pkcs11.wrapper.Constants;
import iaik.pkcs.pkcs11.wrapper.PKCS11Exception;

public class HardwareFeature
extends Object {
    protected static VendorDefinedHardwareFeatureBuilder vendorHardwareFeatureBuilder_;
    protected HardwareFeatureTypeAttribute hardwareFeatureType_;

    public HardwareFeature() {
        this.objectClass_.setLongValue(Object.ObjectClass.HW_FEATURE);
    }

    protected HardwareFeature(Session session, long objectHandle) throws TokenException {
        super(session, objectHandle);
        this.objectClass_.setLongValue(Object.ObjectClass.HW_FEATURE);
    }

    public static String getHardwareFeatureTypeName(Long hardwareFeatureType) {
        if (hardwareFeatureType == null) {
            throw new NullPointerException("Argument \"hardwareFeatureType\" must not be null.");
        }
        String hardwareFeatureTypeName = hardwareFeatureType.equals(FeatureType.MONOTONIC_COUNTER) ? "Monotonic Counter" : (hardwareFeatureType.equals(FeatureType.CLOCK) ? "Clock" : (hardwareFeatureType.equals(FeatureType.USER_INTERFACE) ? "User Interface" : ((hardwareFeatureType & FeatureType.VENDOR_DEFINED) != 0L ? "Vendor Defined" : "<unknown>")));
        return hardwareFeatureTypeName;
    }

    public static Object getInstance(Session session, long objectHandle) throws TokenException {
        if (session == null) {
            throw new NullPointerException("Argument \"session\" must not be null.");
        }
        HardwareFeatureTypeAttribute hardwareFeatureTypeAttribute = new HardwareFeatureTypeAttribute();
        HardwareFeature.getAttributeValue(session, objectHandle, hardwareFeatureTypeAttribute);
        Long hardwareFeatureType = hardwareFeatureTypeAttribute.getLongValue();
        Object newObject = hardwareFeatureTypeAttribute.isPresent() && hardwareFeatureType != null ? (hardwareFeatureType.equals(FeatureType.MONOTONIC_COUNTER) ? MonotonicCounter.getInstance(session, objectHandle) : (hardwareFeatureType.equals(FeatureType.CLOCK) ? Clock.getInstance(session, objectHandle) : (hardwareFeatureType.equals(FeatureType.USER_INTERFACE) ? HardwareFeature.getUnknownHardwareFeature(session, objectHandle) : ((hardwareFeatureType & FeatureType.VENDOR_DEFINED) != 0L ? HardwareFeature.getUnknownHardwareFeature(session, objectHandle) : HardwareFeature.getUnknownHardwareFeature(session, objectHandle))))) : HardwareFeature.getUnknownHardwareFeature(session, objectHandle);
        return newObject;
    }

    protected static Object getUnknownHardwareFeature(Session session, long objectHandle) throws TokenException {
        Object newObject;
        if (session == null) {
            throw new NullPointerException("Argument \"session\" must not be null.");
        }
        if (vendorHardwareFeatureBuilder_ != null) {
            try {
                newObject = vendorHardwareFeatureBuilder_.build(session, objectHandle);
            }
            catch (PKCS11Exception ex) {
                newObject = new HardwareFeature(session, objectHandle);
            }
        } else {
            newObject = new HardwareFeature(session, objectHandle);
        }
        return newObject;
    }

    public static void setVendorDefinedHardwareFeatureBuilder(VendorDefinedHardwareFeatureBuilder builder) {
        vendorHardwareFeatureBuilder_ = builder;
    }

    public static VendorDefinedHardwareFeatureBuilder getVendorDefinedHardwareFeatureBuilder() {
        return vendorHardwareFeatureBuilder_;
    }

    protected static void putAttributesInTable(HardwareFeature object) {
        if (object == null) {
            throw new NullPointerException("Argument \"object\" must not be null.");
        }
        object.attributeTable_.put(Attribute.HW_FEATURE_TYPE, object.hardwareFeatureType_);
    }

    protected void allocateAttributes() {
        super.allocateAttributes();
        this.hardwareFeatureType_ = new HardwareFeatureTypeAttribute();
        HardwareFeature.putAttributesInTable(this);
    }

    public java.lang.Object clone() {
        HardwareFeature clone = (HardwareFeature)super.clone();
        clone.hardwareFeatureType_ = (HardwareFeatureTypeAttribute)this.hardwareFeatureType_.clone();
        HardwareFeature.putAttributesInTable(clone);
        return clone;
    }

    public boolean equals(java.lang.Object otherObject) {
        boolean equal = false;
        if (otherObject instanceof HardwareFeature) {
            HardwareFeature other = (HardwareFeature)otherObject;
            equal = this == other || super.equals(other) && this.hardwareFeatureType_.equals(other.hardwareFeatureType_);
        }
        return equal;
    }

    public LongAttribute getHardwareFeatureType() {
        return this.hardwareFeatureType_;
    }

    public int hashCode() {
        return this.hardwareFeatureType_.hashCode();
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer(128);
        buffer.append(super.toString());
        buffer.append(Constants.NEWLINE);
        buffer.append("  ");
        buffer.append("Hardware Feature Type: ");
        if (this.hardwareFeatureType_ != null) {
            buffer.append(this.hardwareFeatureType_.toString());
        } else {
            buffer.append("<unavailable>");
        }
        return buffer.toString();
    }

    public static interface FeatureType {
        public static final Long MONOTONIC_COUNTER = new Long(1L);
        public static final Long CLOCK = new Long(2L);
        public static final Long USER_INTERFACE = new Long(3L);
        public static final Long VENDOR_DEFINED = new Long(0x80000000L);
    }

    public static interface VendorDefinedHardwareFeatureBuilder {
        public Object build(Session var1, long var2) throws PKCS11Exception;
    }
}

