/*
 * Decompiled with CFR 0.152.
 */
package br.com.politec.infra.dao;

import br.com.politec.generico.log.LogAbstrato;
import br.com.politec.generico.objeto.UtilObjeto;
import br.com.politec.infra.dao.DAO;
import br.com.politec.infra.seguranca.ControladorDeAcesso;
import br.com.politec.infra.transacao.Transacao;
import br.com.politec.infra.util.UtilLog;

public abstract class DAOAbstrato
implements DAO {
    private ControladorDeAcesso controladorDeAcesso;
    private boolean transacaoPrivada;

    protected abstract ControladorDeAcesso novoControladorDeAcesso();

    protected ControladorDeAcesso getControladorDeAcesso() {
        this.debugInit("getControladorDeAcesso");
        if (!this.isReferencia(this.controladorDeAcesso)) {
            this.controladorDeAcesso = this.novoControladorDeAcesso();
        }
        this.getLog().debug("ControladorDeAcesso: " + this.controladorDeAcesso);
        this.debugEnd("getControladorDeAcesso");
        return this.controladorDeAcesso;
    }

    protected void iniciarTransacao() {
        this.getControladorDeAcesso().iniciarTransacao();
    }

    protected void finalizarTransacao() {
        if (this.isTransacaoPrivada()) {
            this.getControladorDeAcesso().finalizarTransacao();
            this.setTransacaoPrivada(false);
        }
    }

    protected void commitTransacao() {
        if (this.isTransacaoPrivada()) {
            this.getControladorDeAcesso().commitTransacao();
        }
    }

    protected void rollbackTransacao() {
        if (this.isTransacaoPrivada()) {
            this.getControladorDeAcesso().rollbackTransacao();
        }
    }

    protected Transacao getTransacao() {
        this.debugInit("getTransacao");
        ControladorDeAcesso controladorDeAcesso = this.getControladorDeAcesso();
        Transacao transacao = controladorDeAcesso.getTransacao();
        this.getLog().debug("Transacao: " + transacao);
        if (this.isReferencia(controladorDeAcesso) && !this.isReferencia(transacao)) {
            this.getLog().debug("Transa\u00e7\u00e3o iniciada");
            this.iniciarTransacao();
            transacao = controladorDeAcesso.getTransacao();
            this.setTransacaoPrivada(true);
            this.getLog().debug("Transacao: " + transacao);
        }
        this.debugEnd("getTransacao");
        return transacao;
    }

    protected boolean isReferencia(Object objeto) {
        return UtilObjeto.isReferencia(objeto);
    }

    protected boolean isReferencia(Object objeto0, Object objeto1) {
        return UtilObjeto.isReferencia(objeto0, objeto1);
    }

    protected void debugInit(String metodo) {
        this.getLog().debugInit(this.getClass(), metodo);
    }

    protected void debugEnd(String metodo) {
        this.getLog().debugEnd(this.getClass(), metodo);
    }

    protected LogAbstrato getLog() {
        return UtilLog.getLog();
    }

    protected boolean isTransacaoPrivada() {
        return this.transacaoPrivada;
    }

    private void setTransacaoPrivada(boolean transacaoPrivada) {
        this.transacaoPrivada = transacaoPrivada;
    }
}

