/*
 * Decompiled with CFR 0.152.
 */
package br.com.politec.infra.fabrica;

import br.com.politec.generico.fabrica.ColecaoFactory;
import br.com.politec.generico.objeto.UtilObjeto;
import br.com.politec.infra.exception.PoolDeObjetosException;
import br.com.politec.infra.util.excecao.UtilPoolDeObjetosException;
import br.com.politec.reflexao.UtilReflexaoFabrica;
import br.com.politec.reflexao.exception.ReflexaoException;
import java.util.Map;

public class PoolDeObjetos {
    private static Map objetos;

    public Object getObjeto(Class tipo) throws PoolDeObjetosException {
        Object res = this.getObjetos().get(tipo);
        if (!UtilObjeto.isReferencia(res)) {
            res = this.novoObjeto(tipo);
            this.adicionarObjetoNoCache(tipo, res);
        }
        return res;
    }

    protected synchronized void adicionarObjetoNoCache(Class tipo, Object res) {
        if (UtilObjeto.isReferencia(res)) {
            this.getObjetos().put(tipo, res);
        }
    }

    protected Map getObjetos() {
        if (!UtilObjeto.isReferencia(objetos)) {
            objetos = this.getColecaoFactory().novoHashMap();
        }
        return objetos;
    }

    protected Object novoObjeto(Class tipo) throws PoolDeObjetosException {
        Object objeto = null;
        try {
            objeto = UtilReflexaoFabrica.novoObjeto(tipo);
        }
        catch (ReflexaoException e) {
            throw UtilPoolDeObjetosException.erroAoCriarObjeto(tipo, e);
        }
        return objeto;
    }

    protected ColecaoFactory getColecaoFactory() {
        return ColecaoFactory.getInstance();
    }
}

