/*
 * Decompiled with CFR 0.152.
 */
package br.com.politec.infra.seguranca;

import br.com.politec.generico.log.LogAbstrato;
import br.com.politec.generico.objeto.UtilObjeto;
import br.com.politec.infra.exception.InfraRuntimeException;
import br.com.politec.infra.fabrica.TransacaoFactory;
import br.com.politec.infra.transacao.Transacao;
import br.com.politec.infra.util.UtilLog;
import br.com.politec.infra.util.excecao.UtilInfraRuntimeException;
import java.io.Serializable;

public abstract class ControladorDeAcesso
implements Serializable {
    private static ThreadLocal threadLocal = new ThreadLocal();

    public Transacao getTransacao() {
        return this.getProfile().getTransacao();
    }

    public void setProfile(Profile profile) {
        this.getThreadLocal().set(profile);
    }

    public Transacao iniciarTransacao() {
        Transacao transacao = null;
        if (!UtilObjeto.isReferencia(this.getTransacao())) {
            transacao = this.novaTransacao();
            this.getProfile().setTransacao(transacao);
        }
        return transacao;
    }

    public void finalizarTransacao() {
        if (UtilObjeto.isReferencia(this.getTransacao())) {
            this.getTransacao().finalizar();
            this.getProfile().setTransacao(null);
        }
    }

    public void commitTransacao() {
        if (UtilObjeto.isReferencia(this.getTransacao())) {
            this.getTransacao().commit();
        }
    }

    public void rollbackTransacao() {
        if (UtilObjeto.isReferencia(this.getTransacao())) {
            this.getTransacao().rollback();
        }
    }

    public boolean isExisteProfile() {
        boolean existe = false;
        try {
            Profile profile = (Profile)this.getThreadLocal().get();
            existe = UtilObjeto.isReferencia(profile);
        }
        catch (Exception e) {
            this.getLog().warn(e);
        }
        return existe;
    }

    protected abstract Transacao novaTransacao() throws InfraRuntimeException;

    protected Profile getProfile() {
        Profile profile = (Profile)this.getThreadLocal().get();
        if (!UtilObjeto.isReferencia(profile)) {
            throw UtilInfraRuntimeException.profileInexistente();
        }
        return profile;
    }

    protected TransacaoFactory getTransacaoFactory() {
        return TransacaoFactory.getInstancia();
    }

    protected LogAbstrato getLog() {
        return UtilLog.getLog();
    }

    private ThreadLocal getThreadLocal() {
        return threadLocal;
    }

    public abstract class Profile
    implements Serializable {
        private Transacao transacao;

        protected Transacao getTransacao() {
            return this.transacao;
        }

        protected void setTransacao(Transacao transacao) {
            this.transacao = transacao;
        }
    }
}

