/*
 * Decompiled with CFR 0.152.
 */
package br.com.politec.infra.servicelocator;

import br.com.politec.generico.string.UtilString;
import br.com.politec.infra.constante.Contexto;
import br.com.politec.infra.exception.ServiceLocatorException;
import br.com.politec.infra.servicelocator.ServiceLocatorAbstrato;
import br.com.politec.infra.util.excecao.UtilServiceLocatorException;
import br.com.politec.reflexao.UtilReflexaoInvocarMetodo;
import br.com.politec.reflexao.exception.ReflexaoException;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.ejb.EJBHome;
import javax.ejb.EJBObject;
import javax.naming.Context;
import javax.naming.NameClassPair;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.rmi.PortableRemoteObject;
import javax.sql.DataSource;

public class ServiceLocator
extends ServiceLocatorAbstrato {
    public Context getContexto(String contexto) {
        Context resposta = this.getContexto();
        try {
            if (!UtilString.isVazio(contexto)) {
                resposta = (Context)resposta.lookup(contexto);
            }
        }
        catch (NamingException e) {
            throw UtilServiceLocatorException.jndiNameNaoEncontrado(contexto);
        }
        return resposta;
    }

    public Object getServico(String contexto, String jndi) {
        Object resultado = null;
        if (!UtilString.isVazio(jndi)) {
            try {
                if (this.isObjetoEmCache(jndi)) {
                    resultado = this.recuperarObjetoDoCache(jndi);
                } else {
                    resultado = this.getContexto(contexto).lookup(jndi);
                    this.adicionarObjetoNoCache(jndi, resultado);
                }
            }
            catch (NamingException e) {
                throw UtilServiceLocatorException.jndiNameNaoEncontrado(jndi);
            }
        }
        return resultado;
    }

    public Object getServico(String jndi) {
        return this.getServico(null, jndi);
    }

    public Collection getNomeDosServicos(String contexto) {
        List resultado = this.novoArrayList();
        if (!UtilString.isVazio(contexto)) {
            try {
                NameClassPair env = null;
                String nome = null;
                NamingEnumeration<NameClassPair> iterator = this.getContexto().list(contexto);
                while (this.isReferencia(iterator) && iterator.hasMoreElements()) {
                    env = (NameClassPair)iterator.nextElement();
                    nome = env.getName();
                    nome = UtilString.remover(nome, contexto + "/");
                    resultado.add(nome);
                }
            }
            catch (NamingException e) {
                throw UtilServiceLocatorException.jndiNameNaoEncontrado(contexto);
            }
        }
        return resultado;
    }

    public Collection getNomeDosServicos() {
        return this.getNomeDosServicos(Contexto.getContextoEnv());
    }

    public Map getServicos(String contexto) {
        Map resultado = this.novoHashMap();
        if (!UtilString.isVazio(contexto)) {
            String nome = null;
            Object valor = null;
            Collection colecao = this.getNomeDosServicos(contexto);
            Iterator iterator = this.getColecaoFactory().novoIterator(colecao);
            while (iterator.hasNext()) {
                nome = (String)iterator.next();
                valor = this.getServico(contexto, nome);
                resultado.put(nome, valor);
            }
        }
        return resultado;
    }

    public Map getServicos() throws ServiceLocatorException {
        return this.getServicos(Contexto.getContextoEnv());
    }

    public String getString(String contexto, String jndi) {
        return (String)this.getServico(contexto, jndi);
    }

    public String getString(String jndi) throws ServiceLocatorException {
        return this.getString(null, jndi);
    }

    public Integer getInteger(String contexto, String jndi) {
        return (Integer)this.getServico(contexto, jndi);
    }

    public Integer getInteger(String jndi) throws ServiceLocatorException {
        return this.getInteger(null, jndi);
    }

    public DataSource getDataSource(String contexto, String jndi) {
        return (DataSource)this.getServico(contexto, jndi);
    }

    public DataSource getDataSource(String jndi) {
        return this.getDataSource(null, jndi);
    }

    public Connection getConexao(String contexto, String jndi) {
        Connection connection = null;
        try {
            DataSource dataSource = this.getDataSource(contexto, jndi);
            if (this.isReferencia(dataSource)) {
                connection = dataSource.getConnection();
                connection.setAutoCommit(false);
            }
        }
        catch (SQLException e) {
            throw UtilServiceLocatorException.conexaoNaoEfetuada(jndi, e);
        }
        return connection;
    }

    public Connection getConexao(String jndi) {
        return this.getConexao(null, jndi);
    }

    public EJBHome getEJBHomeRemoto(String jndi, Class tipoHome) {
        Object resultado = null;
        if (!UtilString.isVazio(jndi) && this.isReferencia(tipoHome)) {
            Object obj = this.getServico(jndi);
            resultado = PortableRemoteObject.narrow((Object)obj, (Class)tipoHome);
        }
        return (EJBHome)resultado;
    }

    public EJBObject getEJBObjetoRemoto(String jndi, Class tipoHome) {
        Object resultado = null;
        try {
            EJBHome home = this.getEJBHomeRemoto(jndi, tipoHome);
            resultado = UtilReflexaoInvocarMetodo.invocar((Object)home, "create");
        }
        catch (ReflexaoException e) {
            throw UtilServiceLocatorException.erro(e);
        }
        return (EJBObject)resultado;
    }
}

