/*
 * Decompiled with CFR 0.152.
 */
package br.com.politec.infra.transacao;

import br.com.politec.infra.exception.TransacaoException;
import br.com.politec.infra.transacao.TransacaoAbstrato;
import br.com.politec.infra.util.excecao.UtilTransacaoException;
import java.sql.Connection;
import java.sql.SQLException;

public class TransacaoJDBC
extends TransacaoAbstrato {
    public void iniciar() throws TransacaoException {
        try {
            this.castConexao().setAutoCommit(false);
        }
        catch (SQLException e) {
            throw UtilTransacaoException.transacaoNaoIniciada(e);
        }
    }

    public void commit() throws TransacaoException {
        try {
            this.castConexao().commit();
        }
        catch (SQLException e) {
            throw UtilTransacaoException.erroAoEfetuarOCommit(e);
        }
    }

    public void rollback() {
        try {
            this.castConexao().rollback();
        }
        catch (SQLException e) {
            this.getLog().warn("Erro ao efetuar rollback na conex\u00e3o.", e);
        }
        catch (TransacaoException e) {
            this.getLog().warn(e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void finalizar() {
        try {
            this.castConexao().close();
        }
        catch (SQLException e) {
            this.getLog().warn("Erro ao fechar a conex\u00e3o.", e);
        }
        catch (TransacaoException e) {
            this.getLog().warn(e.getMessage());
        }
        finally {
            this.setConexao(null);
        }
    }

    private Connection castConexao() throws TransacaoException {
        return (Connection)this.getConexao();
    }
}

