/*
 * Decompiled with CFR 0.152.
 */
package br.com.politec.infra.util.excecao;

import br.com.politec.generico.excecao.ExceptionAbstrato;
import br.com.politec.generico.excecao.UtilExcecaoAbstrato;
import br.com.politec.generico.log.LogAbstrato;
import br.com.politec.infra.constante.MensagemID;
import br.com.politec.infra.exception.InfraException;
import br.com.politec.infra.util.UtilLog;
import br.com.politec.infra.util.UtilMensagem;
import javax.servlet.jsp.JspException;

public final class UtilInfraException
extends UtilExcecaoAbstrato {
    private UtilInfraException() {
    }

    public static InfraException erro(Throwable e) {
        String chave = MensagemID.getErro();
        String mensagem = UtilInfraException.getMensagem(e);
        return UtilInfraException.converter(UtilInfraException.novaExcecao(e, chave, mensagem));
    }

    public static JspException erroAoImprimirTag(String texto, Throwable e) {
        String chave = MensagemID.getErroAoImprimirTag();
        String erro = UtilInfraException.getMensagem(e);
        JspException excecao = new JspException(UtilInfraException.getMensagem(chave, texto, erro));
        UtilInfraException.logDeErro((Throwable)excecao);
        return excecao;
    }

    public static JspException erroNaTag(Exception e) {
        String chave = MensagemID.getErro();
        String erro = UtilInfraException.getMensagem(e);
        JspException excecao = new JspException(UtilInfraException.getMensagem(chave, erro));
        UtilInfraException.logDeErro((Throwable)excecao);
        return excecao;
    }

    private static InfraException converter(ExceptionAbstrato e) {
        InfraException excecao = new InfraException(e);
        UtilInfraException.logDeErro(excecao);
        return excecao;
    }

    private static void logDeErro(Throwable excecao) {
        UtilInfraException.getLog().error("Ocorreu um erro", excecao);
    }

    private static String getMensagem(String chave, String arg0, String arg1) {
        UtilMensagem mensagem = UtilMensagem.getInstancia();
        return mensagem.getMensagem(chave, arg0, arg1);
    }

    private static String getMensagem(String chave, String arg0) {
        UtilMensagem mensagem = UtilMensagem.getInstancia();
        return mensagem.getMensagem(chave, arg0);
    }

    private static LogAbstrato getLog() {
        return UtilLog.getLog();
    }
}

