/*
 * Decompiled with CFR 0.152.
 */
package br.com.politec.infra.util.excecao;

import br.com.politec.generico.excecao.RuntimeExceptionAbstrato;
import br.com.politec.generico.excecao.UtilRuntimeExcecaoAbstrato;
import br.com.politec.generico.log.LogAbstrato;
import br.com.politec.infra.constante.MensagemID;
import br.com.politec.infra.exception.ServiceLocatorException;
import br.com.politec.infra.util.UtilLog;
import java.sql.SQLException;
import javax.naming.NamingException;

public final class UtilServiceLocatorException
extends UtilRuntimeExcecaoAbstrato {
    private UtilServiceLocatorException() {
    }

    public static ServiceLocatorException erro(Throwable e) {
        String chave = MensagemID.getErro();
        String mensagem = UtilServiceLocatorException.getMensagem(e);
        return UtilServiceLocatorException.converter(UtilServiceLocatorException.novaExcecao(e, chave, mensagem));
    }

    public static ServiceLocatorException jndiNameNaoEncontrado(String jndiName) {
        String chave = MensagemID.getJndiNameNaoEncontrado();
        return UtilServiceLocatorException.converter(UtilServiceLocatorException.novaExcecao(chave, jndiName));
    }

    public static ServiceLocatorException conexaoNaoEfetuada(String jndiName, SQLException e) {
        String chave = MensagemID.getConexaoNaoEfetuada();
        String erro = UtilServiceLocatorException.getMensagem(e);
        return UtilServiceLocatorException.converter(UtilServiceLocatorException.novaExcecao(e, chave, jndiName, erro));
    }

    public static ServiceLocatorException erroAoCriarContexto(NamingException e) {
        String chave = MensagemID.getErroAoCriarContexto();
        String erro = UtilServiceLocatorException.getMensagem(e);
        return UtilServiceLocatorException.converter(UtilServiceLocatorException.novaExcecao(e, chave, erro));
    }

    private static ServiceLocatorException converter(RuntimeExceptionAbstrato e) {
        ServiceLocatorException excecao = new ServiceLocatorException(e);
        UtilServiceLocatorException.getLog().error("Ocorreu um erro", excecao);
        return excecao;
    }

    private static LogAbstrato getLog() {
        return UtilLog.getLog();
    }
}

