/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.cfg.reveng.dialect;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.hibernate.cfg.reveng.dialect.MetaDataDialect;
import org.hibernate.connection.ConnectionProvider;
import org.hibernate.exception.SQLExceptionConverter;

public class CachedMetaDataDialect
implements MetaDataDialect {
    MetaDataDialect delegate;
    private Map cachedTables = new HashMap();
    private Map cachedColumns = new HashMap();
    private Map cachedExportedKeys = new HashMap();
    private Map cachedPrimaryKeys = new HashMap();
    private Map cachedIndexInfo = new HashMap();

    public CachedMetaDataDialect(MetaDataDialect realMetaData) {
        this.delegate = realMetaData;
    }

    public void close() {
        this.delegate.close();
    }

    public void close(Iterator iterator) {
        CachedIterator ci;
        if (iterator instanceof CachedIterator && (ci = (CachedIterator)iterator).getOwner() == this) {
            ci.store();
            return;
        }
        this.delegate.close(iterator);
    }

    public void configure(ConnectionProvider provider, SQLExceptionConverter sec) {
        this.delegate.configure(provider, sec);
    }

    public Iterator getColumns(String catalog, String schema, String table, String column) {
        StringKey sk = new StringKey(new String[]{catalog, schema, table, column});
        ArrayList cached = (ArrayList)this.cachedColumns.get(sk);
        if (cached == null) {
            cached = new ArrayList();
            return new CachedIterator(this, this.cachedColumns, sk, cached, this.delegate.getColumns(catalog, schema, table, column));
        }
        return cached.iterator();
    }

    public Iterator getExportedKeys(String catalog, String schema, String table) {
        StringKey sk = new StringKey(new String[]{catalog, schema, table});
        ArrayList cached = (ArrayList)this.cachedExportedKeys.get(sk);
        if (cached == null) {
            cached = new ArrayList();
            return new CachedIterator(this, this.cachedExportedKeys, sk, cached, this.delegate.getExportedKeys(catalog, schema, table));
        }
        return cached.iterator();
    }

    public Iterator getIndexInfo(String catalog, String schema, String table) {
        StringKey sk = new StringKey(new String[]{catalog, schema, table});
        ArrayList cached = (ArrayList)this.cachedIndexInfo.get(sk);
        if (cached == null) {
            cached = new ArrayList();
            return new CachedIterator(this, this.cachedIndexInfo, sk, cached, this.delegate.getIndexInfo(catalog, schema, table));
        }
        return cached.iterator();
    }

    public Iterator getPrimaryKeys(String catalog, String schema, String name) {
        StringKey sk = new StringKey(new String[]{catalog, schema, name});
        ArrayList cached = (ArrayList)this.cachedPrimaryKeys.get(sk);
        if (cached == null) {
            cached = new ArrayList();
            return new CachedIterator(this, this.cachedPrimaryKeys, sk, cached, this.delegate.getPrimaryKeys(catalog, schema, name));
        }
        return cached.iterator();
    }

    public Iterator getTables(String catalog, String schema, String table) {
        StringKey sk = new StringKey(new String[]{catalog, schema, table});
        ArrayList cached = (ArrayList)this.cachedTables.get(sk);
        if (cached == null) {
            cached = new ArrayList();
            return new CachedIterator(this, this.cachedTables, sk, cached, this.delegate.getTables(catalog, schema, table));
        }
        return cached.iterator();
    }

    public boolean needQuote(String name) {
        return this.delegate.needQuote(name);
    }

    public Iterator getSuggestedPrimaryKeyStrategyName(String catalog, String schema, String name) {
        return this.delegate.getSuggestedPrimaryKeyStrategyName(catalog, schema, name);
    }

    private static class CachedIterator
    implements Iterator {
        private List cache;
        private StringKey target;
        private Map destination;
        private Iterator realIterator;
        final CachedMetaDataDialect owner;

        public CachedIterator(CachedMetaDataDialect owner, Map destination, StringKey sk, List cache, Iterator realIterator) {
            this.owner = owner;
            this.destination = destination;
            this.target = sk;
            this.realIterator = realIterator;
            this.cache = cache;
        }

        public CachedMetaDataDialect getOwner() {
            return this.owner;
        }

        public boolean hasNext() {
            return this.realIterator.hasNext();
        }

        public Object next() {
            Map map = (Map)this.realIterator.next();
            this.cache.add(new HashMap(map));
            return map;
        }

        public void remove() {
            this.realIterator.remove();
        }

        public void store() {
            this.destination.put(this.target, this.cache);
            this.cache = null;
            this.target = null;
            this.destination = null;
            this.realIterator = null;
        }
    }

    private static class StringKey {
        String[] keys;

        StringKey(String[] key) {
            this.keys = key;
        }

        public int hashCode() {
            if (this.keys == null) {
                return 0;
            }
            int result = 1;
            for (int i = 0; i < this.keys.length; ++i) {
                String element = this.keys[i];
                result = 31 * result + (element == null ? 0 : element.hashCode());
            }
            return result;
        }

        public boolean equals(Object obj) {
            StringKey other = (StringKey)obj;
            String[] otherKeys = other.keys;
            if (otherKeys.length != this.keys.length) {
                return false;
            }
            for (int i = otherKeys.length - 1; i >= 0; --i) {
                if (this.safeEquals(otherKeys[i], this.keys[i])) continue;
                return false;
            }
            return true;
        }

        private boolean safeEquals(Object obj1, Object obj2) {
            if (obj1 == null) {
                return obj2 == null;
            }
            return obj1.equals(obj2);
        }
    }
}

