/*
 * Decompiled with CFR 0.152.
 */
package org.jopendocument.dom;

import java.util.HashSet;
import java.util.Set;
import org.jopendocument.dom.ContentType;
import org.jopendocument.dom.XMLVersion;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum ContentTypeVersioned {
    TEXT_V1(ContentType.TEXT, XMLVersion.OOo, "application/vnd.sun.xml.writer", "text", "sxw"){}
    ,
    GRAPHICS_V1(ContentType.GRAPHICS, XMLVersion.OOo, "application/vnd.sun.xml.draw", "drawing", "sxd"){}
    ,
    PRESENTATION_V1(ContentType.PRESENTATION, XMLVersion.OOo, "application/vnd.sun.xml.impress", "presentation", "sxi"){}
    ,
    SPREADSHEET_V1(ContentType.SPREADSHEET, XMLVersion.OOo, "application/vnd.sun.xml.calc", "spreadsheet", "sxc"){}
    ,
    TEXT(ContentType.TEXT, XMLVersion.OD, "application/vnd.oasis.opendocument.text", "text", "odt"){}
    ,
    TEXT_TEMPLATE(ContentType.TEXT, XMLVersion.OD, "application/vnd.oasis.opendocument.text-template", "text", "ott"){}
    ,
    GRAPHICS(ContentType.GRAPHICS, XMLVersion.OD, "application/vnd.oasis.opendocument.graphics", "drawing", "odg"){}
    ,
    GRAPHICS_TEMPLATE(ContentType.GRAPHICS, XMLVersion.OD, "application/vnd.oasis.opendocument.graphics-template", "drawing", "otg"){}
    ,
    PRESENTATION(ContentType.PRESENTATION, XMLVersion.OD, "application/vnd.oasis.opendocument.presentation", "presentation", "odp"){}
    ,
    PRESENTATION_TEMPLATE(ContentType.PRESENTATION, XMLVersion.OD, "application/vnd.oasis.opendocument.presentation-template", "presentation", "otp"){}
    ,
    SPREADSHEET(ContentType.SPREADSHEET, XMLVersion.OD, "application/vnd.oasis.opendocument.spreadsheet", "spreadsheet", "ods"){}
    ,
    SPREADSHEET_TEMPLATE(ContentType.SPREADSHEET, XMLVersion.OD, "application/vnd.oasis.opendocument.spreadsheet-template", "spreadsheet", "ots"){};

    private final ContentType type;
    private final XMLVersion version;
    private final String mimeType;
    private final String shortName;
    private final String extension;

    private ContentTypeVersioned(ContentType contentType, XMLVersion xMLVersion, String string2, String string3, String string4) {
        this.type = contentType;
        this.mimeType = string2;
        this.version = xMLVersion;
        this.shortName = string3;
        this.extension = string4;
    }

    public final XMLVersion getVersion() {
        return this.version;
    }

    public final String getShortName() {
        return this.shortName;
    }

    public final String getMimeType() {
        return this.mimeType;
    }

    public final ContentType getType() {
        return this.type;
    }

    public final String getExtension() {
        return this.extension;
    }

    public static ContentTypeVersioned fromType(ContentType contentType, XMLVersion xMLVersion) {
        for (ContentTypeVersioned contentTypeVersioned : ContentTypeVersioned.fromType(contentType)) {
            if (contentTypeVersioned.getVersion() != xMLVersion) continue;
            return contentTypeVersioned;
        }
        return null;
    }

    public static Set<ContentTypeVersioned> fromType(ContentType contentType) {
        HashSet<ContentTypeVersioned> hashSet = new HashSet<ContentTypeVersioned>();
        for (ContentTypeVersioned contentTypeVersioned : ContentTypeVersioned.values()) {
            if (!contentTypeVersioned.getType().equals((Object)contentType)) continue;
            hashSet.add(contentTypeVersioned);
        }
        return hashSet;
    }

    public static ContentTypeVersioned fromMime(String string) {
        for (ContentTypeVersioned contentTypeVersioned : ContentTypeVersioned.values()) {
            if (!contentTypeVersioned.getMimeType().equals(string)) continue;
            return contentTypeVersioned;
        }
        return null;
    }

    static ContentTypeVersioned fromClass(String string) {
        return ContentTypeVersioned.fromShortName(XMLVersion.OOo, string);
    }

    static ContentTypeVersioned fromBody(String string) {
        return ContentTypeVersioned.fromShortName(XMLVersion.OD, string);
    }

    private static ContentTypeVersioned fromShortName(XMLVersion xMLVersion, String string) {
        if (string == null) {
            throw new NullPointerException();
        }
        for (ContentTypeVersioned contentTypeVersioned : ContentTypeVersioned.values()) {
            if (!contentTypeVersioned.shortName.equals(string) || contentTypeVersioned.getVersion() != xMLVersion) continue;
            return contentTypeVersioned;
        }
        return null;
    }
}

