/*
 * Decompiled with CFR 0.152.
 */
package org.jopendocument.dom;

import java.util.HashMap;
import java.util.Map;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.Namespace;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum XMLVersion {
    OOo("OpenOffice.org", Namespace.getNamespace("manifest", "http://openoffice.org/2001/manifest")){
        {
            this.putMandatory(XMLVersion.OFFICE_1, XMLVersion.STYLE_1, XMLVersion.TEXT_1, XMLVersion.TABLE_1);
            this.put("number", XMLVersion.NUMBER_1);
            this.put("draw", XMLVersion.DRAW_1);
            this.put("number", XMLVersion.NUMBER_1);
            this.put("fo", XMLVersion.FO_1);
            this.put("form", "http://openoffice.org/2000/form");
            this.put("xlink", "http://www.w3.org/1999/xlink");
            this.put("script", "http://openoffice.org/2000/script");
            this.put("svg", "http://www.w3.org/2000/svg");
            this.put("meta", "http://openoffice.org/2000/meta");
            this.put("dc", "http://purl.org/dc/elements/1.1/");
        }
    }
    ,
    OD("OpenDocument", Namespace.getNamespace("manifest", "urn:oasis:names:tc:opendocument:xmlns:manifest:1.0")){
        {
            this.putMandatory(XMLVersion.OFFICE_2, XMLVersion.STYLE_2, XMLVersion.TEXT_2, XMLVersion.TABLE_2);
            this.put("number", XMLVersion.NUMBER_2);
            this.put("draw", XMLVersion.DRAW_2);
            this.put("number", XMLVersion.NUMBER_2);
            this.put("fo", XMLVersion.FO_2);
            this.put("form", "urn:oasis:names:tc:opendocument:xmlns:form:1.0");
            this.put("xlink", "http://www.w3.org/1999/xlink");
            this.put("script", "urn:oasis:names:tc:opendocument:xmlns:script:1.0");
            this.put("svg", "urn:oasis:names:tc:opendocument:xmlns:svg-compatible:1.0");
            this.put("meta", "urn:oasis:names:tc:opendocument:xmlns:meta:1.0");
            this.put("dc", "http://purl.org/dc/elements/1.1/");
        }
    };

    private static final String OFFICE_1 = "http://openoffice.org/2000/office";
    private static final String STYLE_1 = "http://openoffice.org/2000/style";
    private static final String TEXT_1 = "http://openoffice.org/2000/text";
    private static final String NUMBER_1 = "http://openoffice.org/2000/datastyle";
    private static final String TABLE_1 = "http://openoffice.org/2000/table";
    private static final String DRAW_1 = "http://openoffice.org/2000/drawing";
    private static final String FO_1 = "http://www.w3.org/1999/XSL/Format";
    private static final String OFFICE_2 = "urn:oasis:names:tc:opendocument:xmlns:office:1.0";
    private static final String STYLE_2 = "urn:oasis:names:tc:opendocument:xmlns:style:1.0";
    private static final String TEXT_2 = "urn:oasis:names:tc:opendocument:xmlns:text:1.0";
    private static final String NUMBER_2 = "urn:oasis:names:tc:opendocument:xmlns:datastyle:1.0";
    private static final String TABLE_2 = "urn:oasis:names:tc:opendocument:xmlns:table:1.0";
    private static final String DRAW_2 = "urn:oasis:names:tc:opendocument:xmlns:drawing:1.0";
    private static final String FO_2 = "urn:oasis:names:tc:opendocument:xmlns:xsl-fo-compatible:1.0";
    private static XMLVersion defaultNS;
    private final String name;
    private final Map<String, Namespace> nss;
    private final Namespace manifest;

    private XMLVersion(String string2, Namespace namespace) {
        this.name = string2;
        this.nss = new HashMap<String, Namespace>(16);
        this.manifest = namespace;
    }

    protected final void putMandatory(String string, String string2, String string3, String string4) {
        this.put("office", string);
        this.put("style", string2);
        this.put("text", string3);
        this.put("table", string4);
    }

    protected final void put(String string, String string2) {
        this.nss.put(string, Namespace.getNamespace(string, string2));
    }

    public final Namespace getNS(String string) {
        if (!this.nss.containsKey(string)) {
            throw new IllegalStateException("unknown " + string + " : " + this.nss.keySet());
        }
        return this.nss.get(string);
    }

    public final String getName() {
        return this.name;
    }

    public final Namespace getManifest() {
        return this.manifest;
    }

    public Namespace getOFFICE() {
        return this.getNS("office");
    }

    public Namespace getSTYLE() {
        return this.getNS("style");
    }

    public Namespace getTEXT() {
        return this.getNS("text");
    }

    public Namespace getTABLE() {
        return this.getNS("table");
    }

    public Namespace getMETA() {
        return this.getNS("meta");
    }

    public Namespace[] getALL() {
        return this.nss.values().toArray(new Namespace[this.nss.size()]);
    }

    public static final XMLVersion getOOo() {
        return OOo;
    }

    public static final XMLVersion getOD() {
        return OD;
    }

    public static final XMLVersion getParent(Namespace namespace) {
        for (XMLVersion xMLVersion : XMLVersion.values()) {
            if (!xMLVersion.getNS(namespace.getPrefix()).equals(namespace)) continue;
            return xMLVersion;
        }
        return null;
    }

    public static final XMLVersion getVersion(Document document) {
        return XMLVersion.getVersion(document.getRootElement());
    }

    public static final XMLVersion getVersion(Element element) {
        XMLVersion xMLVersion = XMLVersion.getParent(element.getNamespace());
        if (xMLVersion == null) {
            throw new IllegalArgumentException(element + " is not an OpenOffice element.");
        }
        return xMLVersion;
    }

    public static void setDefault(XMLVersion xMLVersion) {
        defaultNS = xMLVersion;
    }

    public static XMLVersion getDefault() {
        return defaultNS;
    }

    static {
        defaultNS = OD;
    }
}

