/*
 * Decompiled with CFR 0.152.
 */
package org.jopendocument.dom.template.engine;

import java.io.File;
import org.jdom.Document;
import org.jdom.Element;
import org.jopendocument.dom.ODPackage;
import org.jopendocument.dom.ODXMLDocument;
import org.jopendocument.dom.XMLVersion;
import org.jopendocument.util.CopyUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Material<W>
implements Cloneable {
    private final W whole;
    private final Element root;
    private File base;

    private static final <Whole> Material<Whole> from(Whole Whole) {
        if (Whole instanceof Document) {
            return Material.from((Document)Whole);
        }
        if (Whole instanceof ODXMLDocument) {
            return Material.from((ODXMLDocument)Whole);
        }
        if (Whole instanceof ODPackage) {
            return Material.from((ODPackage)Whole);
        }
        return Material.from((Element)Whole);
    }

    public static final Material<Document> from(Document document) {
        return new Material<Document>(document, document.hasRootElement() ? document.getRootElement() : null);
    }

    public static final Material<Element> from(Element element) {
        return new Material<Element>(element, element);
    }

    public static final <E extends ODXMLDocument> Material<E> from(E e) {
        return new Material<E>(e, e.getDocument().getRootElement());
    }

    public static final <E extends ODPackage> Material<E> from(E e) {
        Material<E> material = new Material<E>(e, e.getContent().getDocument().getRootElement());
        material.setBase(e.getFile());
        return material;
    }

    private Material(W w, Element element) {
        this.whole = w;
        this.root = element;
        this.base = null;
    }

    public Element getRoot() {
        return this.root;
    }

    public boolean hasRoot() {
        return this.getRoot() != null;
    }

    public W getWhole() {
        return this.whole;
    }

    public XMLVersion getNS() {
        return XMLVersion.getVersion(this.getRoot());
    }

    public Material<W> clone() {
        Material<W> material = Material.from(CopyUtils.copy(this.getWhole()));
        material.setBase(this.getBase());
        return material;
    }

    public File getBase() {
        return this.base;
    }

    public void setBase(File file) {
        this.base = file;
    }
}

