/*
 * Decompiled with CFR 0.152.
 */
package org.jopendocument.dom.text;

import java.util.HashSet;
import java.util.Set;
import org.jdom.Attribute;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.xpath.XPath;
import org.jopendocument.dom.ODSingleXMLDocument;
import org.jopendocument.dom.XMLVersion;
import org.jopendocument.dom.text.ParagraphStyle;
import org.jopendocument.dom.text.TextNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Paragraph
extends TextNode<ParagraphStyle> {
    private static XPath textStylesPath = null;

    static Element createEmpty(XMLVersion xMLVersion) {
        return new Element("p", xMLVersion.getTEXT());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Set<String> getTextStyles(Element element) {
        HashSet<String> hashSet = new HashSet<String>();
        Class<Paragraph> clazz = Paragraph.class;
        synchronized (Paragraph.class) {
            if (textStylesPath == null) {
                try {
                    textStylesPath = XPath.newInstance(".//text:span/@text:style-name");
                }
                catch (JDOMException jDOMException) {
                    throw new IllegalStateException(jDOMException);
                }
            }
            try {
                for (Object e : textStylesPath.selectNodes(element)) {
                    hashSet.add(((Attribute)e).getValue());
                }
            }
            catch (JDOMException jDOMException) {
                throw new IllegalArgumentException("could'nt evaluate with " + element, jDOMException);
            }
            return hashSet;
        }
    }

    public Paragraph(Element element) {
        super(element, ParagraphStyle.class);
    }

    public Paragraph(XMLVersion xMLVersion) {
        this(Paragraph.createEmpty(xMLVersion));
    }

    public Paragraph() {
        this(XMLVersion.getDefault());
    }

    public Paragraph(String string) {
        this();
        this.addContent(string);
    }

    public final void setStyle(String string) {
        this.getElement().setAttribute("style-name", string, this.getElement().getNamespace());
    }

    public final void addContent(String string) {
        this.getElement().addContent(string);
    }

    public final void addTab() {
        this.getElement().addContent(new Element("tab", this.getElement().getNamespace()));
    }

    public final void addStyledContent(String string, String string2) {
        if (string2.equals(this.getStyleName())) {
            this.addContent(string);
        } else {
            Element element = new Element("span", this.getElement().getNamespace());
            element.setAttribute("style-name", string2, this.getElement().getNamespace());
            element.addContent(string);
            this.getElement().addContent(element);
        }
    }

    private final Set<String> getUsedTextStyles() {
        return Paragraph.getTextStyles(this.getElement());
    }

    @Override
    protected void checkDocument(ODSingleXMLDocument oDSingleXMLDocument) {
        if (this.getStyleName() != null && this.getStyle(oDSingleXMLDocument.getPackage(), oDSingleXMLDocument.getDocument()) == null) {
            throw new IllegalArgumentException("unknown style " + this.getStyleName() + " in " + oDSingleXMLDocument);
        }
        for (String string : this.getUsedTextStyles()) {
            if (oDSingleXMLDocument.getStyle("text", string) != null) continue;
            throw new IllegalArgumentException(this + " is using a text:span with an undefined style : " + string);
        }
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + " " + this.getElement().getText();
    }
}

