/*
 * Decompiled with CFR 0.152.
 */
package org.jopendocument.renderer;

import java.awt.Graphics2D;
import java.awt.Image;
import java.util.List;
import org.jopendocument.model.draw.DrawFrame;
import org.jopendocument.model.draw.DrawImage;
import org.jopendocument.model.style.StyleTableCellProperties;
import org.jopendocument.model.table.TableTableCell;
import org.jopendocument.renderer.ODTCellRenderer;
import org.jopendocument.util.ValueHelper;

public class ODTCellImageRenderer
implements ODTCellRenderer {
    boolean maxResolution;

    public void setPaintMaxResolution(boolean bl) {
        this.maxResolution = bl;
    }

    public void draw(Graphics2D graphics2D, int n, int n2, int n3, int n4, double d, TableTableCell tableTableCell, StyleTableCellProperties styleTableCellProperties) {
        List<DrawFrame> list = tableTableCell.getDrawFrames();
        if (list != null) {
            for (DrawFrame drawFrame : list) {
                DrawImage drawImage = drawFrame.getDrawImage();
                if (drawImage == null) continue;
                double d2 = (double)ValueHelper.getLength(drawFrame.getSvgX()) / d;
                double d3 = (double)ValueHelper.getLength(drawFrame.getSvgY()) / d;
                double d4 = (double)ValueHelper.getLength(drawFrame.getSvgWidth()) / d;
                double d5 = (double)ValueHelper.getLength(drawFrame.getSvgHeight()) / d;
                Image image = null;
                if (!this.maxResolution) {
                    image = tableTableCell.getRow().getTable().getSpreadsheet().getBody().getDocument().getImage(drawImage.getXlinkHref(), (int)d4, (int)d5);
                    graphics2D.drawImage(image, n + (int)Math.round(d2), n2 + (int)Math.round(d3), null);
                    continue;
                }
                image = tableTableCell.getRow().getTable().getSpreadsheet().getBody().getDocument().getImage(drawImage.getXlinkHref());
                graphics2D.drawImage(image, n + (int)Math.round(d2), n2 + (int)Math.round(d3), (int)Math.round(d4), (int)Math.round(d5), null);
            }
        }
    }
}

