/*
 * Decompiled with CFR 0.152.
 */
package org.jopendocument.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections.MultiHashMap;
import org.apache.commons.collections.MultiMap;
import org.jopendocument.util.CopyUtils;
import org.jopendocument.util.ExceptionUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CollectionMap<K, V>
extends MultiHashMap {
    private static final int DEFAULT_CAPACITY = 16;
    private final Class<? extends Collection<V>> collectionClass;
    private final Collection<V> collectionSpecimen;

    public static <K, V> CollectionMap<K, V> singleton(K k, Collection<V> collection) {
        CollectionMap<K, V> collectionMap = new CollectionMap<K, V>();
        collectionMap.putAll(k, collection);
        return collectionMap;
    }

    public static <K, V> CollectionMap<K, V> singleton(K k, V ... VArray) {
        return CollectionMap.singleton(k, Arrays.asList(VArray));
    }

    public static <K, V> CollectionMap<K, V> singleton(K k, V v) {
        return CollectionMap.singleton(k, Collections.singleton(v));
    }

    public CollectionMap() {
        this(ArrayList.class);
    }

    public CollectionMap(Class clazz) {
        this(clazz, 16);
    }

    public CollectionMap(int n) {
        this((Class)null, n);
    }

    public CollectionMap(Class clazz, int n) {
        super(n);
        this.collectionClass = clazz;
        this.collectionSpecimen = null;
    }

    public CollectionMap(Collection<V> collection) {
        this(collection, 16);
    }

    public CollectionMap(Collection<V> collection, int n) {
        super(n);
        this.collectionClass = null;
        if (!(collection instanceof Cloneable)) {
            throw new IllegalArgumentException(collection + " not a cloneable.");
        }
        this.collectionSpecimen = CopyUtils.copy(collection);
        this.collectionSpecimen.clear();
    }

    public Collection<V> getNonNull(K k) {
        Collection<V> collection = this.getNull(k);
        return collection == null ? this.createCollection(collection) : collection;
    }

    public Collection<V> getNull(K k) {
        return (Collection)this.get(k);
    }

    @Override
    public Collection<V> createCollection(Collection collection) {
        if (this.collectionClass != null) {
            try {
                if (collection == null) {
                    return this.collectionClass.newInstance();
                }
                return this.collectionClass.getConstructor(Collection.class).newInstance(collection);
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        }
        if (this.collectionSpecimen != null) {
            try {
                Collection<V> collection2 = CopyUtils.copy(this.collectionSpecimen);
                if (collection != null) {
                    collection2.addAll(collection);
                }
                return collection2;
            }
            catch (Exception exception) {
                throw ExceptionUtils.createExn(IllegalStateException.class, "clone() failed", exception);
            }
        }
        return super.createCollection(collection);
    }

    public Class getCollectionClass() {
        return this.collectionClass;
    }

    public void merge(MultiMap multiMap) {
        for (Map.Entry entry : multiMap.entrySet()) {
            Collection collection = (Collection)entry.getValue();
            Collection<V> collection2 = this.createCollection(collection);
            this.putAll(entry.getKey(), collection2);
        }
    }

    @Override
    public void putAll(Map map) {
        if (map instanceof MultiMap) {
            this.merge((MultiMap)map);
        } else {
            super.putAll(map);
        }
    }

    public boolean putAll(K k, V ... VArray) {
        return this.putAll((Object)k, Arrays.asList(VArray));
    }

    @Override
    public Set<Map.Entry<K, Collection<V>>> entrySet() {
        return super.entrySet();
    }

    @Override
    public Set<K> keySet() {
        return super.keySet();
    }

    @Override
    public Collection<V> values() {
        return super.values();
    }
}

