/*
 * Decompiled with CFR 0.152.
 */
package org.jopendocument.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.RandomAccess;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.regex.Pattern;
import org.apache.commons.collections.TransformerUtils;
import org.jopendocument.util.CompareUtils;
import org.jopendocument.util.Tuple2;
import org.jopendocument.util.cc.ITransformer;
import org.jopendocument.util.cc.Transformer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CollectionUtils
extends org.apache.commons.collections.CollectionUtils {
    private static final Pattern COMMA = Pattern.compile("\\p{Space}*,\\p{Space}*");

    public static final <E> String join(Collection<E> collection, String string, ITransformer<? super E, ?> iTransformer) {
        if (collection.size() == 0) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer(collection.size() * 4);
        if (collection instanceof RandomAccess && collection instanceof List) {
            List list = (List)collection;
            int n = collection.size() - 1;
            for (int i = 0; i < n; ++i) {
                stringBuffer.append(iTransformer.transformChecked(list.get(i)));
                stringBuffer.append(string);
            }
            stringBuffer.append(iTransformer.transformChecked(list.get(n)));
        } else {
            Iterator<E> iterator = collection.iterator();
            while (iterator.hasNext()) {
                E e = iterator.next();
                stringBuffer.append(iTransformer.transformChecked(e));
                if (!iterator.hasNext()) continue;
                stringBuffer.append(string);
            }
        }
        return stringBuffer.toString();
    }

    public static <T> String join(Collection<T> collection, String string) {
        return CollectionUtils.join(collection, string, Transformer.nopTransformer());
    }

    public static List<String> split(String string) {
        return CollectionUtils.split(string, COMMA);
    }

    public static List<String> split(String string, String string2) {
        return CollectionUtils.split(string, Pattern.compile(string2));
    }

    public static List<String> split(String string, Pattern pattern) {
        return string.length() == 0 ? Collections.emptyList() : Arrays.asList(pattern.split(string));
    }

    public static int getValidIndex(List<?> list, int n) {
        if (n > list.size()) {
            return list.size();
        }
        if (n >= 0) {
            return n;
        }
        if (list.size() + n <= 0) {
            return 0;
        }
        return list.size() + n;
    }

    public static void delete(List<?> list, int n, int n2) {
        if (!list.isEmpty()) {
            list.subList(CollectionUtils.getValidIndex(list, n), CollectionUtils.getValidIndex(list, n2) + 1).clear();
        }
    }

    public static void delete(List<?> list, int n) {
        CollectionUtils.delete(list, n, -1);
    }

    public static final SortedMap organize(Collection collection, List<? extends org.apache.commons.collections.Transformer> list, List<? extends Comparator> list2, Comparator comparator) {
        if (list.size() == 0) {
            throw new IllegalArgumentException("Empty property extractors");
        }
        if (list2 == null) {
            list2 = Collections.nCopies(list.size(), null);
        } else if (list.size() != list2.size()) {
            throw new IllegalArgumentException("Size mismatch between " + list + " and " + list2);
        }
        TreeMap treeMap = new TreeMap(list2.get(0));
        for (Object e : collection) {
            Object object;
            TreeMap treeMap2 = treeMap;
            for (int i = 0; i < list.size() - 1; ++i) {
                object = list.get(i);
                Object object2 = object.transform(e);
                TreeMap treeMap3 = (TreeMap)treeMap2.get(object2);
                if (treeMap3 == null) {
                    treeMap3 = new TreeMap(list2.get(i + 1));
                    treeMap2.put(object2, treeMap3);
                }
                treeMap2 = treeMap3;
            }
            Object object3 = list.get(list.size() - 1).transform(e);
            object = (SortedSet)treeMap2.get(object3);
            if (object == null) {
                object = new TreeSet(comparator);
                treeMap2.put(object3, object);
            }
            object.add(e);
        }
        return treeMap;
    }

    public static final List flatten(Map map, org.apache.commons.collections.Transformer transformer) {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        for (Object k : map.keySet()) {
            arrayList.add(k);
            Object v = map.get(k);
            if (v instanceof Map) {
                arrayList.addAll(CollectionUtils.flatten((Map)v, transformer));
                continue;
            }
            if (v instanceof Collection) {
                Collection collection = (Collection)v;
                for (Object e : collection) {
                    arrayList.add(transformer.transform(e));
                }
                continue;
            }
            throw new IllegalArgumentException("Illegal value: " + v);
        }
        return arrayList;
    }

    public static final List flatten(Map map) {
        return CollectionUtils.flatten(map, TransformerUtils.nopTransformer());
    }

    public static <K, V> Tuple2<List<K>, List<V>> mapToLists(Map<K, V> map) {
        ArrayList<K> arrayList = new ArrayList<K>(map.size());
        ArrayList<V> arrayList2 = new ArrayList<V>(map.size());
        for (Map.Entry<K, V> entry : map.entrySet()) {
            arrayList.add(entry.getKey());
            arrayList2.add(entry.getValue());
        }
        return Tuple2.create(arrayList, arrayList2);
    }

    public static <K, V> Map<K, V> addIfNotPresent(Map<K, V> map, Map<? extends K, ? extends V> map2) {
        for (Map.Entry<K, V> entry : map2.entrySet()) {
            if (map.containsKey(entry.getKey())) continue;
            map.put(entry.getKey(), entry.getValue());
        }
        return map;
    }

    public static <E> List<Integer> getIndexesChanged(List<E> list, List<E> list2) {
        ArrayList<E> arrayList;
        ArrayList<E> arrayList2;
        if (list2.size() > list.size()) {
            arrayList2 = new ArrayList<E>(list2);
            arrayList = new ArrayList<E>(list);
        } else {
            arrayList2 = new ArrayList<E>(list);
            arrayList = new ArrayList<E>(list2);
        }
        ArrayList<Integer> arrayList3 = new ArrayList<Integer>();
        int n = 0;
        while (arrayList.size() > 0) {
            if (arrayList2.size() < arrayList.size()) {
                throw new IllegalStateException(arrayList + " is not a sublist of " + arrayList2);
            }
            if (CompareUtils.equals(arrayList.get(0), arrayList2.get(0))) {
                arrayList.remove(0);
                arrayList2.remove(0);
            } else {
                arrayList2.remove(0);
                arrayList3.add(n);
            }
            ++n;
        }
        for (int i = 0; i < arrayList2.size(); ++i) {
            arrayList3.add(i + n);
        }
        return arrayList3;
    }

    public static List<int[]> aggregate(Collection<? extends Number> collection) {
        ArrayList<int[]> arrayList = new ArrayList<int[]>();
        int[] nArray = null;
        for (Number number : collection) {
            int n = number.intValue();
            if (nArray == null || n != nArray[1] + 1) {
                nArray = new int[]{n, nArray[0]};
                arrayList.add(nArray);
                continue;
            }
            nArray[1] = n;
        }
        return arrayList;
    }

    public static <T> Set<T> contains(Set<T> set, Set<T> set2) {
        if (set.containsAll(set2)) {
            return null;
        }
        HashSet<T> hashSet = new HashSet<T>(set2);
        hashSet.removeAll(set);
        return hashSet;
    }

    public static <U, T extends U> List<T> castToList(U[] UArray, Class<T> clazz) throws ClassCastException {
        ArrayList<T> arrayList = new ArrayList<T>(UArray.length);
        for (U u : UArray) {
            arrayList.add(clazz.cast(u));
        }
        return arrayList;
    }

    public static <T> int equalsFromEnd(List<T> list, List<T> list2) {
        return CollectionUtils.equals(list, list2, true, null);
    }

    public static <T> int equalsFromStart(List<T> list, List<T> list2) {
        return CollectionUtils.equals(list, list2, false, null);
    }

    public static final <A, B> int equals(List<A> list, List<B> list2, boolean bl, ITransformer<A, B> iTransformer) {
        int n = list.size();
        int n2 = list2.size();
        int n3 = Math.min(n, n2);
        for (int i = 0; i < n3; ++i) {
            B b;
            A a = list.get(bl ? n - 1 - i : i);
            if (CompareUtils.equals(iTransformer == null ? a : iTransformer.transformChecked(a), b = list2.get(bl ? n2 - 1 - i : i))) continue;
            return i;
        }
        return n3;
    }

    public static <T> Collection<T> inter(Collection<T> collection, Collection<T> collection2) {
        return org.apache.commons.collections.CollectionUtils.intersection(collection, collection2);
    }

    public static <T> Set<T> inter(Set<T> set, Set<T> set2) {
        if (set == set2) {
            return set;
        }
        if (set == null) {
            return set2;
        }
        if (set2 == null) {
            return set;
        }
        if (set.size() > set2.size()) {
            return CollectionUtils.inter(set2, set);
        }
        HashSet<T> hashSet = new HashSet<T>();
        for (T t : set) {
            if (!set2.contains(t)) continue;
            hashSet.add(t);
        }
        return hashSet;
    }

    public static <T> Set<T> inter(Set<T> ... setArray) {
        return CollectionUtils.inter(Arrays.asList(setArray));
    }

    public static <T> Set<T> inter(List<Set<T>> list) {
        ArrayList<Set<T>> arrayList = new ArrayList<Set<T>>(list.size());
        for (Set<T> set : list) {
            if (set == null) continue;
            arrayList.add(set);
        }
        if (arrayList.isEmpty()) {
            return null;
        }
        if (arrayList.size() == 1) {
            return (Set)arrayList.get(0);
        }
        int n = CollectionUtils.indexOfMinSize(arrayList);
        if (n != 0) {
            arrayList.add(0, (Set<T>)arrayList.remove(n));
            return CollectionUtils.inter(arrayList);
        }
        if (((Set)arrayList.get(0)).isEmpty()) {
            return Collections.emptySet();
        }
        arrayList.add(0, CollectionUtils.inter((Set)arrayList.remove(0), (Set)arrayList.remove(0)));
        return CollectionUtils.inter(arrayList);
    }

    private static final <T> int indexOfMinSize(List<Set<T>> list) {
        if (list.isEmpty()) {
            throw new IllegalArgumentException("empty sets");
        }
        int n = 0;
        for (int i = 1; i < list.size(); ++i) {
            if (list.get(i).size() >= list.get(n).size()) continue;
            n = i;
        }
        return n;
    }

    public static <T> Set<T> union(Set<? extends T> set, Set<? extends T> set2) {
        HashSet<T> hashSet = new HashSet<T>(set);
        if (set != set2) {
            hashSet.addAll(set2);
        }
        return hashSet;
    }

    public static <T> Collection<T> subtract(Collection<T> collection, Collection<? extends T> collection2) {
        return org.apache.commons.collections.CollectionUtils.subtract(collection, collection2);
    }

    public static <T> Collection<T> substract(Collection<T> collection, Collection<? extends T> collection2) {
        return org.apache.commons.collections.CollectionUtils.subtract(collection, collection2);
    }

    public static <T> T getSole(List<T> list) {
        return list.size() == 1 ? (T)list.get(0) : null;
    }

    public static <T> T getSole(Collection<T> collection) {
        return collection.size() == 1 ? (T)collection.iterator().next() : null;
    }

    public static <T> T getFirst(Collection<T> collection) {
        return collection.size() > 0 ? (T)collection.iterator().next() : null;
    }

    public static <T> T getFirst(List<T> list) {
        return CollectionUtils.getNoExn(list, 0);
    }

    public static <T> T getLast(List<T> list) {
        return CollectionUtils.getNoExn(list, list.size() - 1);
    }

    public static <T> T getNoExn(List<T> list, int n) {
        return n >= 0 && n < list.size() ? (T)list.get(n) : null;
    }

    public static <T> Set<T> createSet(T ... TArray) {
        return new HashSet<T>(Arrays.asList(TArray));
    }

    public static <K, V> Map<K, V> createMap(K k, V v, K k2, V v2) {
        HashMap<K, V> hashMap = new HashMap<K, V>();
        hashMap.put(k, v);
        hashMap.put(k2, v2);
        return hashMap;
    }

    public static <K, V> Map<K, V> createMap(K k, V v, K k2, V v2, K k3, V v3) {
        Map<K, V> map = CollectionUtils.createMap(k, v, k2, v2);
        map.put(k3, v3);
        return map;
    }

    public static <K, V> Map<K, V> createMap(Collection<? extends K> collection) {
        return CollectionUtils.fillMap(collection instanceof List ? new LinkedHashMap(collection.size()) : new HashMap(collection.size()), collection);
    }

    public static <K, V, M extends Map<K, V>> M fillMap(M m, Collection<? extends K> collection) {
        for (K k : collection) {
            m.put(k, null);
        }
        return m;
    }
}

