/*
 * Decompiled with CFR 0.152.
 */
package org.jsefa;

import java.util.LinkedList;
import java.util.List;
import org.jsefa.ObjectPathElement;
import org.jsefa.common.lowlevel.InputPosition;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class DeserializationException
extends RuntimeException {
    private static final long serialVersionUID = 1L;
    private static final String DEFAULT_MESSAGE = "Error while deserializing";
    private InputPosition inputPosition;
    private LinkedList<ObjectPathElement> objectPath = new LinkedList();

    public DeserializationException(String message) {
        super(message);
    }

    public DeserializationException(String message, Throwable cause) {
        super(message, cause);
    }

    public DeserializationException(Throwable cause) {
        super(DEFAULT_MESSAGE, cause);
    }

    public DeserializationException setInputPosition(InputPosition inputPosition) {
        this.inputPosition = inputPosition;
        return this;
    }

    public DeserializationException add(ObjectPathElement element) {
        this.objectPath.addFirst(element);
        return this;
    }

    public InputPosition getInputPosition() {
        return this.inputPosition;
    }

    public List<ObjectPathElement> getObjectPath() {
        return this.objectPath;
    }

    @Override
    public String getMessage() {
        StringBuilder result = new StringBuilder(super.getMessage());
        result.append("\nPosition: ");
        result.append(this.inputPosition);
        if (!this.objectPath.isEmpty()) {
            result.append("\nObject Path: ");
            for (int i = 0; i < this.objectPath.size(); ++i) {
                ObjectPathElement elem = this.objectPath.get(i);
                if (i > 0) {
                    result.append(".");
                }
                result.append(elem);
            }
        }
        return result.toString();
    }
}

