/*
 * Decompiled with CFR 0.152.
 */
package org.jsefa.common.annotation;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jsefa.ObjectPathElement;
import org.jsefa.common.accessor.ObjectAccessor;
import org.jsefa.common.accessor.ObjectAccessorProvider;
import org.jsefa.common.annotation.AnnotatedFieldsProvider;
import org.jsefa.common.annotation.AnnotationDataProvider;
import org.jsefa.common.util.ReflectionUtil;
import org.jsefa.common.validator.ValidationError;
import org.jsefa.common.validator.ValidationResult;
import org.jsefa.common.validator.Validator;
import org.jsefa.common.validator.provider.ValidatorProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ValidatorFactory {
    private final ObjectAccessorProvider objectAccessorProvider;
    private final ValidatorProvider validatorProvider;

    public ValidatorFactory(ValidatorProvider validatorProvider, ObjectAccessorProvider objectAccessorProvider) {
        this.validatorProvider = validatorProvider;
        this.objectAccessorProvider = objectAccessorProvider;
    }

    public Validator createContextualValidator(Class<?> objectType, Field field, Annotation contextAnnotation, Class<? extends Annotation> dataTypeAnnotationType) {
        Class validatorType = null;
        Validator validator = null;
        String[] constraints = null;
        if (contextAnnotation != null) {
            validatorType = (Class)AnnotationDataProvider.get(contextAnnotation, "validatorType");
            constraints = (String[])AnnotationDataProvider.get(contextAnnotation, "constraints");
        }
        if (validatorType == null) {
            if (this.validatorProvider.hasValidatorFor(objectType)) {
                validator = this.validatorProvider.getForObjectType(objectType, constraints);
            } else {
                validatorType = (Class)AnnotationDataProvider.get(objectType, "defaultValidatorType", dataTypeAnnotationType);
            }
        }
        if (validator == null && validatorType != null) {
            validator = this.validatorProvider.getForValidatorType(validatorType, objectType, constraints);
        }
        if (this.hasCollectionType(objectType) && contextAnnotation != null && AnnotationDataProvider.hasParameter(contextAnnotation.getClass(), "listItem")) {
            Validator itemValidator;
            Annotation itemAnnotation = (Annotation)AnnotationDataProvider.get(contextAnnotation, "listItem");
            Class<?> itemObjectType = (Class<?>)AnnotationDataProvider.get(itemAnnotation, "objectType");
            if (itemObjectType == null) {
                itemObjectType = ReflectionUtil.getActualTypeParameter(field, 0);
            }
            if ((itemValidator = this.createContextualValidator(itemObjectType, field, itemAnnotation, dataTypeAnnotationType)) != null) {
                SimpleListTypeValidator itemListValidator = new SimpleListTypeValidator(itemValidator);
                validator = validator != null ? new AndValidator(validator, itemListValidator) : itemListValidator;
            }
        }
        return validator;
    }

    public Validator createValidator(Class<?> objectType, Class<? extends Annotation> ... fieldAnnotationTypes) {
        ArrayList<String> requiredFieldNames = new ArrayList<String>();
        for (Field field : AnnotatedFieldsProvider.getAnnotatedFields(objectType, fieldAnnotationTypes)) {
            Boolean required = (Boolean)AnnotationDataProvider.get(field, "required", fieldAnnotationTypes);
            if (required == null || !required.booleanValue()) continue;
            requiredFieldNames.add(field.getName());
        }
        if (requiredFieldNames.isEmpty()) {
            return null;
        }
        return new RequiredFieldsValidator(this.objectAccessorProvider.get(objectType), requiredFieldNames);
    }

    private boolean hasCollectionType(Class<?> objectType) {
        return Collection.class.isAssignableFrom(objectType);
    }

    private static final class AndValidator
    implements Validator {
        private Validator validatorA;
        private Validator validatorB;

        AndValidator(Validator validatorA, Validator validatorB) {
            this.validatorA = validatorA;
            this.validatorB = validatorB;
        }

        public ValidationResult validate(Object value) {
            ArrayList<ValidationError> errors = new ArrayList<ValidationError>();
            errors.addAll(this.validatorA.validate(value).getErrors());
            errors.addAll(this.validatorB.validate(value).getErrors());
            return ValidationResult.create(errors);
        }
    }

    private static final class SimpleListTypeValidator
    implements Validator {
        private Validator itemValidator;

        SimpleListTypeValidator(Validator itemValidator) {
            this.itemValidator = itemValidator;
        }

        public ValidationResult validate(Object value) {
            ArrayList<ValidationError> errors = new ArrayList<ValidationError>();
            for (Object item : (List)value) {
                errors.addAll(this.itemValidator.validate(item).getErrors());
            }
            return ValidationResult.create(errors);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class RequiredFieldsValidator
    implements Validator {
        private List<String> requiredFieldNames;
        private ObjectAccessor objectAccessor;

        private RequiredFieldsValidator(ObjectAccessor objectAccessor, List<String> requiredFieldNames) {
            this.objectAccessor = objectAccessor;
            this.requiredFieldNames = requiredFieldNames;
        }

        @Override
        public ValidationResult validate(Object value) {
            ArrayList<ValidationError> errors = new ArrayList<ValidationError>();
            for (String fieldName : this.requiredFieldNames) {
                if (this.objectAccessor.getValue(value, fieldName) != null) continue;
                String errorText = "The field " + fieldName + " is required but no value is present";
                errors.add(ValidationError.create("MISSING_VALUE", errorText, new ObjectPathElement(value.getClass(), fieldName)));
            }
            return ValidationResult.create(errors);
        }
    }
}

