/*
 * Decompiled with CFR 0.152.
 */
package org.jsefa.common.config;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Map;
import org.jsefa.common.accessor.ObjectAccessorProvider;
import org.jsefa.common.accessor.ReflectionBasedObjectAccessorProvider;
import org.jsefa.common.config.InitialConfiguration;
import org.jsefa.common.config.ValidationMode;
import org.jsefa.common.converter.BigDecimalConverter;
import org.jsefa.common.converter.BooleanConverter;
import org.jsefa.common.converter.DateConverter;
import org.jsefa.common.converter.EnumConverter;
import org.jsefa.common.converter.IntegerConverter;
import org.jsefa.common.converter.LongConverter;
import org.jsefa.common.converter.SimpleListConverter;
import org.jsefa.common.converter.StringConverter;
import org.jsefa.common.converter.provider.SimpleTypeConverterProvider;
import org.jsefa.common.mapping.EntryPoint;
import org.jsefa.common.mapping.TypeMappingRegistry;
import org.jsefa.common.util.OnDemandObjectProvider;
import org.jsefa.common.util.ReflectionUtil;
import org.jsefa.common.validator.BigDecimalValidator;
import org.jsefa.common.validator.CollectionValidator;
import org.jsefa.common.validator.IntegerValidator;
import org.jsefa.common.validator.LongValidator;
import org.jsefa.common.validator.MapValidator;
import org.jsefa.common.validator.StringValidator;
import org.jsefa.common.validator.provider.ValidatorProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Configuration<R extends TypeMappingRegistry<?>, E extends EntryPoint<?, ?>> {
    private ObjectAccessorProvider objectAccessorProvider;
    private SimpleTypeConverterProvider simpleTypeConverterProvider;
    private ValidatorProvider validatorProvider;
    private R typeMappingRegistry;
    private Collection<E> entryPoints;
    private ValidationMode validationMode;

    protected Configuration() {
    }

    protected Configuration(Configuration<R, E> other) {
        this.setObjectAccessorProvider(other.getObjectAccessorProvider());
        this.setSimpleTypeConverterProvider(other.getSimpleTypeConverterProvider().createCopy());
        this.setValidatorProvider(other.getValidatorProvider().createCopy());
        this.setTypeMappingRegistry(((TypeMappingRegistry)other.getTypeMappingRegistry()).createCopy());
        this.setEntryPoints(new ArrayList<E>(other.getEntryPoints()));
        this.setValidationMode(other.getValidationMode());
    }

    public final R getTypeMappingRegistry() {
        if (this.typeMappingRegistry == null) {
            this.typeMappingRegistry = this.createDefaultTypeMappingRegistry();
        }
        return this.typeMappingRegistry;
    }

    public final void setTypeMappingRegistry(R typeMappingRegistry) {
        this.typeMappingRegistry = typeMappingRegistry;
    }

    public final Collection<E> getEntryPoints() {
        if (this.entryPoints == null) {
            this.entryPoints = new ArrayList();
        }
        return this.entryPoints;
    }

    public final void setEntryPoints(Collection<E> entryPoints) {
        this.entryPoints = entryPoints;
    }

    public final ObjectAccessorProvider getObjectAccessorProvider() {
        if (this.objectAccessorProvider == null) {
            Class theClass = (Class)InitialConfiguration.get("jsefa:common:objectAccessorProviderClass", ReflectionBasedObjectAccessorProvider.class);
            this.objectAccessorProvider = (ObjectAccessorProvider)ReflectionUtil.createInstance(theClass);
        }
        return this.objectAccessorProvider;
    }

    public final SimpleTypeConverterProvider getSimpleTypeConverterProvider() {
        if (this.simpleTypeConverterProvider == null) {
            SimpleTypeConverterProvider initialProvider = (SimpleTypeConverterProvider)InitialConfiguration.get("jsefa:common:simpleTypeConverterProvider", Defaults.DEFAULT_SIMPLE_TYPE_CONVERTER_PROVIDER_PROVIDER);
            this.simpleTypeConverterProvider = initialProvider.createCopy();
        }
        return this.simpleTypeConverterProvider;
    }

    public final ValidatorProvider getValidatorProvider() {
        if (this.validatorProvider == null) {
            ValidatorProvider initialProvider = (ValidatorProvider)InitialConfiguration.get("jsefa:common:validatorProvider", Defaults.DEFAULT_VALIDATOR_PROVIDER_PROVIDER);
            this.validatorProvider = initialProvider.createCopy();
        }
        return this.validatorProvider;
    }

    public final ValidationMode getValidationMode() {
        if (this.validationMode == null) {
            this.validationMode = (ValidationMode)((Object)InitialConfiguration.get("jsefa:common:validationMode", (Object)Defaults.DEFAULT_VALIDATION_MODE));
        }
        return this.validationMode;
    }

    public final void setObjectAccessorProvider(ObjectAccessorProvider objectAccessorProvider) {
        this.objectAccessorProvider = objectAccessorProvider;
    }

    public final void setSimpleTypeConverterProvider(SimpleTypeConverterProvider simpleTypeConverterProvider) {
        this.simpleTypeConverterProvider = simpleTypeConverterProvider;
    }

    public final void setValidatorProvider(ValidatorProvider validatorProvider) {
        this.validatorProvider = validatorProvider;
    }

    public final void setValidationMode(ValidationMode validationMode) {
        this.validationMode = validationMode;
    }

    public abstract Configuration<R, E> createCopy();

    protected abstract R createDefaultTypeMappingRegistry();

    public static interface Defaults {
        public static final OnDemandObjectProvider DEFAULT_SIMPLE_TYPE_CONVERTER_PROVIDER_PROVIDER = new OnDemandObjectProvider(){

            public SimpleTypeConverterProvider get() {
                SimpleTypeConverterProvider provider = new SimpleTypeConverterProvider();
                provider.registerConverterType(String.class, StringConverter.class);
                provider.registerConverterType(Boolean.TYPE, BooleanConverter.class);
                provider.registerConverterType(Boolean.class, BooleanConverter.class);
                provider.registerConverterType(Long.TYPE, LongConverter.class);
                provider.registerConverterType(Long.class, LongConverter.class);
                provider.registerConverterType(Integer.TYPE, IntegerConverter.class);
                provider.registerConverterType(Integer.class, IntegerConverter.class);
                provider.registerConverterType(BigDecimal.class, BigDecimalConverter.class);
                provider.registerConverterType(Date.class, DateConverter.class);
                if (ReflectionUtil.hasClass("javax.xml.datatype.XMLGregorianCalendar")) {
                    Class<?> gregorianCalendar = ReflectionUtil.getClass("javax.xml.datatype.XMLGregorianCalendar");
                    Class<?> gregorianConverter = null;
                    if (ReflectionUtil.hasClass("org.jsefa.common.converter.XMLGregorianCalendarConverter")) {
                        gregorianConverter = ReflectionUtil.getClass("org.jsefa.common.converter.XMLGregorianCalendarConverter");
                        provider.registerConverterType(gregorianCalendar, gregorianConverter);
                    }
                }
                provider.registerConverterType(Enum.class, EnumConverter.class);
                provider.registerConverterType(Collection.class, SimpleListConverter.class);
                return provider;
            }
        };
        public static final OnDemandObjectProvider DEFAULT_VALIDATOR_PROVIDER_PROVIDER = new OnDemandObjectProvider(){

            public ValidatorProvider get() {
                ValidatorProvider provider = new ValidatorProvider();
                provider.registerValidatorType(String.class, StringValidator.class);
                provider.registerValidatorType(Integer.class, IntegerValidator.class);
                provider.registerValidatorType(Integer.TYPE, IntegerValidator.class);
                provider.registerValidatorType(Long.class, LongValidator.class);
                provider.registerValidatorType(Long.TYPE, LongValidator.class);
                provider.registerValidatorType(BigDecimal.class, BigDecimalValidator.class);
                provider.registerValidatorType(Collection.class, CollectionValidator.class);
                provider.registerValidatorType(Map.class, MapValidator.class);
                return provider;
            }
        };
        public static final ValidationMode DEFAULT_VALIDATION_MODE = ValidationMode.BOTH;
    }
}

