/*
 * Decompiled with CFR 0.152.
 */
package org.jsefa.common.converter;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.jsefa.common.converter.ConversionException;
import org.jsefa.common.converter.SimpleTypeConverter;
import org.jsefa.common.converter.SimpleTypeConverterConfiguration;

public class DateConverter
implements SimpleTypeConverter {
    private static final String DEFAULT_FORMAT = "dd.MM.yyyy";
    private final SimpleDateFormat dateFormat;

    public static DateConverter create(SimpleTypeConverterConfiguration configuration) {
        return new DateConverter(configuration);
    }

    protected DateConverter(SimpleTypeConverterConfiguration configuration) {
        String format = this.getFormat(configuration);
        try {
            this.dateFormat = new SimpleDateFormat(format);
        }
        catch (Exception e) {
            throw new ConversionException("Could not create a " + this.getClass().getName() + "  with format " + format, e);
        }
    }

    public final synchronized Date fromString(String value) {
        if (value == null || value.length() == 0) {
            return null;
        }
        try {
            return this.dateFormat.parse(value);
        }
        catch (ParseException e) {
            throw new ConversionException("Wrong date format: " + value);
        }
    }

    public final synchronized String toString(Object value) {
        if (value == null) {
            return null;
        }
        return this.dateFormat.format((Date)value);
    }

    protected String getDefaultFormat() {
        return DEFAULT_FORMAT;
    }

    private String getFormat(SimpleTypeConverterConfiguration configuration) {
        if (configuration.getFormat() == null) {
            return this.getDefaultFormat();
        }
        if (configuration.getFormat().length != 1) {
            throw new ConversionException("The format for a DateConverter must be a single String");
        }
        return configuration.getFormat()[0];
    }
}

