/*
 * Decompiled with CFR 0.152.
 */
package org.jsefa.common.converter;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import java.util.Set;
import org.jsefa.common.converter.ConversionException;
import org.jsefa.common.converter.SimpleTypeConverter;
import org.jsefa.common.converter.SimpleTypeConverterConfiguration;
import org.jsefa.common.util.ReflectionUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimpleListConverter
implements SimpleTypeConverter {
    private static final String[] DEFAULT_FORMAT = new String[]{","};
    private final String delimiter;
    private final SimpleTypeConverter itemTypeConverter;
    private final Class<? extends Collection> collectionClass;

    public static SimpleListConverter create(SimpleTypeConverterConfiguration configuration) {
        return new SimpleListConverter(configuration);
    }

    protected SimpleListConverter(SimpleTypeConverterConfiguration configuration) {
        this.delimiter = this.getFormat(configuration)[0];
        this.itemTypeConverter = configuration.getItemTypeConverter();
        if (configuration.getObjectType().isInterface()) {
            this.collectionClass = this.getImplementor(configuration.getObjectType());
            if (this.collectionClass == null) {
                throw new ConversionException("Could not create a " + this.getClass().getName() + " for collection type " + configuration.getObjectType().getName());
            }
        } else {
            this.collectionClass = configuration.getObjectType();
        }
    }

    @Override
    public final Object fromString(String value) {
        if (value == null) {
            return null;
        }
        Collection result = ReflectionUtil.createInstance(this.collectionClass);
        if (value.length() > 0) {
            int lastIndex = 0;
            int index = value.indexOf(this.delimiter);
            while (index != -1) {
                result.add(this.itemTypeConverter.fromString(value.substring(lastIndex, index)));
                lastIndex = index + this.delimiter.length();
                index = value.indexOf(this.delimiter, lastIndex);
            }
            result.add(this.itemTypeConverter.fromString(value.substring(lastIndex)));
        }
        return result;
    }

    @Override
    public final String toString(Object value) {
        StringBuilder result = new StringBuilder();
        Collection list = (Collection)value;
        int listSize = list.size();
        int itemIndex = 0;
        for (Object item : list) {
            result.append(this.itemTypeConverter.toString(item));
            if (++itemIndex >= listSize) continue;
            result.append(this.delimiter);
        }
        return result.toString();
    }

    protected String[] getDefaultFormat() {
        return DEFAULT_FORMAT;
    }

    protected Class<? extends Collection> getImplementor(Class<?> aCollectionInterface) {
        if (List.class.isAssignableFrom(aCollectionInterface)) {
            return ArrayList.class;
        }
        if (Set.class.isAssignableFrom(aCollectionInterface)) {
            return HashSet.class;
        }
        if (Queue.class.isAssignableFrom(aCollectionInterface)) {
            return LinkedList.class;
        }
        return null;
    }

    private String[] getFormat(SimpleTypeConverterConfiguration configuration) {
        if (configuration.getFormat() == null) {
            return this.getDefaultFormat();
        }
        if (configuration.getFormat().length != 1) {
            throw new ConversionException("The format for a SimpleListConverter must be an array with 1 entry");
        }
        return configuration.getFormat();
    }
}

