/*
 * Decompiled with CFR 0.152.
 */
package org.jsefa.common.validator;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import org.jsefa.ObjectPathElement;
import org.jsefa.common.converter.BigDecimalConverter;
import org.jsefa.common.converter.SimpleTypeConverterConfiguration;
import org.jsefa.common.validator.ConstraintsAccessor;
import org.jsefa.common.validator.NumberValidator;
import org.jsefa.common.validator.ValidationError;
import org.jsefa.common.validator.ValidationResult;
import org.jsefa.common.validator.ValidatorConfiguration;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class BigDecimalValidator
extends NumberValidator<BigDecimal> {
    private static final String MIN_EXCLUSIVE = "minExclusive";
    private static final String MAX_EXCLUSIVE = "maxExclusive";
    private final BigDecimal minExclusive = (BigDecimal)this.getConstraintsAccessor().get("minExclusive", false);
    private final BigDecimal maxExclusive = (BigDecimal)this.getConstraintsAccessor().get("maxExclusive", false);

    public static BigDecimalValidator create(ValidatorConfiguration configuration) {
        return new BigDecimalValidator(configuration);
    }

    private BigDecimalValidator(ValidatorConfiguration configuration) {
        super(ConstraintsAccessor.create(configuration, BigDecimalConverter.create(SimpleTypeConverterConfiguration.EMPTY)));
    }

    @Override
    public ValidationResult validate(Object value) {
        BigDecimal number = (BigDecimal)value;
        ArrayList<ValidationError> errors = new ArrayList<ValidationError>(super.validate(number).getErrors());
        this.validateMinExclusive(number, errors);
        this.validateMaxExclusive(number, errors);
        return ValidationResult.create(errors);
    }

    private void validateMinExclusive(BigDecimal number, Collection<ValidationError> errors) {
        if (this.minExclusive != null && number.compareTo(this.minExclusive) <= 0) {
            String errorText = "The value " + number + " is not above the minimum exclusive value " + this.minExclusive;
            errors.add(ValidationError.create("OUT_OF_RANGE", errorText, new ObjectPathElement[0]));
        }
    }

    private void validateMaxExclusive(BigDecimal number, Collection<ValidationError> errors) {
        if (this.maxExclusive != null && number.compareTo(this.maxExclusive) >= 0) {
            String errorText = "The value " + number + " is not below the maximum exclusive value " + this.maxExclusive;
            errors.add(ValidationError.create("OUT_OF_RANGE", errorText, new ObjectPathElement[0]));
        }
    }
}

