/*
 * Decompiled with CFR 0.152.
 */
package org.jsefa.common.validator;

import java.util.ArrayList;
import java.util.Collection;
import java.util.regex.Pattern;
import org.jsefa.ObjectPathElement;
import org.jsefa.common.validator.ConstraintsAccessor;
import org.jsefa.common.validator.ValidationError;
import org.jsefa.common.validator.ValidationResult;
import org.jsefa.common.validator.Validator;
import org.jsefa.common.validator.ValidatorConfiguration;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class StringValidator
implements Validator {
    private static final String PATTERN = "pattern";
    private static final String MIN_LENGTH = "minLength";
    private static final String MAX_LENGTH = "maxLength";
    private static final String LENGTH = "length";
    private final Pattern pattern;
    private final Integer minLength;
    private final Integer maxLength;
    private final Integer length;

    public static StringValidator create(ValidatorConfiguration configuration) {
        return new StringValidator(configuration);
    }

    private StringValidator(ValidatorConfiguration configuration) {
        ConstraintsAccessor constraints = ConstraintsAccessor.create(configuration);
        this.pattern = constraints.getPattern(PATTERN, false);
        this.length = constraints.getInteger(LENGTH, false);
        this.minLength = constraints.getInteger(MIN_LENGTH, false);
        this.maxLength = constraints.getInteger(MAX_LENGTH, false);
    }

    @Override
    public ValidationResult validate(Object value) {
        String text = (String)value;
        ArrayList<ValidationError> errors = new ArrayList<ValidationError>();
        this.validatePattern(text, errors);
        this.validateLength(text, errors);
        this.validateMinLength(text, errors);
        this.validateMaxLength(text, errors);
        return ValidationResult.create(errors);
    }

    private void validatePattern(String value, Collection<ValidationError> errors) {
        if (this.pattern != null && !this.pattern.matcher(value).matches()) {
            String errorText = "The value " + value + " does not match the pattern " + this.pattern.pattern();
            errors.add(ValidationError.create("PATTERN_MATCHING_FAILED", errorText, new ObjectPathElement[0]));
        }
    }

    private void validateLength(String value, Collection<ValidationError> errors) {
        if (this.length != null && value.length() != this.length.intValue()) {
            String errorText = "The value " + value + " has not the required length of " + this.length;
            errors.add(ValidationError.create("WRONG_LENGTH", errorText, new ObjectPathElement[0]));
        }
    }

    private void validateMinLength(String value, Collection<ValidationError> errors) {
        if (this.minLength != null && value.length() < this.minLength) {
            String errorText = "The value " + value + " is shorter than the minimum length of " + this.minLength;
            errors.add(ValidationError.create("WRONG_LENGTH", errorText, new ObjectPathElement[0]));
        }
    }

    private void validateMaxLength(String value, Collection<ValidationError> errors) {
        if (this.maxLength != null && value.length() > this.maxLength) {
            String errorText = "The value " + value + " is longer than the maximum length of " + this.maxLength;
            errors.add(ValidationError.create("WRONG_LENGTH", errorText, new ObjectPathElement[0]));
        }
    }
}

