/*
 * Decompiled with CFR 0.152.
 */
package org.jsefa.common.validator.provider;

import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.jsefa.common.util.ReflectionUtil;
import org.jsefa.common.validator.Validator;
import org.jsefa.common.validator.ValidatorConfiguration;
import org.jsefa.common.validator.ValidatorCreationException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ValidatorProvider {
    private final ConcurrentMap<Class<?>, Class<? extends Validator>> validatorTypeMap;

    public ValidatorProvider() {
        this.validatorTypeMap = new ConcurrentHashMap();
    }

    private ValidatorProvider(ValidatorProvider other) {
        this.validatorTypeMap = new ConcurrentHashMap(other.validatorTypeMap);
    }

    public ValidatorProvider createCopy() {
        return new ValidatorProvider(this);
    }

    public boolean hasValidatorFor(Class<?> objectType) {
        return this.getValidatorType(objectType) != null;
    }

    public Validator getForObjectType(Class<?> objectType, String[] constraints) {
        if (!this.hasValidatorFor(objectType)) {
            return null;
        }
        Class<? extends Validator> validatorType = this.getValidatorType(objectType);
        return this.getForValidatorType(validatorType, objectType, constraints);
    }

    public Validator getForValidatorType(Class<? extends Validator> validatorType, Class<?> objectType, String[] constraints) {
        try {
            Method factoryMethod = ReflectionUtil.getMethod(validatorType, "create", new Class[0]);
            if (constraints == null && factoryMethod != null) {
                return (Validator)ReflectionUtil.callMethod(null, factoryMethod, null);
            }
            factoryMethod = ReflectionUtil.getMethod(validatorType, "create", ValidatorConfiguration.class);
            if (factoryMethod != null) {
                if (constraints == null) {
                    return null;
                }
                return (Validator)ReflectionUtil.callMethod(null, factoryMethod, ValidatorConfiguration.create(objectType, this.toMap(constraints)));
            }
            throw new ValidatorCreationException("No static create method found for class " + validatorType);
        }
        catch (Exception e) {
            throw new ValidatorCreationException("Could not create a Validator for class " + validatorType, e);
        }
    }

    public void registerValidatorType(Class<?> objectType, Class<? extends Validator> validatorType) {
        this.validatorTypeMap.put(objectType, validatorType);
    }

    private Class<? extends Validator> getValidatorType(Class<?> objectType) {
        return ReflectionUtil.getNearest(objectType, this.validatorTypeMap);
    }

    private Map<String, String> toMap(String[] constraints) {
        HashMap<String, String> result = new HashMap<String, String>();
        for (String constraint : constraints) {
            int pos = constraint.indexOf(61);
            if (pos < 1 || pos == constraint.length() - 1) {
                throw new ValidatorCreationException("Wrong validator constraint format: " + constraint);
            }
            String name = constraint.substring(0, pos).trim();
            String value = constraint.substring(pos + 1).trim();
            if (name.length() == 0 || value.length() == 0) {
                throw new ValidatorCreationException("Wrong validator constraint format: " + constraint);
            }
            result.put(name, value);
        }
        return result;
    }
}

