/*
 * Decompiled with CFR 0.152.
 */
package org.jsefa.csv;

import java.util.Map;
import org.jsefa.csv.CsvDeserializer;
import org.jsefa.csv.CsvDeserializerImpl;
import org.jsefa.csv.CsvIOFactory;
import org.jsefa.csv.CsvSerializer;
import org.jsefa.csv.CsvSerializerImpl;
import org.jsefa.csv.config.CsvConfiguration;
import org.jsefa.csv.lowlevel.CsvLowLevelIOFactory;
import org.jsefa.csv.lowlevel.config.CsvLowLevelConfiguration;
import org.jsefa.rbf.RbfIOFactory;
import org.jsefa.rbf.mapping.RbfEntryPoint;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CsvIOFactoryImpl
extends CsvIOFactory {
    private final RbfIOFactory<CsvConfiguration, CsvSerializer, CsvDeserializer> rbfIOFactory;
    private final CsvLowLevelIOFactory lowLevelIOFactory;

    public static CsvIOFactory createFactory(CsvConfiguration config) {
        return new CsvIOFactoryImpl(config);
    }

    CsvIOFactoryImpl(CsvConfiguration config) {
        this.rbfIOFactory = this.createRbfIOFactory(config);
        this.lowLevelIOFactory = CsvLowLevelIOFactory.createFactory((CsvLowLevelConfiguration)config.getLowLevelConfiguration());
    }

    @Override
    public CsvSerializer createSerializer() {
        return (CsvSerializer)this.rbfIOFactory.createSerializer();
    }

    @Override
    public CsvDeserializer createDeserializer() {
        return (CsvDeserializer)this.rbfIOFactory.createDeserializer();
    }

    private RbfIOFactory<CsvConfiguration, CsvSerializer, CsvDeserializer> createRbfIOFactory(CsvConfiguration config) {
        return new RbfIOFactory<CsvConfiguration, CsvSerializer, CsvDeserializer>(config){

            @Override
            protected CsvSerializer createSerializer(CsvConfiguration config, Map<Class<?>, RbfEntryPoint> entryPointsByObjectType) {
                return new CsvSerializerImpl(config, entryPointsByObjectType, CsvIOFactoryImpl.this.lowLevelIOFactory.createSerializer());
            }

            @Override
            protected CsvDeserializer createDeserializer(CsvConfiguration config, RbfEntryPoint entryPoint) {
                return new CsvDeserializerImpl(config, entryPoint, CsvIOFactoryImpl.this.lowLevelIOFactory.createDeserializer());
            }

            @Override
            protected CsvDeserializer createDeserializer(CsvConfiguration config, Map<String, RbfEntryPoint> entryPointsByPrefix) {
                return new CsvDeserializerImpl(config, entryPointsByPrefix, CsvIOFactoryImpl.this.lowLevelIOFactory.createDeserializer());
            }
        };
    }
}

