/*
 * Decompiled with CFR 0.152.
 */
package org.jsefa.csv.lowlevel;

import org.jsefa.common.lowlevel.LowLevelDeserializationException;
import org.jsefa.common.lowlevel.io.LineSegment;
import org.jsefa.csv.lowlevel.CsvLowLevelDeserializer;
import org.jsefa.csv.lowlevel.config.CsvLowLevelConfiguration;
import org.jsefa.csv.lowlevel.config.EscapeMode;
import org.jsefa.csv.lowlevel.config.QuoteMode;
import org.jsefa.rbf.lowlevel.RbfLowLevelDeserializerImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class CsvLowLevelDeserializerImpl
extends RbfLowLevelDeserializerImpl<CsvLowLevelConfiguration>
implements CsvLowLevelDeserializer {
    private boolean lastFieldTerminatedWithDelimiter;

    public CsvLowLevelDeserializerImpl(CsvLowLevelConfiguration config) {
        super(config);
    }

    @Override
    public String nextField(QuoteMode quoteMode) {
        if (!this.hasNextChar()) {
            return this.endOfLineField();
        }
        switch (quoteMode) {
            case ALWAYS: {
                return this.readStringValueUsingQuotes();
            }
            case ON_DEMAND: {
                return this.readStringValueUsingQuotesOnDemand();
            }
            case NEVER: {
                return this.readStringValueUsingEscapeCharacter();
            }
        }
        throw new UnsupportedOperationException("The quote mode is not supported: " + (Object)((Object)quoteMode));
    }

    private String endOfLineField() {
        if (((CsvLowLevelConfiguration)this.getConfiguration()).getUseDelimiterAfterLastField()) {
            return null;
        }
        if (this.lastFieldTerminatedWithDelimiter) {
            this.lastFieldTerminatedWithDelimiter = false;
            return "";
        }
        return null;
    }

    private String readStringValueUsingQuotes() {
        char quoteChar = ((CsvLowLevelConfiguration)this.getConfiguration()).getQuoteCharacter();
        char startChar = this.nextChar();
        if (startChar == ((CsvLowLevelConfiguration)this.getConfiguration()).getFieldDelimiter()) {
            this.lastFieldTerminatedWithDelimiter = true;
            return "";
        }
        if (startChar != quoteChar) {
            throw new LowLevelDeserializationException("Expected quote char but got " + startChar);
        }
        char escapeCharacter = ((CsvLowLevelConfiguration)this.getConfiguration()).getEscapeCharacter();
        if (((CsvLowLevelConfiguration)this.getConfiguration()).getQuoteCharacterEscapeMode().equals((Object)EscapeMode.DOUBLING)) {
            escapeCharacter = quoteChar;
        }
        return this.readStringValueUsingQuotes(quoteChar, escapeCharacter, ((CsvLowLevelConfiguration)this.getConfiguration()).getFieldDelimiter());
    }

    private String readStringValueUsingQuotes(char quoteChar, char escapeCharacter, char fieldDelimiter) {
        StringBuilder result = new StringBuilder(this.remainingLineLength());
        boolean encoded = false;
        while (true) {
            if (this.hasNextChar()) {
                char currentChar = this.nextChar();
                if (encoded) {
                    encoded = false;
                    result.append(currentChar);
                    continue;
                }
                if (currentChar == quoteChar) {
                    if (!this.hasNextChar()) {
                        this.lastFieldTerminatedWithDelimiter = false;
                        return result.toString();
                    }
                    if (this.hasNextChar() && this.peekChar() == fieldDelimiter) {
                        this.nextChar();
                        this.lastFieldTerminatedWithDelimiter = true;
                        return result.toString();
                    }
                }
                if (currentChar == escapeCharacter) {
                    encoded = true;
                    continue;
                }
                result.append(currentChar);
                continue;
            }
            result.append(this.getCurrentSegmentTerminatorString());
            if (!this.readNextSegment()) break;
        }
        this.lastFieldTerminatedWithDelimiter = false;
        return result.toString();
    }

    private String readStringValueUsingQuotesOnDemand() {
        if (this.peekChar() == ((CsvLowLevelConfiguration)this.getConfiguration()).getQuoteCharacter()) {
            return this.readStringValueUsingQuotes();
        }
        char fieldDelimiter = ((CsvLowLevelConfiguration)this.getConfiguration()).getFieldDelimiter();
        StringBuilder result = new StringBuilder(this.remainingLineLength());
        while (this.hasNextChar()) {
            char currentChar = this.nextChar();
            if (currentChar == fieldDelimiter) {
                this.lastFieldTerminatedWithDelimiter = true;
                return result.toString();
            }
            result.append(currentChar);
        }
        this.lastFieldTerminatedWithDelimiter = false;
        return result.toString();
    }

    private String readStringValueUsingEscapeCharacter() {
        char fieldDelimiter = ((CsvLowLevelConfiguration)this.getConfiguration()).getFieldDelimiter();
        StringBuilder result = new StringBuilder(this.remainingLineLength());
        boolean escaped = false;
        while (true) {
            if (this.hasNextChar()) {
                char currentChar = this.nextChar();
                if (escaped) {
                    escaped = false;
                    if (currentChar == 'n') {
                        result.append("\n");
                        continue;
                    }
                    result.append(currentChar);
                    continue;
                }
                if (currentChar == ((CsvLowLevelConfiguration)this.getConfiguration()).getEscapeCharacter()) {
                    escaped = true;
                    continue;
                }
                if (currentChar == fieldDelimiter) {
                    this.lastFieldTerminatedWithDelimiter = true;
                    return result.toString();
                }
                result.append(currentChar);
                continue;
            }
            if (!escaped || this.getCurrentSegmentTerminator() != LineSegment.Terminator.SPECIAL_CHARACTER) break;
            escaped = false;
            result.append(this.getCurrentSegmentTerminatorString());
            if (!this.readNextSegment()) break;
        }
        this.lastFieldTerminatedWithDelimiter = false;
        return result.toString();
    }
}

