/*
 * Decompiled with CFR 0.152.
 */
package org.jsefa.rbf;

import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.jsefa.IOFactory;
import org.jsefa.IOFactoryException;
import org.jsefa.common.config.Configuration;
import org.jsefa.common.mapping.TypeMapping;
import org.jsefa.common.validator.Validator;
import org.jsefa.common.validator.traversal.TraversingValidatorFactory;
import org.jsefa.rbf.RbfDeserializer;
import org.jsefa.rbf.RbfSerializer;
import org.jsefa.rbf.mapping.RbfComplexTypeMapping;
import org.jsefa.rbf.mapping.RbfEntryPoint;
import org.jsefa.rbf.mapping.RbfListTypeMapping;
import org.jsefa.rbf.mapping.RbfNodeType;
import org.jsefa.rbf.mapping.RbfTypeMappingRegistry;
import org.jsefa.rbf.mapping.RecordDescriptor;
import org.jsefa.rbf.mapping.RecordMapping;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class RbfIOFactory<C extends Configuration<RbfTypeMappingRegistry, RbfEntryPoint>, S extends RbfSerializer, D extends RbfDeserializer>
implements IOFactory {
    private final C config;
    private final RbfEntryPoint entryPoint;
    private final ConcurrentMap<String, RbfEntryPoint> entryPointsByPrefix;
    private final ConcurrentMap<Class<?>, RbfEntryPoint> entryPointsByObjectType;
    private final boolean withPrefix;

    protected RbfIOFactory(C config) {
        if (((Configuration)config).getEntryPoints().size() == 0) {
            throw new IOFactoryException("No entry points given");
        }
        this.withPrefix = this.prefixRequired(((Configuration)config).getEntryPoints());
        this.config = ((Configuration)config).createCopy();
        this.entryPointsByObjectType = new ConcurrentHashMap();
        TraversingValidatorFactory traversingValidatorFactory = new TraversingValidatorFactory(((Configuration)config).getTypeMappingRegistry(), ((Configuration)config).getObjectAccessorProvider());
        if (this.withPrefix) {
            this.entryPointsByPrefix = new ConcurrentHashMap<String, RbfEntryPoint>();
            for (RbfEntryPoint anEntryPoint : ((Configuration)config).getEntryPoints()) {
                Validator validator = traversingValidatorFactory.create(anEntryPoint.getDataTypeName(), anEntryPoint.getValidator());
                RbfEntryPoint validationEntryPoint = new RbfEntryPoint((String)anEntryPoint.getDataTypeName(), (String)anEntryPoint.getDesignator(), validator);
                Class<?> objectType = this.getObjectType((String)anEntryPoint.getDataTypeName());
                this.assertPrefixDeclared(validationEntryPoint, objectType);
                this.entryPointsByObjectType.put(objectType, validationEntryPoint);
                this.entryPointsByPrefix.put((String)anEntryPoint.getDesignator(), validationEntryPoint);
            }
            this.assertPrefixContentualUniqueness(((Configuration)config).getEntryPoints());
            this.entryPoint = null;
        } else {
            RbfEntryPoint configuredEntryPoint = (RbfEntryPoint)((Configuration)config).getEntryPoints().iterator().next();
            Validator validator = traversingValidatorFactory.create(configuredEntryPoint.getDataTypeName(), configuredEntryPoint.getValidator());
            this.entryPoint = new RbfEntryPoint((String)configuredEntryPoint.getDataTypeName(), (String)configuredEntryPoint.getDesignator(), validator);
            Class<?> objectType = this.getObjectType((String)this.entryPoint.getDataTypeName());
            this.entryPointsByObjectType.put(objectType, this.entryPoint);
            this.entryPointsByPrefix = null;
        }
    }

    public final S createSerializer() {
        return this.createSerializer(this.config, this.entryPointsByObjectType);
    }

    public final D createDeserializer() {
        if (this.withPrefix) {
            return this.createDeserializer(this.config, this.entryPointsByPrefix);
        }
        return this.createDeserializer(this.config, this.entryPoint);
    }

    public boolean withPrefixes() {
        return this.prefixRequired(((Configuration)this.config).getEntryPoints());
    }

    protected abstract S createSerializer(C var1, Map<Class<?>, RbfEntryPoint> var2);

    protected abstract D createDeserializer(C var1, RbfEntryPoint var2);

    protected abstract D createDeserializer(C var1, Map<String, RbfEntryPoint> var2);

    protected final boolean prefixRequired(Collection<RbfEntryPoint> entryPoints) {
        if (entryPoints.size() > 1) {
            return true;
        }
        String prefix = (String)entryPoints.iterator().next().getDesignator();
        return prefix != null && prefix.length() > 0;
    }

    private Class<?> getObjectType(String dataTypeName) {
        TypeMapping<String> typeMapping = ((RbfTypeMappingRegistry)((Configuration)this.config).getTypeMappingRegistry()).get(dataTypeName);
        if (typeMapping == null) {
            throw new IOFactoryException("Unknown data type: " + dataTypeName);
        }
        return typeMapping.getObjectType();
    }

    private void assertPrefixDeclared(RbfEntryPoint entryPoint, Class<?> objectType) {
        String prefix = (String)entryPoint.getDesignator();
        if (prefix == null || prefix.length() == 0) {
            throw new IOFactoryException("prefix not given but required for object type " + objectType.getName());
        }
    }

    private void assertPrefixContentualUniqueness(Collection<RbfEntryPoint> entryPoints) {
        HashSet<String> usedPrefixes = new HashSet<String>();
        for (RbfEntryPoint anEntryPoint : entryPoints) {
            this.assertPrefixContextualUniqueness((String)anEntryPoint.getDesignator(), (String)anEntryPoint.getDataTypeName(), null, usedPrefixes);
        }
    }

    private void assertPrefixContextualUniqueness(String prefix, String dataTypeName, String parentPrefix, Set<String> siblingUsedPrefixes) {
        if (siblingUsedPrefixes.contains(prefix) || parentPrefix != null && parentPrefix.equals(prefix)) {
            throw new IOFactoryException("The prefix " + prefix + " is not contextual unique. The context is defined by the following list: " + siblingUsedPrefixes);
        }
        HashSet<String> childrenUsedPrefixes = new HashSet<String>();
        TypeMapping<String> typeMapping = ((RbfTypeMappingRegistry)((Configuration)this.config).getTypeMappingRegistry()).get(dataTypeName);
        if (typeMapping instanceof RbfComplexTypeMapping) {
            RbfComplexTypeMapping complexTypeMapping = (RbfComplexTypeMapping)typeMapping;
            for (String fieldName : complexTypeMapping.getFieldNames(RbfNodeType.RECORD)) {
                RecordMapping recordMapping = (RecordMapping)complexTypeMapping.getNodeMapping(fieldName, Object.class);
                this.assertPrefixContextualUniqueness(((RecordDescriptor)recordMapping.getNodeDescriptor()).getPrefix(), (String)recordMapping.getDataTypeName(), prefix, childrenUsedPrefixes);
            }
            childrenUsedPrefixes.add(prefix);
        }
        if (typeMapping instanceof RbfListTypeMapping) {
            RbfListTypeMapping listTypeMapping = (RbfListTypeMapping)typeMapping;
            for (RecordMapping recordMapping : listTypeMapping.getNodeMappings()) {
                this.assertPrefixContextualUniqueness(((RecordDescriptor)recordMapping.getNodeDescriptor()).getPrefix(), (String)recordMapping.getDataTypeName(), parentPrefix, childrenUsedPrefixes);
            }
        }
        siblingUsedPrefixes.addAll(childrenUsedPrefixes);
    }
}

