/*
 * Decompiled with CFR 0.152.
 */
package org.jsefa.rbf.lowlevel;

import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import org.jsefa.common.lowlevel.InputPosition;
import org.jsefa.common.lowlevel.LowLevelDeserializationException;
import org.jsefa.common.lowlevel.filter.FilterResult;
import org.jsefa.common.lowlevel.filter.Line;
import org.jsefa.common.lowlevel.io.LineSegment;
import org.jsefa.common.lowlevel.io.LineSegmentReader;
import org.jsefa.rbf.lowlevel.RbfLowLevelDeserializer;
import org.jsefa.rbf.lowlevel.config.RbfLowLevelConfiguration;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class RbfLowLevelDeserializerImpl<C extends RbfLowLevelConfiguration>
implements RbfLowLevelDeserializer {
    private LineSegmentReader reader;
    private LineSegment currentSegment;
    private int currentColumnIndex;
    private C config;
    private List<Line> storedLines;
    private int lineFilterLimit;
    private int specialTerminator;

    public RbfLowLevelDeserializerImpl(C config) {
        this.config = config;
        if (((RbfLowLevelConfiguration)this.config).getSpecialRecordDelimiter() != null) {
            this.specialTerminator = ((RbfLowLevelConfiguration)this.config).getSpecialRecordDelimiter().charValue();
            this.lineFilterLimit = ((RbfLowLevelConfiguration)this.config).getLineFilterLimit();
        } else {
            this.lineFilterLimit = -1;
            this.specialTerminator = -1;
        }
    }

    @Override
    public final void open(Reader reader) {
        this.reader = new LineSegmentReader(reader);
        this.storedLines = new ArrayList<Line>();
    }

    @Override
    public final boolean readNextRecord() {
        if (this.withLineFilter() && !this.applyFilter()) {
            return false;
        }
        do {
            this.reader.mark();
            if (this.readNextSegment()) continue;
            return false;
        } while (this.currentSegment.getContent().length() == 0);
        return true;
    }

    @Override
    public final void unreadRecord() {
        this.currentColumnIndex = 0;
        this.reader.reset(true);
    }

    @Override
    public final void close(boolean closeReader) {
        if (closeReader) {
            try {
                this.reader.close();
            }
            catch (IOException e) {
                throw new LowLevelDeserializationException("Error while closing the deserialization stream", e);
            }
        }
        this.reader = null;
    }

    @Override
    public final InputPosition getInputPosition() {
        if (this.currentSegment != null) {
            return new InputPosition(this.currentSegment.getLineNumber(), this.currentSegment.getColumnNumber() + this.currentColumnIndex);
        }
        return null;
    }

    @Override
    public List<Line> getStoredLines() {
        return this.storedLines;
    }

    protected final C getConfiguration() {
        return this.config;
    }

    protected final boolean hasNextChar() {
        return this.currentColumnIndex < this.currentSegment.getContent().length();
    }

    protected final char peekChar() {
        try {
            return this.currentSegment.getContent().charAt(this.currentColumnIndex);
        }
        catch (IndexOutOfBoundsException e) {
            throw new LowLevelDeserializationException("Unexpected end of line reached");
        }
    }

    protected final char nextChar() {
        try {
            return this.currentSegment.getContent().charAt(this.currentColumnIndex++);
        }
        catch (IndexOutOfBoundsException e) {
            throw new LowLevelDeserializationException("Unexpected end of line reached");
        }
    }

    protected final String nextString(int length) {
        try {
            String value = this.currentSegment.getContent().substring(this.currentColumnIndex, this.currentColumnIndex + length);
            this.currentColumnIndex += length;
            return value;
        }
        catch (IndexOutOfBoundsException e) {
            if (this.currentColumnIndex < this.currentSegment.getContent().length()) {
                String value = this.currentSegment.getContent().substring(this.currentColumnIndex);
                this.currentColumnIndex += value.length();
                return value;
            }
            return null;
        }
    }

    protected final int remainingLineLength() {
        return this.currentSegment.getContent().length() - this.currentColumnIndex;
    }

    protected boolean readNextSegment() {
        try {
            this.currentSegment = this.reader.read(this.specialTerminator, -1);
            this.currentColumnIndex = 0;
            return this.currentSegment != null;
        }
        catch (IOException e) {
            throw new LowLevelDeserializationException(e);
        }
    }

    protected String getCurrentSegmentTerminatorString() {
        if (this.currentSegment == null) {
            return "";
        }
        switch (this.currentSegment.getTerminator()) {
            case LINE_BREAK: {
                return "\n";
            }
            case SPECIAL_CHARACTER: {
                return new StringBuffer().append(((RbfLowLevelConfiguration)this.config).getSpecialRecordDelimiter().charValue()).toString();
            }
        }
        return "";
    }

    protected LineSegment.Terminator getCurrentSegmentTerminator() {
        if (this.currentSegment == null) {
            return null;
        }
        return this.currentSegment.getTerminator();
    }

    private boolean withLineFilter() {
        return ((RbfLowLevelConfiguration)this.config).getLineFilter() != null;
    }

    /*
     * Unable to fully structure code
     */
    private boolean applyFilter() {
        try {
            block2: while (true) {
                this.reader.mark();
                lineToFilter = this.reader.read(this.lineFilterLimit);
                if (lineToFilter == null) {
                    return false;
                }
                if (lineToFilter.getContent().trim().length() == 0) continue;
                if (lineToFilter.getColumnNumber() > 1) {
                    this.reader.reset(false);
                    return true;
                }
                skipCounter = 1;
                if (lineToFilter.getTerminator() == LineSegment.Terminator.NONE) {
                    isLastLine = false;
                } else if (lineToFilter.getTerminator() == LineSegment.Terminator.EOS) {
                    isLastLine = true;
                } else {
                    nextLine = this.reader.read(this.lineFilterLimit);
                    while (nextLine != null && nextLine.getContent().trim().length() == 0) {
                        nextLine = this.reader.read(this.lineFilterLimit);
                        ++skipCounter;
                    }
                    isLastLine = nextLine == null;
                }
                this.reader.reset(false);
                if (this.passesFilter(lineToFilter, isLastLine)) break;
                if (isLastLine) {
                    return false;
                }
                i = 0;
                while (true) {
                    if (i < skipCounter) ** break;
                    continue block2;
                    this.reader.skipLine();
                    ++i;
                }
                break;
            }
            return true;
        }
        catch (IOException e) {
            throw new LowLevelDeserializationException(e);
        }
    }

    private boolean passesFilter(LineSegment line, boolean isLastLine) {
        boolean truncated = line.getTerminator() == LineSegment.Terminator.NONE;
        FilterResult result = ((RbfLowLevelConfiguration)this.config).getLineFilter().filter(line.getContent(), line.getLineNumber(), truncated, isLastLine);
        if (result == FilterResult.PASSED) {
            return true;
        }
        if (result == FilterResult.FAILED_BUT_STORE) {
            this.storedLines.add(new Line(line.getContent(), line.getLineNumber(), truncated, isLastLine));
        }
        return false;
    }
}

