/*
 * Decompiled with CFR 0.152.
 */
package org.jsefa.xml;

import java.lang.reflect.Method;
import org.jsefa.IOFactory;
import org.jsefa.IOFactoryException;
import org.jsefa.common.annotation.ValidatorFactory;
import org.jsefa.common.config.InitialConfiguration;
import org.jsefa.common.util.ReflectionUtil;
import org.jsefa.xml.XmlDeserializer;
import org.jsefa.xml.XmlIOFactoryImpl;
import org.jsefa.xml.XmlSerializer;
import org.jsefa.xml.annotation.XmlEntryPointFactory;
import org.jsefa.xml.annotation.XmlTypeMappingFactory;
import org.jsefa.xml.config.XmlConfiguration;
import org.jsefa.xml.mapping.XmlTypeMappingRegistry;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class XmlIOFactory
implements IOFactory {
    public static XmlIOFactory createFactory(XmlConfiguration config) {
        Class factoryClass = (Class)InitialConfiguration.get("jsefa:xml:ioFactoryClass", XmlIOFactoryImpl.class);
        Method createMethod = ReflectionUtil.getMethod(factoryClass, "createFactory", XmlConfiguration.class);
        if (createMethod == null) {
            throw new IOFactoryException("Failed to create an XmlIOFactory. The factory " + factoryClass + " does not contain the required static createFactory method.");
        }
        try {
            return (XmlIOFactory)ReflectionUtil.callMethod(null, createMethod, config);
        }
        catch (Exception e) {
            throw new IOFactoryException("Failed to create an XmlIOFactory", e);
        }
    }

    public static XmlIOFactory createFactory(Class<?> ... objectTypes) {
        return XmlIOFactory.createFactory(new XmlConfiguration(), objectTypes);
    }

    public static XmlIOFactory createFactory(XmlConfiguration config, Class<?> ... objectTypes) {
        XmlConfiguration newConfig = config.createCopy();
        try {
            XmlTypeMappingFactory typeMappingFactory = new XmlTypeMappingFactory((XmlTypeMappingRegistry)newConfig.getTypeMappingRegistry(), newConfig.getSimpleTypeConverterProvider(), newConfig.getValidatorProvider(), newConfig.getObjectAccessorProvider(), newConfig.getDataTypeDefaultNameRegistry());
            ValidatorFactory validatorFactory = new ValidatorFactory(newConfig.getValidatorProvider(), newConfig.getObjectAccessorProvider());
            XmlEntryPointFactory entryPointFactory = new XmlEntryPointFactory(typeMappingFactory, validatorFactory);
            newConfig.getEntryPoints().addAll(entryPointFactory.createEntryPoints(objectTypes));
            return XmlIOFactory.createFactory(newConfig);
        }
        catch (IOFactoryException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IOFactoryException("Failed to create an XmlIOFactory", e);
        }
    }

    @Override
    public abstract XmlSerializer createSerializer();

    @Override
    public abstract XmlDeserializer createDeserializer();
}

