/*
 * Decompiled with CFR 0.152.
 */
package org.jsefa.xml;

import java.io.Writer;
import java.util.Collection;
import java.util.IdentityHashMap;
import java.util.Map;
import org.jsefa.SerializationException;
import org.jsefa.common.accessor.ObjectAccessor;
import org.jsefa.common.config.ValidationMode;
import org.jsefa.common.mapping.TypeMapping;
import org.jsefa.common.util.ReflectionUtil;
import org.jsefa.common.validator.ValidationException;
import org.jsefa.common.validator.ValidationResult;
import org.jsefa.common.validator.Validator;
import org.jsefa.xml.XmlSerializer;
import org.jsefa.xml.config.XmlConfiguration;
import org.jsefa.xml.lowlevel.XmlLowLevelSerializer;
import org.jsefa.xml.mapping.AttributeDescriptor;
import org.jsefa.xml.mapping.AttributeMapping;
import org.jsefa.xml.mapping.ElementDescriptor;
import org.jsefa.xml.mapping.ElementMapping;
import org.jsefa.xml.mapping.TextContentMapping;
import org.jsefa.xml.mapping.XmlComplexTypeMapping;
import org.jsefa.xml.mapping.XmlListTypeMapping;
import org.jsefa.xml.mapping.XmlMapTypeMapping;
import org.jsefa.xml.mapping.XmlNodeMapping;
import org.jsefa.xml.mapping.XmlNodeType;
import org.jsefa.xml.mapping.XmlSimpleTypeMapping;
import org.jsefa.xml.mapping.XmlTypeMappingRegistry;
import org.jsefa.xml.namespace.QName;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class XmlSerializerImpl
implements XmlSerializer {
    private final XmlTypeMappingRegistry typeMappingRegistry;
    private final Map<Class<?>, ElementMapping> entryElementMappings;
    private final XmlLowLevelSerializer lowLevelSerializer;
    private IdentityHashMap<Object, Object> complexObjectsOnPath;
    private boolean validate;

    XmlSerializerImpl(XmlConfiguration config, Map<Class<?>, ElementMapping> entryElementMappings, XmlLowLevelSerializer lowLevelSerializer) {
        this.typeMappingRegistry = (XmlTypeMappingRegistry)config.getTypeMappingRegistry();
        this.entryElementMappings = entryElementMappings;
        this.lowLevelSerializer = lowLevelSerializer;
        this.complexObjectsOnPath = new IdentityHashMap();
        this.validate = config.getValidationMode().equals((Object)ValidationMode.SERIALIZATION) || config.getValidationMode().equals((Object)ValidationMode.BOTH);
    }

    @Override
    public void open(Writer writer) {
        this.complexObjectsOnPath.clear();
        try {
            this.lowLevelSerializer.open(writer);
        }
        catch (Exception e) {
            throw new SerializationException("Error while opening the serialization stream");
        }
    }

    @Override
    public void write(Object object) {
        if (object == null) {
            return;
        }
        try {
            ElementMapping nodeMapping = ReflectionUtil.getNearest(object.getClass(), this.entryElementMappings);
            if (nodeMapping == null) {
                throw new SerializationException("The following class was not registered for serialization: " + object.getClass());
            }
            if (this.validate) {
                this.assertValueIsValid(object, nodeMapping);
            }
            this.serializeElement(object, nodeMapping);
        }
        catch (SerializationException e) {
            throw e;
        }
        catch (Exception e) {
            throw new SerializationException(e);
        }
    }

    @Override
    public void flush() {
        try {
            this.lowLevelSerializer.flush();
        }
        catch (Exception e) {
            throw new SerializationException("Error while flushing the serialization stream");
        }
    }

    @Override
    public void close(boolean closeWriter) {
        try {
            this.lowLevelSerializer.close(closeWriter);
        }
        catch (Exception e) {
            throw new SerializationException("Error while closing the serialization stream");
        }
    }

    @Override
    public XmlLowLevelSerializer getLowLevelSerializer() {
        return this.lowLevelSerializer;
    }

    private void serializeAttribute(Object object, AttributeMapping attributeMapping) {
        if (object == null) {
            return;
        }
        String attributeValue = this.getSimpleTypeMapping(attributeMapping).getSimpleTypeConverter().toString(object);
        this.lowLevelSerializer.writeAttribute(((AttributeDescriptor)attributeMapping.getNodeDescriptor()).getName(), attributeValue);
    }

    private void serializeElement(Object object, ElementMapping elementMapping) {
        TypeMapping typeMapping = this.typeMappingRegistry.get(elementMapping.getDataTypeName());
        if (typeMapping == null) {
            throw new SerializationException("No type mapping given for data type name " + elementMapping.getDataTypeName());
        }
        if (typeMapping instanceof XmlSimpleTypeMapping) {
            this.serializeSimpleElement(object, elementMapping, (XmlSimpleTypeMapping)typeMapping);
        } else if (typeMapping instanceof XmlComplexTypeMapping) {
            this.serializeComplexElement(object, elementMapping, (XmlComplexTypeMapping)typeMapping);
        } else if (typeMapping instanceof XmlListTypeMapping) {
            this.serializeListElement(object, elementMapping, (XmlListTypeMapping)typeMapping);
        } else if (typeMapping instanceof XmlMapTypeMapping) {
            this.serializeMapElement(object, elementMapping, (XmlMapTypeMapping)typeMapping);
        }
    }

    private void serializeSimpleElement(Object object, ElementMapping elementMapping, XmlSimpleTypeMapping simpleTypeMapping) {
        Object value = this.getValue(object);
        if (value == null) {
            return;
        }
        this.writeStartElement(elementMapping);
        this.writeInjectedAttributes(object);
        String elementValue = simpleTypeMapping.getSimpleTypeConverter().toString(value);
        this.lowLevelSerializer.writeText(elementValue, elementMapping.getTextMode());
        this.lowLevelSerializer.writeEndElement();
    }

    private void serializeComplexElement(Object object, ElementMapping elementMapping, XmlComplexTypeMapping typeMapping) {
        Object fieldValue;
        Object value = this.getValue(object);
        if (value == null) {
            return;
        }
        if (this.complexObjectsOnPath.containsKey(value)) {
            throw new SerializationException("Cycle detected while serializing " + value);
        }
        this.complexObjectsOnPath.put(value, value);
        ObjectAccessor objectAccessor = typeMapping.getObjectAccessor();
        this.writeStartElement(elementMapping);
        this.writeInjectedAttributes(object);
        for (String fieldName : typeMapping.getFieldNames(XmlNodeType.ATTRIBUTE)) {
            fieldValue = objectAccessor.getValue(value, fieldName);
            if (fieldValue == null) continue;
            AttributeMapping attributeMapping = (AttributeMapping)typeMapping.getNodeMapping(fieldName, this.getNormalizedObjectType(fieldValue));
            this.serializeAttribute(fieldValue, attributeMapping);
        }
        for (String fieldName : typeMapping.getFieldNames(XmlNodeType.TEXT_CONTENT)) {
            fieldValue = objectAccessor.getValue(value, fieldName);
            if (fieldValue == null) continue;
            TextContentMapping textContentMapping = (TextContentMapping)typeMapping.getNodeMapping(fieldName, this.getNormalizedObjectType(fieldValue));
            String text = this.getSimpleTypeMapping(textContentMapping).getSimpleTypeConverter().toString(fieldValue);
            this.lowLevelSerializer.writeText(text, textContentMapping.getTextMode());
        }
        for (String fieldName : typeMapping.getFieldNames(XmlNodeType.ELEMENT)) {
            fieldValue = objectAccessor.getValue(value, fieldName);
            if (fieldValue == null) continue;
            ElementMapping childElementMapping = (ElementMapping)typeMapping.getNodeMapping(fieldName, this.getNormalizedObjectType(fieldValue));
            if (childElementMapping == null) {
                throw new SerializationException("Unable to serialize field class " + this.getNormalizedObjectType(fieldValue).getName() + " for field " + fieldName + " within object type " + typeMapping.getObjectType());
            }
            this.serializeElement(fieldValue, childElementMapping);
        }
        this.lowLevelSerializer.writeEndElement();
        this.complexObjectsOnPath.remove(value);
    }

    private void serializeListElement(Object object, ElementMapping elementMapping, XmlListTypeMapping typeMapping) {
        Collection listObject = (Collection)this.getValue(object);
        if (listObject == null) {
            return;
        }
        if (!typeMapping.isImplicit()) {
            this.writeStartElement(elementMapping);
            this.writeInjectedAttributes(object);
        }
        for (Object listItemValue : listObject) {
            ElementMapping listItemMapping = (ElementMapping)typeMapping.getNodeMapping(listItemValue.getClass());
            if (listItemMapping == null) {
                throw new SerializationException("No element mapping found for list item with class " + listItemValue.getClass());
            }
            this.serializeElement(listItemValue, listItemMapping);
        }
        if (!typeMapping.isImplicit()) {
            this.lowLevelSerializer.writeEndElement();
        }
    }

    private void serializeMapElement(Object object, ElementMapping elementMapping, XmlMapTypeMapping typeMapping) {
        Map mapObject = (Map)this.getValue(object);
        if (mapObject == null) {
            return;
        }
        if (!typeMapping.isImplicit()) {
            this.writeStartElement(elementMapping);
            this.writeInjectedAttributes(object);
        }
        for (Map.Entry entry : mapObject.entrySet()) {
            ElementMapping valueMapping = (ElementMapping)typeMapping.getValueNodeMapping(entry.getValue().getClass());
            if (valueMapping == null) {
                throw new SerializationException("No element mapping found for map value with class " + entry.getClass());
            }
            this.serializeElement(new MapEntryData(entry.getKey(), entry.getValue(), typeMapping), valueMapping);
        }
        if (!typeMapping.isImplicit()) {
            this.lowLevelSerializer.writeEndElement();
        }
    }

    private XmlSimpleTypeMapping getSimpleTypeMapping(XmlNodeMapping<?> nodeMapping) {
        return (XmlSimpleTypeMapping)this.typeMappingRegistry.get(nodeMapping.getDataTypeName());
    }

    private Class<?> getNormalizedObjectType(Object value) {
        Class<Object> objectType = value.getClass();
        if (Collection.class.isAssignableFrom(objectType)) {
            objectType = Collection.class;
        }
        return objectType;
    }

    private void writeStartElement(ElementMapping elementMapping) {
        if (elementMapping.elementNameIsAmbiguous()) {
            this.lowLevelSerializer.writeStartElement(((ElementDescriptor)elementMapping.getNodeDescriptor()).getName(), (QName)elementMapping.getDataTypeName());
        } else {
            this.lowLevelSerializer.writeStartElement(((ElementDescriptor)elementMapping.getNodeDescriptor()).getName(), null);
        }
    }

    private void writeInjectedAttributes(Object object) {
        if (object instanceof MapEntryData) {
            MapEntryData mapEntryData = (MapEntryData)object;
            this.serializeAttribute(mapEntryData.key, mapEntryData.attributeMapping);
        }
    }

    private void assertValueIsValid(Object object, XmlNodeMapping nodeMapping) {
        ValidationResult result;
        Validator validator = nodeMapping.getValidator();
        if (validator != null && !(result = validator.validate(object)).isValid()) {
            throw new ValidationException(result);
        }
    }

    private <T> T getValue(Object object) {
        if (object instanceof MapEntryData) {
            return (T)((MapEntryData)object).value;
        }
        return (T)object;
    }

    private static final class MapEntryData {
        final Object key;
        final Object value;
        final AttributeMapping attributeMapping;

        MapEntryData(Object key, Object value, XmlMapTypeMapping mapTypeMapping) {
            this.key = key;
            this.value = value;
            this.attributeMapping = (AttributeMapping)mapTypeMapping.getKeyNodeMapping();
        }
    }
}

