/*
 * Decompiled with CFR 0.152.
 */
package org.jsefa.xml.lowlevel;

import java.io.Writer;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.jsefa.common.lowlevel.LowLevelSerializationException;
import org.jsefa.xml.lowlevel.TextMode;
import org.jsefa.xml.lowlevel.XmlLowLevelSerializer;
import org.jsefa.xml.lowlevel.config.XmlLowLevelConfiguration;
import org.jsefa.xml.namespace.NamespaceManager;
import org.jsefa.xml.namespace.QName;

public final class StaxBasedXmlLowLevelSerializer
implements XmlLowLevelSerializer {
    private final XmlLowLevelConfiguration config;
    private Writer writer;
    private XMLStreamWriter streamWriter;
    private int depth = -1;
    private boolean lastWasStartElement;
    private NamespaceManager namespaceManager;

    public StaxBasedXmlLowLevelSerializer(XmlLowLevelConfiguration config) {
        this.config = config;
    }

    public void open(Writer writer) {
        this.writer = writer;
        XMLOutputFactory factory = XMLOutputFactory.newInstance();
        if (factory.isPropertySupported("com.ctc.wstx.outputEscapeCr")) {
            factory.setProperty("com.ctc.wstx.outputEscapeCr", Boolean.FALSE);
        }
        try {
            this.streamWriter = factory.createXMLStreamWriter(writer);
        }
        catch (XMLStreamException e) {
            throw new LowLevelSerializationException("Error while opening the serialization stream", e);
        }
        this.depth = -1;
        this.namespaceManager = this.config.getNamespaceManager();
    }

    public void writeXmlDeclaration(String version, String encoding) {
        try {
            this.streamWriter.writeStartDocument(encoding, version);
            this.writeLineBreak();
        }
        catch (XMLStreamException e) {
            throw new LowLevelSerializationException(e);
        }
    }

    public void writeDocTypeDeclaration(QName rootElementName, String publicId, String systemId) {
        StringBuilder dtd = new StringBuilder("<!DOCTYPE ");
        if (!this.hasNamespace(rootElementName)) {
            dtd.append(rootElementName.getLocalName());
        } else {
            this.namespaceManager = NamespaceManager.createWithParent(this.namespaceManager);
            String prefix = this.namespaceManager.getPrefix(rootElementName.getUri(), true);
            if (prefix == null) {
                prefix = this.namespaceManager.createPrefix(rootElementName.getUri(), true);
            }
            if (prefix.length() > 0) {
                dtd.append(prefix).append(":");
            }
            dtd.append(rootElementName.getLocalName());
        }
        if (publicId != null) {
            dtd.append(" PUBLIC \"").append(publicId).append("\" \"").append(systemId).append("\">");
        } else {
            dtd.append(" SYSTEM \"").append(systemId).append("\">");
        }
        try {
            this.streamWriter.writeDTD(dtd.toString());
            this.writeLineBreak();
        }
        catch (XMLStreamException e) {
            throw new LowLevelSerializationException(e);
        }
    }

    public void writeStartElement(QName name) {
        this.writeStartElement(name, null);
    }

    public void writeStartElement(QName name, QName dataTypeName) {
        ++this.depth;
        this.namespaceManager = NamespaceManager.createWithParent(this.namespaceManager);
        try {
            if (this.lastWasStartElement) {
                this.writeLineBreak();
            } else {
                this.lastWasStartElement = true;
            }
            this.writeIdent();
            if (!this.hasNamespace(name)) {
                this.streamWriter.writeStartElement(name.getLocalName());
                if (this.defaultNamespaceExists()) {
                    this.namespaceManager.registerPrefix("", "");
                    this.streamWriter.writeNamespace("", "");
                }
            } else {
                boolean createNamespace;
                String prefix = this.namespaceManager.getPrefix(name.getUri(), true);
                boolean bl = createNamespace = prefix == null;
                if (prefix == null) {
                    prefix = this.namespaceManager.createPrefix(name.getUri(), true);
                    this.namespaceManager.registerPrefix(prefix, name.getUri());
                }
                this.streamWriter.writeStartElement(prefix, name.getLocalName(), name.getUri());
                if (createNamespace) {
                    this.streamWriter.writeNamespace(prefix, name.getUri());
                }
            }
            if (dataTypeName != null) {
                String value = dataTypeName.getLocalName();
                if (this.hasNamespace(dataTypeName)) {
                    String prefix = this.namespaceManager.getPrefix(dataTypeName.getUri(), true);
                    if (prefix == null) {
                        prefix = this.namespaceManager.createPrefix(dataTypeName.getUri(), true);
                        this.namespaceManager.registerPrefix(prefix, dataTypeName.getUri());
                        this.streamWriter.writeNamespace(prefix, dataTypeName.getUri());
                    }
                    if (prefix.length() > 0) {
                        value = prefix + ":" + value;
                    }
                }
                this.writeAttribute(this.config.getDataTypeAttributeName(), value);
            }
        }
        catch (XMLStreamException e) {
            throw new LowLevelSerializationException("Unable to write element " + name, e);
        }
    }

    public void writeAttribute(QName name, String value) {
        if (value == null) {
            return;
        }
        try {
            if (!this.hasNamespace(name)) {
                this.streamWriter.writeAttribute(name.getLocalName(), value);
            } else {
                String prefix = this.namespaceManager.getPrefix(name.getUri(), false);
                if (prefix == null) {
                    prefix = this.namespaceManager.createPrefix(name.getUri(), false);
                    this.namespaceManager.registerPrefix(prefix, name.getUri());
                    this.streamWriter.writeNamespace(prefix, name.getUri());
                }
                this.streamWriter.writeAttribute(prefix, name.getUri(), name.getLocalName(), value);
            }
        }
        catch (XMLStreamException e) {
            throw new LowLevelSerializationException("Unable to write attribute " + name, e);
        }
    }

    public void writeText(String text, TextMode textMode) {
        if (text != null && text.length() != 0) {
            try {
                if (TextMode.CDATA.equals((Object)textMode)) {
                    int index = text.indexOf("]]>");
                    int lastIndex = 0;
                    while (index > -1) {
                        this.streamWriter.writeCData(text.substring(lastIndex, index + 2));
                        lastIndex = index + 2;
                        index = text.indexOf("]]>", index + 1);
                    }
                    this.streamWriter.writeCData(text.substring(lastIndex));
                } else {
                    this.streamWriter.writeCharacters(text);
                }
            }
            catch (XMLStreamException e) {
                throw new LowLevelSerializationException("Unable to write text", e);
            }
        }
    }

    public void writeEndElement() {
        try {
            if (!this.lastWasStartElement) {
                this.writeIdent();
            }
            this.lastWasStartElement = false;
            this.streamWriter.writeEndElement();
            this.writeLineBreak();
        }
        catch (XMLStreamException e) {
            throw new LowLevelSerializationException("Unable to finish element", e);
        }
        this.namespaceManager = this.namespaceManager.getParent();
        --this.depth;
    }

    public void flush() {
        try {
            this.streamWriter.flush();
        }
        catch (Exception e) {
            throw new LowLevelSerializationException("Error while flushing the serialization stream", e);
        }
    }

    public void close(boolean closeWriter) {
        try {
            this.streamWriter.close();
            if (closeWriter) {
                this.writer.close();
            }
        }
        catch (Exception e) {
            throw new LowLevelSerializationException("Error while closing the serialization stream", e);
        }
    }

    private void writeLineBreak() throws XMLStreamException {
        this.streamWriter.writeCharacters(this.config.getLineBreak());
    }

    private void writeIdent() throws XMLStreamException {
        String lineIndentation = this.config.getLineIndentation();
        if (lineIndentation.length() > 0) {
            for (int i = 0; i < this.depth; ++i) {
                this.streamWriter.writeCharacters(lineIndentation);
            }
        }
    }

    private boolean hasNamespace(QName name) {
        return !"".equals(name.getUri());
    }

    private boolean defaultNamespaceExists() {
        String registeredUri = this.namespaceManager.getUri("");
        return registeredUri != null && !registeredUri.equals("");
    }
}

