/*
 * Decompiled with CFR 0.152.
 */
package org.jsefa.xml.lowlevel;

import java.lang.reflect.Method;
import org.jsefa.IOFactoryException;
import org.jsefa.common.config.InitialConfiguration;
import org.jsefa.common.lowlevel.LowLevelIOFactory;
import org.jsefa.common.util.ReflectionUtil;
import org.jsefa.xml.lowlevel.XmlLowLevelDeserializer;
import org.jsefa.xml.lowlevel.XmlLowLevelSerializer;
import org.jsefa.xml.lowlevel.config.XmlLowLevelConfiguration;

public abstract class XmlLowLevelIOFactory
implements LowLevelIOFactory {
    public static XmlLowLevelIOFactory createFactory(XmlLowLevelConfiguration config) {
        Class<?> ioFactoryClass = null;
        if (ReflectionUtil.hasClass("org.jsefa.xml.lowlevel.StaxBasedXmlLowLevelIOFactory")) {
            ioFactoryClass = ReflectionUtil.getClass("org.jsefa.xml.lowlevel.StaxBasedXmlLowLevelIOFactory");
        } else if (ReflectionUtil.hasClass("org.jsefa.xml.lowlevel.XmlPullBasedXmlLowLevelIOFactory")) {
            ioFactoryClass = ReflectionUtil.getClass("org.jsefa.xml.lowlevel.XmlPullBasedXmlLowLevelIOFactory");
        }
        if (ioFactoryClass == null) {
            throw new IOFactoryException("Failed to create an XmlLowLevelIOFactory");
        }
        Class factoryClass = (Class)InitialConfiguration.get("jsefa:xml:lowlevel:ioFactoryClass", ioFactoryClass);
        Method createMethod = ReflectionUtil.getMethod(factoryClass, "createFactory", XmlLowLevelConfiguration.class);
        if (createMethod == null) {
            throw new IOFactoryException("Failed to create an XmlLowLevelIOFactory. The factory " + factoryClass + " does not contain the required static createFactory method.");
        }
        try {
            return (XmlLowLevelIOFactory)ReflectionUtil.callMethod(null, createMethod, config);
        }
        catch (Exception e) {
            throw new IOFactoryException("Failed to create an XmlLowLevelIOFactory", e);
        }
    }

    public abstract XmlLowLevelSerializer createSerializer();

    public abstract XmlLowLevelDeserializer createDeserializer();
}

