/*
 * Decompiled with CFR 0.152.
 */
package org.jsefa.xml.mapping;

import org.jsefa.xml.mapping.XmlNodeDescriptor;
import org.jsefa.xml.mapping.XmlNodeType;
import org.jsefa.xml.namespace.QName;

public final class ElementDescriptor
implements XmlNodeDescriptor {
    private final QName name;
    private final QName dataTypeName;
    private final int hashCode;

    public ElementDescriptor(QName name, QName dataTypeName) {
        if (name == null && dataTypeName == null) {
            throw new IllegalArgumentException("Both parameters (name, dataTypeName) are null but one of them must not be null!");
        }
        this.name = name;
        this.dataTypeName = dataTypeName;
        this.hashCode = this.calculateHashCode();
    }

    public XmlNodeType getType() {
        return XmlNodeType.ELEMENT;
    }

    public QName getName() {
        return this.name;
    }

    public QName getDataTypeName() {
        return this.dataTypeName;
    }

    public int hashCode() {
        return this.hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof ElementDescriptor)) {
            return false;
        }
        ElementDescriptor other = (ElementDescriptor)obj;
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        return !(this.dataTypeName == null ? other.dataTypeName != null : !this.dataTypeName.equals(other.dataTypeName));
    }

    public String toString() {
        if (this.name == null) {
            return this.dataTypeName.toString();
        }
        if (this.dataTypeName == null) {
            return this.name.toString();
        }
        return this.getName().toString() + ":" + this.getDataTypeName();
    }

    private int calculateHashCode() {
        int resultCode = 1;
        if (this.name != null) {
            resultCode = 31 * resultCode + this.name.hashCode();
        }
        if (this.dataTypeName != null) {
            resultCode = 31 * resultCode + this.dataTypeName.hashCode();
        }
        return resultCode;
    }
}

