/*
 * Decompiled with CFR 0.152.
 */
package org.jsefa.xml.namespace;

import java.util.HashMap;
import java.util.Map;
import org.jsefa.xml.namespace.NamespaceRegistrationException;

public final class NamespaceManager {
    private final NamespaceManager parent;
    private final Map<String, String> preferredPrefixes;
    private Map<String, String> prefixes;
    private Map<String, String> uris;
    private String defaultURI;
    private boolean hasOwnRegistries;

    public static NamespaceManager create() {
        return new NamespaceManager();
    }

    public static NamespaceManager createWithParent(NamespaceManager parent) {
        return new NamespaceManager(parent, true);
    }

    private NamespaceManager() {
        this.parent = null;
        this.createOwnRegistries();
        this.preferredPrefixes = new HashMap<String, String>();
        this.registerPrefix("xml", "http://www.w3.org/XML/1998/namespace");
    }

    private NamespaceManager(NamespaceManager other, boolean otherIsParent) {
        if (otherIsParent) {
            this.parent = other;
            this.preferredPrefixes = other.preferredPrefixes;
        } else {
            this.parent = other.parent;
            this.preferredPrefixes = other.preferredPrefixes;
            this.hasOwnRegistries = other.hasOwnRegistries;
            if (this.hasOwnRegistries) {
                this.prefixes = new HashMap<String, String>(other.prefixes);
                this.uris = new HashMap<String, String>(other.uris);
                this.defaultURI = other.defaultURI;
            }
        }
    }

    public NamespaceManager createCopy() {
        return new NamespaceManager(this, false);
    }

    public NamespaceManager getParent() {
        return this.parent;
    }

    public void registerPreferredPrefix(String prefix, String uri) {
        if (this.parent != null) {
            throw new NamespaceRegistrationException("A preferred prefix can be registered for a root namespace manager only");
        }
        this.preferredPrefixes.put(uri, prefix);
    }

    public void registerPrefix(String prefix, String uri) {
        if (prefix == null || uri == null) {
            throw new NullPointerException("The parameters prefix and uri must not be null");
        }
        if (this.hasOwnRegistries) {
            if (this.isDefault(prefix)) {
                if (this.defaultURI != null && !uri.equals(this.defaultURI)) {
                    throw new NamespaceRegistrationException("The default prefix is already bound to the uri " + this.defaultURI + " and can not be bound to " + uri);
                }
            } else {
                if (this.prefixes.containsKey(uri) && !prefix.equals(this.prefixes.get(uri))) {
                    throw new NamespaceRegistrationException("The uri " + uri + " is already bound to the prefix " + this.prefixes.get(uri) + " and can not be bound to " + prefix);
                }
                if (this.uris.containsKey(prefix) && !uri.equals(this.uris.get(prefix))) {
                    throw new NamespaceRegistrationException("The prefix " + prefix + " is already bound to the uri " + this.uris.get(prefix) + " and can not be bound to " + uri);
                }
            }
        } else {
            this.createOwnRegistries();
        }
        if (this.isDefault(prefix)) {
            this.defaultURI = uri;
        } else {
            this.prefixes.put(uri, prefix);
            this.uris.put(prefix, uri);
        }
    }

    public String getPrefix(String uri, boolean defaultAllowed) {
        if (!this.hasOwnRegistries) {
            return this.parent.getPrefix(uri, defaultAllowed);
        }
        if (defaultAllowed && uri.equals(this.defaultURI)) {
            return "";
        }
        String prefix = this.prefixes.get(uri);
        if (prefix == null && this.parent != null && (prefix = this.parent.getPrefix(uri, defaultAllowed)) != null) {
            if (this.uris.containsKey(prefix)) {
                prefix = null;
            } else if (this.isDefault(prefix) && this.defaultURI != null) {
                prefix = null;
            }
        }
        return prefix;
    }

    public String createPrefix(String uri, boolean defaultAllowed) {
        if (uri == null) {
            throw new NullPointerException("The parameter uri must not be null");
        }
        String prefix = this.preferredPrefixes.get(uri);
        if (prefix != null && this.getUri(prefix) != null) {
            prefix = null;
        }
        if (prefix == null) {
            prefix = "";
            if (!defaultAllowed || this.getUri(prefix) != null) {
                int no = 1;
                while (this.getUri(prefix = "ns" + no++) != null) {
                }
            }
        }
        return prefix;
    }

    public String getUri(String prefix) {
        if (!this.hasOwnRegistries) {
            return this.parent.getUri(prefix);
        }
        String uri = null;
        uri = this.isDefault(prefix) ? this.defaultURI : this.uris.get(prefix);
        if (uri == null && this.parent != null) {
            uri = this.parent.getUri(prefix);
        }
        return uri;
    }

    private void createOwnRegistries() {
        this.prefixes = new HashMap<String, String>();
        this.uris = new HashMap<String, String>();
        this.hasOwnRegistries = true;
    }

    private boolean isDefault(String prefix) {
        return "".equals(prefix);
    }
}

