/*
 * Decompiled with CFR 0.152.
 */
package org.jsefa.xml.namespace;

import org.jsefa.xml.namespace.NamespaceManager;
import org.jsefa.xml.namespace.QName;

public final class QNameParser {
    public static QName parse(String name, boolean forElement, NamespaceManager namespaceManager) {
        if (name == null) {
            throw new NullPointerException("Argument name must not be null");
        }
        if (name.length() == 0) {
            throw new IllegalArgumentException("Argument name must not be an empty string");
        }
        int delimiterPos = name.indexOf(":");
        if (delimiterPos == -1) {
            String defaultNamespaceURI;
            if (forElement && (defaultNamespaceURI = namespaceManager.getUri("")) != null) {
                return QName.create(defaultNamespaceURI, name);
            }
            return QName.create("", name);
        }
        String prefix = name.substring(0, delimiterPos);
        String uri = namespaceManager.getUri(prefix);
        if (uri == null) {
            throw new IllegalArgumentException("Undeclared namespace prefix: " + prefix);
        }
        String localName = "";
        if (delimiterPos >= name.length() - 1) {
            throw new IllegalArgumentException("Invalid QName representation: " + name);
        }
        localName = name.substring(delimiterPos + 1);
        return QName.create(uri, localName);
    }

    private QNameParser() {
    }
}

