/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.bcel.internal.generic;

import com.sun.org.apache.bcel.internal.generic.BranchInstruction;
import com.sun.org.apache.bcel.internal.generic.ClassGenException;
import com.sun.org.apache.bcel.internal.generic.InstructionHandle;
import com.sun.org.apache.bcel.internal.generic.StackProducer;
import com.sun.org.apache.bcel.internal.generic.VariableLengthInstruction;
import com.sun.org.apache.bcel.internal.util.ByteSequence;
import java.io.DataOutputStream;
import java.io.IOException;

public abstract class Select
extends BranchInstruction
implements VariableLengthInstruction,
StackProducer {
    protected int[] match;
    protected int[] indices;
    protected InstructionHandle[] targets;
    protected int fixed_length;
    protected int match_length;
    protected int padding = 0;

    Select() {
    }

    Select(short s, int[] nArray, InstructionHandle[] instructionHandleArray, InstructionHandle instructionHandle) {
        super(s, instructionHandle);
        this.targets = instructionHandleArray;
        for (int i = 0; i < instructionHandleArray.length; ++i) {
            Select.notifyTarget(null, instructionHandleArray[i], this);
        }
        this.match = nArray;
        this.match_length = nArray.length;
        if (this.match_length != instructionHandleArray.length) {
            throw new ClassGenException("Match and target array have not the same length");
        }
        this.indices = new int[this.match_length];
    }

    protected int updatePosition(int n, int n2) {
        this.position += n;
        short s = this.length;
        this.padding = (4 - (this.position + 1) % 4) % 4;
        this.length = (short)(this.fixed_length + this.padding);
        return this.length - s;
    }

    public void dump(DataOutputStream dataOutputStream) throws IOException {
        dataOutputStream.writeByte(this.opcode);
        for (int i = 0; i < this.padding; ++i) {
            dataOutputStream.writeByte(0);
        }
        this.index = this.getTargetOffset();
        dataOutputStream.writeInt(this.index);
    }

    protected void initFromFile(ByteSequence byteSequence, boolean bl) throws IOException {
        this.padding = (4 - byteSequence.getIndex() % 4) % 4;
        for (int i = 0; i < this.padding; ++i) {
            byte by = byteSequence.readByte();
            if (by == 0) continue;
            throw new ClassGenException("Padding byte != 0: " + by);
        }
        this.index = byteSequence.readInt();
    }

    public String toString(boolean bl) {
        StringBuffer stringBuffer = new StringBuffer(super.toString(bl));
        if (bl) {
            for (int i = 0; i < this.match_length; ++i) {
                String string = "null";
                if (this.targets[i] != null) {
                    string = this.targets[i].getInstruction().toString();
                }
                stringBuffer.append("(" + this.match[i] + ", " + string + " = {" + this.indices[i] + "})");
            }
        } else {
            stringBuffer.append(" ...");
        }
        return stringBuffer.toString();
    }

    public void setTarget(int n, InstructionHandle instructionHandle) {
        Select.notifyTarget(this.targets[n], instructionHandle, this);
        this.targets[n] = instructionHandle;
    }

    public void updateTarget(InstructionHandle instructionHandle, InstructionHandle instructionHandle2) {
        boolean bl = false;
        if (this.target == instructionHandle) {
            bl = true;
            this.setTarget(instructionHandle2);
        }
        for (int i = 0; i < this.targets.length; ++i) {
            if (this.targets[i] != instructionHandle) continue;
            bl = true;
            this.setTarget(i, instructionHandle2);
        }
        if (!bl) {
            throw new ClassGenException("Not targeting " + instructionHandle);
        }
    }

    public boolean containsTarget(InstructionHandle instructionHandle) {
        if (this.target == instructionHandle) {
            return true;
        }
        for (int i = 0; i < this.targets.length; ++i) {
            if (this.targets[i] != instructionHandle) continue;
            return true;
        }
        return false;
    }

    void dispose() {
        super.dispose();
        for (int i = 0; i < this.targets.length; ++i) {
            this.targets[i].removeTargeter(this);
        }
    }

    public int[] getMatchs() {
        return this.match;
    }

    public int[] getIndices() {
        return this.indices;
    }

    public InstructionHandle[] getTargets() {
        return this.targets;
    }
}

