/*
 * Decompiled with CFR 0.152.
 */
package sun.misc;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.ByteBuffer;
import java.security.CodeSigner;
import java.security.cert.Certificate;
import java.util.jar.Manifest;
import sun.misc.IOUtils;
import sun.nio.ByteBuffered;

public abstract class Resource {
    private InputStream cis;

    public abstract String getName();

    public abstract URL getURL();

    public abstract URL getCodeSourceURL();

    public abstract InputStream getInputStream() throws IOException;

    public abstract int getContentLength() throws IOException;

    private synchronized InputStream cachedInputStream() throws IOException {
        if (this.cis == null) {
            this.cis = this.getInputStream();
        }
        return this.cis;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] getBytes() throws IOException {
        byte[] byArray;
        InputStream inputStream = this.cachedInputStream();
        int n = this.getContentLength();
        try {
            byArray = IOUtils.readFully(inputStream, n, true);
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            inputStream.close();
            throw throwable;
        }
        inputStream.close();
        return byArray;
    }

    public ByteBuffer getByteBuffer() throws IOException {
        InputStream inputStream = this.cachedInputStream();
        if (inputStream instanceof ByteBuffered) {
            return ((ByteBuffered)((Object)inputStream)).getByteBuffer();
        }
        return null;
    }

    public Manifest getManifest() throws IOException {
        return null;
    }

    public Certificate[] getCertificates() {
        return null;
    }

    public CodeSigner[] getCodeSigners() {
        return null;
    }
}

