/*
 * Decompiled with CFR 0.152.
 */
package sun.rmi.server;

import java.io.File;
import java.io.FilePermission;
import java.io.IOException;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.SoftReference;
import java.lang.ref.WeakReference;
import java.lang.reflect.Modifier;
import java.lang.reflect.Proxy;
import java.net.MalformedURLException;
import java.net.SocketPermission;
import java.net.URL;
import java.net.URLClassLoader;
import java.rmi.server.LogStream;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.CodeSource;
import java.security.Permission;
import java.security.PermissionCollection;
import java.security.Permissions;
import java.security.Policy;
import java.security.PrivilegedAction;
import java.security.ProtectionDomain;
import java.security.cert.Certificate;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.PropertyPermission;
import java.util.StringTokenizer;
import java.util.WeakHashMap;
import sun.rmi.runtime.Log;
import sun.security.action.GetPropertyAction;

public final class LoaderHandler {
    static final int logLevel = LogStream.parseLevel((String)AccessController.doPrivileged(new GetPropertyAction("sun.rmi.loader.logLevel")));
    static final Log loaderLog = Log.getLog("sun.rmi.loader", "loader", logLevel);
    private static String codebaseProperty = null;
    private static URL[] codebaseURLs;
    private static final Map codebaseLoaders;
    private static final HashMap loaderTable;
    private static final ReferenceQueue refQueue;
    private static final Map pathToURLsCache;

    private LoaderHandler() {
    }

    private static synchronized URL[] getDefaultCodebaseURLs() throws MalformedURLException {
        if (codebaseURLs == null) {
            codebaseURLs = codebaseProperty != null ? LoaderHandler.pathToURLs(codebaseProperty) : new URL[0];
        }
        return codebaseURLs;
    }

    public static Class loadClass(String string, String string2, ClassLoader classLoader) throws MalformedURLException, ClassNotFoundException {
        if (loaderLog.isLoggable(Log.BRIEF)) {
            loaderLog.log(Log.BRIEF, "name = \"" + string2 + "\", " + "codebase = \"" + (string != null ? string : "") + "\"" + (classLoader != null ? ", defaultLoader = " + classLoader : ""));
        }
        URL[] uRLArray = string != null ? LoaderHandler.pathToURLs(string) : LoaderHandler.getDefaultCodebaseURLs();
        if (classLoader != null) {
            try {
                Class<?> clazz = Class.forName(string2, false, classLoader);
                if (loaderLog.isLoggable(Log.VERBOSE)) {
                    loaderLog.log(Log.VERBOSE, "class \"" + string2 + "\" found via defaultLoader, " + "defined by " + clazz.getClassLoader());
                }
                return clazz;
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        return LoaderHandler.loadClass(uRLArray, string2);
    }

    public static String getClassAnnotation(Class clazz) {
        ClassLoader classLoader;
        String string = clazz.getName();
        int n = string.length();
        if (n > 0 && string.charAt(0) == '[') {
            int n2;
            for (n2 = 1; n > n2 && string.charAt(n2) == '['; ++n2) {
            }
            if (n > n2 && string.charAt(n2) != 'L') {
                return null;
            }
        }
        if ((classLoader = clazz.getClassLoader()) == null || codebaseLoaders.containsKey(classLoader)) {
            return codebaseProperty;
        }
        String string2 = null;
        if (classLoader instanceof Loader) {
            string2 = ((Loader)classLoader).getClassAnnotation();
        } else if (classLoader instanceof URLClassLoader) {
            try {
                URL[] uRLArray = ((URLClassLoader)classLoader).getURLs();
                if (uRLArray != null) {
                    SecurityManager securityManager = System.getSecurityManager();
                    if (securityManager != null) {
                        for (int i = 0; i < uRLArray.length; ++i) {
                            Permission permission = uRLArray[i].openConnection().getPermission();
                            if (permission == null) continue;
                            securityManager.checkPermission(permission);
                        }
                    }
                    string2 = LoaderHandler.urlsToPath(uRLArray);
                }
            }
            catch (SecurityException securityException) {
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (string2 != null) {
            return string2;
        }
        return codebaseProperty;
    }

    public static ClassLoader getClassLoader(String string) throws MalformedURLException {
        ClassLoader classLoader = LoaderHandler.getRMIContextClassLoader();
        URL[] uRLArray = string != null ? LoaderHandler.pathToURLs(string) : LoaderHandler.getDefaultCodebaseURLs();
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager == null) {
            return classLoader;
        }
        securityManager.checkPermission(new RuntimePermission("getClassLoader"));
        Loader loader = LoaderHandler.lookupLoader(uRLArray, classLoader);
        if (loader != null) {
            loader.checkPermissions();
        }
        return loader;
    }

    public static Object getSecurityContext(ClassLoader classLoader) {
        URL[] uRLArray;
        if (classLoader instanceof Loader && (uRLArray = ((Loader)classLoader).getURLs()).length > 0) {
            return uRLArray[0];
        }
        return null;
    }

    public static void registerCodebaseLoader(ClassLoader classLoader) {
        codebaseLoaders.put(classLoader, null);
    }

    private static Class loadClass(URL[] uRLArray, String string) throws ClassNotFoundException {
        SecurityManager securityManager;
        ClassLoader classLoader = LoaderHandler.getRMIContextClassLoader();
        if (loaderLog.isLoggable(Log.VERBOSE)) {
            loaderLog.log(Log.VERBOSE, "(thread context class loader: " + classLoader + ")");
        }
        if ((securityManager = System.getSecurityManager()) == null) {
            try {
                Class<?> clazz = Class.forName(string, false, classLoader);
                if (loaderLog.isLoggable(Log.VERBOSE)) {
                    loaderLog.log(Log.VERBOSE, "class \"" + string + "\" found via " + "thread context class loader " + "(no security manager: codebase disabled), " + "defined by " + clazz.getClassLoader());
                }
                return clazz;
            }
            catch (ClassNotFoundException classNotFoundException) {
                if (loaderLog.isLoggable(Log.BRIEF)) {
                    loaderLog.log(Log.BRIEF, "class \"" + string + "\" not found via " + "thread context class loader " + "(no security manager: codebase disabled)", classNotFoundException);
                }
                throw new ClassNotFoundException(classNotFoundException.getMessage() + " (no security manager: RMI class loader disabled)", classNotFoundException.getException());
            }
        }
        Loader loader = LoaderHandler.lookupLoader(uRLArray, classLoader);
        try {
            if (loader != null) {
                loader.checkPermissions();
            }
        }
        catch (SecurityException securityException) {
            try {
                Class<?> clazz = Class.forName(string, false, classLoader);
                if (loaderLog.isLoggable(Log.VERBOSE)) {
                    loaderLog.log(Log.VERBOSE, "class \"" + string + "\" found via " + "thread context class loader " + "(access to codebase denied), " + "defined by " + clazz.getClassLoader());
                }
                return clazz;
            }
            catch (ClassNotFoundException classNotFoundException) {
                if (loaderLog.isLoggable(Log.BRIEF)) {
                    loaderLog.log(Log.BRIEF, "class \"" + string + "\" not found via " + "thread context class loader " + "(access to codebase denied)", securityException);
                }
                throw new ClassNotFoundException("access to class loader denied", securityException);
            }
        }
        try {
            Class<?> clazz = Class.forName(string, false, loader);
            if (loaderLog.isLoggable(Log.VERBOSE)) {
                loaderLog.log(Log.VERBOSE, "class \"" + string + "\" " + "found via codebase, " + "defined by " + clazz.getClassLoader());
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            if (loaderLog.isLoggable(Log.BRIEF)) {
                loaderLog.log(Log.BRIEF, "class \"" + string + "\" not found via codebase", classNotFoundException);
            }
            throw classNotFoundException;
        }
    }

    public static Class loadProxyClass(String string, String[] stringArray, ClassLoader classLoader) throws MalformedURLException, ClassNotFoundException {
        if (loaderLog.isLoggable(Log.BRIEF)) {
            loaderLog.log(Log.BRIEF, "interfaces = " + Arrays.asList(stringArray) + ", " + "codebase = \"" + (string != null ? string : "") + "\"" + (classLoader != null ? ", defaultLoader = " + classLoader : ""));
        }
        ClassLoader classLoader2 = LoaderHandler.getRMIContextClassLoader();
        if (loaderLog.isLoggable(Log.VERBOSE)) {
            loaderLog.log(Log.VERBOSE, "(thread context class loader: " + classLoader2 + ")");
        }
        URL[] uRLArray = string != null ? LoaderHandler.pathToURLs(string) : LoaderHandler.getDefaultCodebaseURLs();
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager == null) {
            try {
                Class clazz = LoaderHandler.loadProxyClass(stringArray, classLoader, classLoader2, false);
                if (loaderLog.isLoggable(Log.VERBOSE)) {
                    loaderLog.log(Log.VERBOSE, "(no security manager: codebase disabled) proxy class defined by " + clazz.getClassLoader());
                }
                return clazz;
            }
            catch (ClassNotFoundException classNotFoundException) {
                if (loaderLog.isLoggable(Log.BRIEF)) {
                    loaderLog.log(Log.BRIEF, "(no security manager: codebase disabled) proxy class resolution failed", classNotFoundException);
                }
                throw new ClassNotFoundException(classNotFoundException.getMessage() + " (no security manager: RMI class loader disabled)", classNotFoundException.getException());
            }
        }
        Loader loader = LoaderHandler.lookupLoader(uRLArray, classLoader2);
        try {
            if (loader != null) {
                loader.checkPermissions();
            }
        }
        catch (SecurityException securityException) {
            try {
                Class clazz = LoaderHandler.loadProxyClass(stringArray, classLoader, classLoader2, false);
                if (loaderLog.isLoggable(Log.VERBOSE)) {
                    loaderLog.log(Log.VERBOSE, "(access to codebase denied) proxy class defined by " + clazz.getClassLoader());
                }
                return clazz;
            }
            catch (ClassNotFoundException classNotFoundException) {
                if (loaderLog.isLoggable(Log.BRIEF)) {
                    loaderLog.log(Log.BRIEF, "(access to codebase denied) proxy class resolution failed", securityException);
                }
                throw new ClassNotFoundException("access to class loader denied", securityException);
            }
        }
        try {
            Class clazz = LoaderHandler.loadProxyClass(stringArray, classLoader, loader, true);
            if (loaderLog.isLoggable(Log.VERBOSE)) {
                loaderLog.log(Log.VERBOSE, "proxy class defined by " + clazz.getClassLoader());
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            if (loaderLog.isLoggable(Log.BRIEF)) {
                loaderLog.log(Log.BRIEF, "proxy class resolution failed", classNotFoundException);
            }
            throw classNotFoundException;
        }
    }

    private static Class loadProxyClass(String[] stringArray, ClassLoader classLoader, ClassLoader classLoader2, boolean bl) throws ClassNotFoundException {
        boolean[] blArray;
        Class[] classArray;
        ClassLoader classLoader3;
        block12: {
            classLoader3 = null;
            classArray = new Class[stringArray.length];
            blArray = new boolean[]{false};
            if (classLoader != null) {
                block11: {
                    try {
                        classLoader3 = LoaderHandler.loadProxyInterfaces(stringArray, classLoader, classArray, blArray);
                        if (!loaderLog.isLoggable(Log.VERBOSE)) break block11;
                        ClassLoader[] classLoaderArray = new ClassLoader[classArray.length];
                        for (int i = 0; i < classLoaderArray.length; ++i) {
                            classLoaderArray[i] = classArray[i].getClassLoader();
                        }
                        loaderLog.log(Log.VERBOSE, "proxy interfaces found via defaultLoader, defined by " + Arrays.asList(classLoaderArray));
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        break block12;
                    }
                }
                if (!blArray[0]) {
                    if (bl) {
                        try {
                            return Proxy.getProxyClass(classLoader2, classArray);
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            // empty catch block
                        }
                    }
                    classLoader3 = classLoader;
                }
                return LoaderHandler.loadProxyClass(classLoader3, classArray);
            }
        }
        blArray[0] = false;
        classLoader3 = LoaderHandler.loadProxyInterfaces(stringArray, classLoader2, classArray, blArray);
        if (loaderLog.isLoggable(Log.VERBOSE)) {
            ClassLoader[] classLoaderArray = new ClassLoader[classArray.length];
            for (int i = 0; i < classLoaderArray.length; ++i) {
                classLoaderArray[i] = classArray[i].getClassLoader();
            }
            loaderLog.log(Log.VERBOSE, "proxy interfaces found via codebase, defined by " + Arrays.asList(classLoaderArray));
        }
        if (!blArray[0]) {
            classLoader3 = classLoader2;
        }
        return LoaderHandler.loadProxyClass(classLoader3, classArray);
    }

    private static Class loadProxyClass(ClassLoader classLoader, Class[] classArray) throws ClassNotFoundException {
        try {
            return Proxy.getProxyClass(classLoader, classArray);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new ClassNotFoundException("error creating dynamic proxy class", illegalArgumentException);
        }
    }

    private static ClassLoader loadProxyInterfaces(String[] stringArray, ClassLoader classLoader, Class[] classArray, boolean[] blArray) throws ClassNotFoundException {
        ClassLoader classLoader2 = null;
        for (int i = 0; i < stringArray.length; ++i) {
            classArray[i] = Class.forName(stringArray[i], false, classLoader);
            Class<?> clazz = classArray[i];
            if (Modifier.isPublic(clazz.getModifiers())) continue;
            ClassLoader classLoader3 = clazz.getClassLoader();
            if (loaderLog.isLoggable(Log.VERBOSE)) {
                loaderLog.log(Log.VERBOSE, "non-public interface \"" + stringArray[i] + "\" defined by " + classLoader3);
            }
            if (!blArray[0]) {
                classLoader2 = classLoader3;
                blArray[0] = true;
                continue;
            }
            if (classLoader3 == classLoader2) continue;
            throw new IllegalAccessError("non-public interfaces defined in different class loaders");
        }
        return classLoader2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static URL[] pathToURLs(String string) throws MalformedURLException {
        Object[] objectArray;
        Object object = pathToURLsCache;
        synchronized (object) {
            objectArray = (Object[])pathToURLsCache.get(string);
            if (objectArray != null) {
                return (URL[])objectArray[0];
            }
        }
        object = new StringTokenizer(string);
        objectArray = new URL[((StringTokenizer)object).countTokens()];
        int n = 0;
        while (((StringTokenizer)object).hasMoreTokens()) {
            objectArray[n] = new URL(((StringTokenizer)object).nextToken());
            ++n;
        }
        Map map = pathToURLsCache;
        synchronized (map) {
            pathToURLsCache.put(string, new Object[]{objectArray, new SoftReference<String>(string)});
        }
        return objectArray;
    }

    private static String urlsToPath(URL[] uRLArray) {
        if (uRLArray.length == 0) {
            return null;
        }
        if (uRLArray.length == 1) {
            return uRLArray[0].toExternalForm();
        }
        StringBuffer stringBuffer = new StringBuffer(uRLArray[0].toExternalForm());
        for (int i = 1; i < uRLArray.length; ++i) {
            stringBuffer.append(' ');
            stringBuffer.append(uRLArray[i].toExternalForm());
        }
        return stringBuffer.toString();
    }

    private static ClassLoader getRMIContextClassLoader() {
        return Thread.currentThread().getContextClassLoader();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Loader lookupLoader(final URL[] uRLArray, final ClassLoader classLoader) {
        Class<LoaderHandler> clazz = LoaderHandler.class;
        synchronized (LoaderHandler.class) {
            Loader loader;
            LoaderEntry loaderEntry;
            while ((loaderEntry = (LoaderEntry)refQueue.poll()) != null) {
                if (loaderEntry.removed) continue;
                loaderTable.remove(loaderEntry.key);
            }
            LoaderKey loaderKey = new LoaderKey(uRLArray, classLoader);
            loaderEntry = (LoaderEntry)loaderTable.get(loaderKey);
            if (loaderEntry == null || (loader = (Loader)loaderEntry.get()) == null) {
                if (loaderEntry != null) {
                    loaderTable.remove(loaderKey);
                    loaderEntry.removed = true;
                }
                AccessControlContext accessControlContext = LoaderHandler.getLoaderAccessControlContext(uRLArray);
                loader = (Loader)AccessController.doPrivileged(new PrivilegedAction(){

                    public Object run() {
                        return new Loader(uRLArray, classLoader);
                    }
                }, accessControlContext);
                loaderEntry = new LoaderEntry(loaderKey, loader);
                loaderTable.put(loaderKey, loaderEntry);
            }
            // ** MonitorExit[var4_2] (shouldn't be in output)
            return loader;
        }
    }

    private static AccessControlContext getLoaderAccessControlContext(URL[] uRLArray) {
        PermissionCollection permissionCollection = (PermissionCollection)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                CodeSource codeSource = new CodeSource(null, (Certificate[])null);
                Policy policy = Policy.getPolicy();
                if (policy != null) {
                    return policy.getPermissions(codeSource);
                }
                return new Permissions();
            }
        });
        permissionCollection.add(new RuntimePermission("createClassLoader"));
        permissionCollection.add(new PropertyPermission("java.*", "read"));
        LoaderHandler.addPermissionsForURLs(uRLArray, permissionCollection, true);
        ProtectionDomain protectionDomain = new ProtectionDomain(new CodeSource(uRLArray.length > 0 ? uRLArray[0] : null, (Certificate[])null), permissionCollection);
        return new AccessControlContext(new ProtectionDomain[]{protectionDomain});
    }

    private static void addPermissionsForURLs(URL[] uRLArray, PermissionCollection permissionCollection, boolean bl) {
        for (int i = 0; i < uRLArray.length; ++i) {
            URL uRL = uRLArray[i];
            try {
                String string;
                Permission permission = uRL.openConnection().getPermission();
                if (permission == null) continue;
                if (permission instanceof FilePermission) {
                    string = permission.getName();
                    int n = string.lastIndexOf(File.separatorChar);
                    if (n != -1) {
                        if ((string = string.substring(0, n + 1)).endsWith(File.separator)) {
                            string = string + "-";
                        }
                        permissionCollection.add(new FilePermission(string, "read"));
                        continue;
                    }
                    permissionCollection.add(permission);
                    continue;
                }
                permissionCollection.add(permission);
                if (!bl || (string = uRL.getHost()) == null) continue;
                permissionCollection.add(new SocketPermission(string, "connect, accept"));
                continue;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    static {
        Object object = (String)AccessController.doPrivileged(new GetPropertyAction("java.rmi.server.codebase"));
        if (object != null && ((String)object).trim().length() > 0) {
            codebaseProperty = object;
        }
        codebaseURLs = null;
        codebaseLoaders = Collections.synchronizedMap(new IdentityHashMap(5));
        for (object = ClassLoader.getSystemClassLoader(); object != null; object = ((ClassLoader)object).getParent()) {
            codebaseLoaders.put(object, null);
        }
        loaderTable = new HashMap(5);
        refQueue = new ReferenceQueue();
        pathToURLsCache = new WeakHashMap(5);
    }

    private static class Loader
    extends URLClassLoader {
        private ClassLoader parent;
        private String annotation;
        private Permissions permissions;

        private Loader(URL[] uRLArray, ClassLoader classLoader) {
            super(uRLArray, classLoader);
            this.parent = classLoader;
            this.permissions = new Permissions();
            LoaderHandler.addPermissionsForURLs(uRLArray, this.permissions, false);
            this.annotation = LoaderHandler.urlsToPath(uRLArray);
        }

        public String getClassAnnotation() {
            return this.annotation;
        }

        private void checkPermissions() {
            SecurityManager securityManager = System.getSecurityManager();
            if (securityManager != null) {
                Enumeration<Permission> enumeration = this.permissions.elements();
                while (enumeration.hasMoreElements()) {
                    securityManager.checkPermission(enumeration.nextElement());
                }
            }
        }

        protected PermissionCollection getPermissions(CodeSource codeSource) {
            PermissionCollection permissionCollection = super.getPermissions(codeSource);
            return permissionCollection;
        }

        public String toString() {
            return super.toString() + "[\"" + this.annotation + "\"]";
        }
    }

    private static class LoaderEntry
    extends WeakReference {
        public LoaderKey key;
        public boolean removed = false;

        public LoaderEntry(LoaderKey loaderKey, Loader loader) {
            super(loader, refQueue);
            this.key = loaderKey;
        }
    }

    private static class LoaderKey {
        private URL[] urls;
        private ClassLoader parent;
        private int hashValue;

        public LoaderKey(URL[] uRLArray, ClassLoader classLoader) {
            this.urls = uRLArray;
            this.parent = classLoader;
            if (classLoader != null) {
                this.hashValue = classLoader.hashCode();
            }
            for (int i = 0; i < uRLArray.length; ++i) {
                this.hashValue ^= uRLArray[i].hashCode();
            }
        }

        public int hashCode() {
            return this.hashValue;
        }

        public boolean equals(Object object) {
            if (object instanceof LoaderKey) {
                LoaderKey loaderKey = (LoaderKey)object;
                if (this.parent != loaderKey.parent) {
                    return false;
                }
                if (this.urls == loaderKey.urls) {
                    return true;
                }
                if (this.urls.length != loaderKey.urls.length) {
                    return false;
                }
                for (int i = 0; i < this.urls.length; ++i) {
                    if (this.urls[i].equals(loaderKey.urls[i])) continue;
                    return false;
                }
                return true;
            }
            return false;
        }
    }
}

