/*
 * Decompiled with CFR 0.152.
 */
package javax.net.ssl;

import java.nio.ByteBuffer;
import javax.net.ssl.SSLEngineResult;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLSession;

public abstract class SSLEngine {
    private String peerHost = null;
    private int peerPort = -1;

    protected SSLEngine() {
    }

    protected SSLEngine(String string, int n) {
        this.peerHost = string;
        this.peerPort = n;
    }

    public String getPeerHost() {
        return this.peerHost;
    }

    public int getPeerPort() {
        return this.peerPort;
    }

    public SSLEngineResult wrap(ByteBuffer byteBuffer, ByteBuffer byteBuffer2) throws SSLException {
        return this.wrap(new ByteBuffer[]{byteBuffer}, 0, 1, byteBuffer2);
    }

    public SSLEngineResult wrap(ByteBuffer[] byteBufferArray, ByteBuffer byteBuffer) throws SSLException {
        if (byteBufferArray == null) {
            throw new IllegalArgumentException("src == null");
        }
        return this.wrap(byteBufferArray, 0, byteBufferArray.length, byteBuffer);
    }

    public abstract SSLEngineResult wrap(ByteBuffer[] var1, int var2, int var3, ByteBuffer var4) throws SSLException;

    public SSLEngineResult unwrap(ByteBuffer byteBuffer, ByteBuffer byteBuffer2) throws SSLException {
        return this.unwrap(byteBuffer, new ByteBuffer[]{byteBuffer2}, 0, 1);
    }

    public SSLEngineResult unwrap(ByteBuffer byteBuffer, ByteBuffer[] byteBufferArray) throws SSLException {
        if (byteBufferArray == null) {
            throw new IllegalArgumentException("dsts == null");
        }
        return this.unwrap(byteBuffer, byteBufferArray, 0, byteBufferArray.length);
    }

    public abstract SSLEngineResult unwrap(ByteBuffer var1, ByteBuffer[] var2, int var3, int var4) throws SSLException;

    public abstract Runnable getDelegatedTask();

    public abstract void closeInbound() throws SSLException;

    public abstract boolean isInboundDone();

    public abstract void closeOutbound();

    public abstract boolean isOutboundDone();

    public abstract String[] getSupportedCipherSuites();

    public abstract String[] getEnabledCipherSuites();

    public abstract void setEnabledCipherSuites(String[] var1);

    public abstract String[] getSupportedProtocols();

    public abstract String[] getEnabledProtocols();

    public abstract void setEnabledProtocols(String[] var1);

    public abstract SSLSession getSession();

    public abstract void beginHandshake() throws SSLException;

    public abstract SSLEngineResult.HandshakeStatus getHandshakeStatus();

    public abstract void setUseClientMode(boolean var1);

    public abstract boolean getUseClientMode();

    public abstract void setNeedClientAuth(boolean var1);

    public abstract boolean getNeedClientAuth();

    public abstract void setWantClientAuth(boolean var1);

    public abstract boolean getWantClientAuth();

    public abstract void setEnableSessionCreation(boolean var1);

    public abstract boolean getEnableSessionCreation();
}

