/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.eou.toolkit.util;

import java.util.Enumeration;
import java.util.Vector;
import java.util.zip.DataFormatException;
import java.util.zip.Deflater;
import java.util.zip.Inflater;

public class ArrayUtils {
    public static final int DIFFERENCE = 0;
    public static final int UNION = 1;
    public static final int INTERSECTION = 2;
    public static final int SYMMETRIC_DIFFERENCE = 3;

    private static String copyright() {
        return "\n\n(c) Copyright IBM Corporation 1999 (1996).\n\n";
    }

    private ArrayUtils() {
    }

    public static char[] combine(char[] cArray, char[] cArray2, int n) {
        char[] cArray3 = new char[cArray.length + cArray2.length];
        int n2 = 0;
        switch (n) {
            case 0: {
                n2 += ArrayUtils.copy(cArray, 0, cArray3, n2, cArray2, true);
                break;
            }
            case 1: {
                System.arraycopy(cArray, 0, cArray3, 0, cArray.length);
                n2 = cArray.length;
                n2 += ArrayUtils.copy(cArray2, 0, cArray3, n2, cArray, true);
                break;
            }
            case 2: {
                n2 += ArrayUtils.copy(cArray, 0, cArray3, n2, cArray2, false);
                break;
            }
            case 3: {
                n2 += ArrayUtils.copy(cArray, 0, cArray3, n2, cArray2, true);
                n2 += ArrayUtils.copy(cArray2, 0, cArray3, n2, cArray, true);
            }
        }
        char[] cArray4 = new char[n2];
        System.arraycopy(cArray3, 0, cArray4, 0, cArray4.length);
        return cArray4;
    }

    public static int copy(char[] cArray, int n, char[] cArray2, int n2, char[] cArray3, boolean bl) {
        int n3 = 0;
        int n4 = n;
        while (n4 < cArray.length) {
            char c;
            if (bl && ArrayUtils.indexOf(cArray3, c = cArray[n4], 0) == -1 || !bl && ArrayUtils.indexOf(cArray3, c = cArray[n4], 0) != -1) {
                cArray2[n2 + n3] = cArray[n4];
                ++n3;
            }
            ++n4;
        }
        return n3;
    }

    public static byte[] compressArray(byte[] byArray, int n) {
        byte[] byArray2;
        int n2;
        int n3;
        int n4;
        int n5 = byArray.length / n;
        byte[] byArray3 = new byte[256 * n];
        int n6 = 0;
        int[] nArray = new int[n5];
        int n7 = 0;
        while (n7 < n5) {
            n4 = -1;
            n3 = 0;
            while (n3 < n6 && n4 == -1) {
                boolean bl = true;
                n2 = 0;
                while (n2 < n && bl) {
                    if (byArray3[n3 * n + n2] != byArray[n7 * n + n2]) {
                        bl = false;
                    }
                    ++n2;
                }
                if (bl) {
                    n4 = n3;
                }
                ++n3;
            }
            if (n4 == -1) {
                if (n6 * n >= byArray3.length) {
                    byte[] byArray4 = byArray3;
                    byArray3 = new byte[byArray4.length + 256 * n];
                    System.arraycopy(byArray4, 0, byArray3, 0, byArray4.length);
                }
                System.arraycopy(byArray, n7 * n, byArray3, n6 * n, n);
                n4 = n6++;
            }
            nArray[n7] = n4;
            ++n7;
        }
        n4 = 0;
        while (1 << n4 * 8 < n6) {
            ++n4;
        }
        n3 = 2 + n4 + n6 * n + n5 * n4;
        if (n3 >= 1 + byArray.length) {
            byArray2 = new byte[1 + byArray.length];
            byArray2[0] = 0;
            System.arraycopy(byArray, 0, byArray2, 1, byArray.length);
        } else {
            byArray2 = new byte[n3];
            byArray2[0] = (byte)n4;
            byArray2[1] = (byte)n;
            int n8 = 2;
            n8 += ArrayUtils.writeAsBytes(byArray2, n8, n4, n6);
            System.arraycopy(byArray3, 0, byArray2, n8, n6 * n);
            n8 += n6 * n;
            n2 = 0;
            while (n2 < n5) {
                n8 += ArrayUtils.writeAsBytes(byArray2, n8, n4, nArray[n2]);
                ++n2;
            }
        }
        return byArray2;
    }

    public static int writeAsBytes(byte[] byArray, int n, int n2, int n3) {
        int n4 = 0;
        while (n4 < n2) {
            byArray[n + n4] = (byte)(n3 >>> n4 * 8 & 0xFF);
            ++n4;
        }
        return n2;
    }

    public static int readAsInt(byte[] byArray, int n, int n2) {
        int n3 = 0;
        int n4 = 0;
        while (n4 < n2) {
            n3 |= (byArray[n + n4] & 0xFF) << n4 * 8;
            ++n4;
        }
        return n3;
    }

    public static byte[] expandArray(byte[] byArray) {
        byte[] byArray2;
        int n = byArray[0] & 0xFF;
        if (n == 0) {
            byArray2 = new byte[byArray.length - 1];
            System.arraycopy(byArray, 1, byArray2, 0, byArray.length - 1);
        } else {
            int n2 = byArray[1] & 0xFF;
            int n3 = ArrayUtils.readAsInt(byArray, 2, n);
            int n4 = 2 + n;
            int n5 = n4 + n3 * n2;
            int n6 = (byArray.length - n5) / n;
            byArray2 = new byte[n6 * n2];
            int n7 = 0;
            while (n7 < n6) {
                int n8 = ArrayUtils.readAsInt(byArray, n5 + n7 * n, n);
                int n9 = n4 + n8 * n2;
                System.arraycopy(byArray, n9, byArray2, n7 * n2, n2);
                ++n7;
            }
        }
        return byArray2;
    }

    public static byte[] deflate(byte[] byArray, int n) {
        Deflater deflater = new Deflater(n);
        deflater.setInput(byArray, 0, byArray.length);
        deflater.finish();
        int n2 = 0;
        int n3 = byArray.length / 16 * 4;
        Vector<Object> vector = new Vector<Object>(8, 2);
        while (!deflater.finished()) {
            byte[] byArray2 = new byte[n3];
            int n4 = deflater.deflate(byArray2);
            n2 += n4;
            vector.addElement(new Integer(n4));
            vector.addElement(byArray2);
        }
        deflater.end();
        return ArrayUtils.packem(vector, new byte[n2]);
    }

    public static byte[] inflate(byte[] byArray) throws DataFormatException {
        Inflater inflater = new Inflater();
        inflater.setInput(byArray);
        int n = 0;
        int n2 = byArray.length * 4;
        Vector<Object> vector = new Vector<Object>(4, 2);
        while (!inflater.finished()) {
            byte[] byArray2 = new byte[n2];
            int n3 = inflater.inflate(byArray2);
            n += n3;
            vector.addElement(new Integer(n3));
            vector.addElement(byArray2);
        }
        inflater.end();
        return ArrayUtils.packem(vector, new byte[n]);
    }

    private static byte[] packem(Vector vector, byte[] byArray) {
        int n = 0;
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            int n2 = (Integer)enumeration.nextElement();
            byte[] byArray2 = (byte[])enumeration.nextElement();
            System.arraycopy(byArray2, 0, byArray, n, n2);
            n += n2;
        }
        vector.removeAllElements();
        return byArray;
    }

    public static int indexOf(Object[] objectArray, Object object) {
        return ArrayUtils.indexOf(objectArray, object, 0, false);
    }

    public static int indexOf(Object[] objectArray, Object object, int n) {
        return ArrayUtils.indexOf(objectArray, object, n, false);
    }

    public static int indexOf(Object[] objectArray, Object object, boolean bl) {
        return ArrayUtils.indexOf(objectArray, object, 0, bl);
    }

    public static int indexOf(Object[] objectArray, Object object, int n, boolean bl) {
        int n2 = -1;
        if (objectArray != null) {
            int n3 = n;
            while (n3 < objectArray.length && n2 == -1) {
                if (bl && object.equals(objectArray[n3]) || !bl && object == objectArray[n3]) {
                    n2 = n3;
                }
                ++n3;
            }
        }
        return n2;
    }

    public static long indexOf(long[] lArray, long l) {
        return ArrayUtils.indexOf(lArray, l, 0);
    }

    public static int indexOf(long[] lArray, long l, int n) {
        int n2 = -1;
        if (lArray != null) {
            int n3 = n;
            while (n3 < lArray.length && n2 == -1) {
                if (l == lArray[n3]) {
                    n2 = n3;
                }
                ++n3;
            }
        }
        return n2;
    }

    public static int indexOf(int[] nArray, int n) {
        return ArrayUtils.indexOf(nArray, n, 0);
    }

    public static int indexOf(int[] nArray, int n, int n2) {
        int n3 = -1;
        if (nArray != null) {
            int n4 = n2;
            while (n4 < nArray.length && n3 == -1) {
                if (n == nArray[n4]) {
                    n3 = n4;
                }
                ++n4;
            }
        }
        return n3;
    }

    public static int indexOf(short[] sArray, short s) {
        return ArrayUtils.indexOf(sArray, s, 0);
    }

    public static int indexOf(short[] sArray, short s, int n) {
        int n2 = -1;
        if (sArray != null) {
            int n3 = n;
            while (n3 < sArray.length && n2 == -1) {
                if (s == sArray[n3]) {
                    n2 = n3;
                }
                ++n3;
            }
        }
        return n2;
    }

    public static int indexOf(char[] cArray, char c) {
        return ArrayUtils.indexOf(cArray, c, 0);
    }

    public static int indexOf(char[] cArray, char c, int n) {
        int n2 = -1;
        if (cArray != null) {
            int n3 = n;
            while (n3 < cArray.length && n2 == -1) {
                if (c == cArray[n3]) {
                    n2 = n3;
                }
                ++n3;
            }
        }
        return n2;
    }

    public static int indexOf(byte[] byArray, byte by) {
        return ArrayUtils.indexOf(byArray, by, 0);
    }

    public static int indexOf(byte[] byArray, byte by, int n) {
        int n2 = -1;
        if (byArray != null) {
            int n3 = n;
            while (n3 < byArray.length && n2 == -1) {
                if (by == byArray[n3]) {
                    n2 = n3;
                }
                ++n3;
            }
        }
        return n2;
    }

    public static int indexOf(boolean[] blArray, boolean bl) {
        return ArrayUtils.indexOf(blArray, bl, 0);
    }

    public static int indexOf(boolean[] blArray, boolean bl, int n) {
        int n2 = -1;
        if (blArray != null) {
            int n3 = n;
            while (n3 < blArray.length && n2 == -1) {
                if (bl == blArray[n3]) {
                    n2 = n3;
                }
                ++n3;
            }
        }
        return n2;
    }

    public static int indexOf(float[] fArray, float f) {
        return ArrayUtils.indexOf(fArray, f, 0);
    }

    public static int indexOf(float[] fArray, float f, int n) {
        int n2 = -1;
        if (fArray != null) {
            int n3 = n;
            while (n3 < fArray.length && n2 == -1) {
                if (f == fArray[n3]) {
                    n2 = n3;
                }
                ++n3;
            }
        }
        return n2;
    }

    public static int indexOf(double[] dArray, double d) {
        return ArrayUtils.indexOf(dArray, d, 0);
    }

    public static int indexOf(double[] dArray, double d, int n) {
        int n2 = -1;
        if (dArray != null) {
            int n3 = n;
            while (n3 < dArray.length && n2 == -1) {
                if (d == dArray[n3]) {
                    n2 = n3;
                }
                ++n3;
            }
        }
        return n2;
    }

    public static Object[] addElement(Object object, Object[] objectArray, Object[] objectArray2) {
        System.arraycopy(objectArray, 0, objectArray2, 0, objectArray.length);
        objectArray2[objectArray2.length - 1] = object;
        return objectArray2;
    }

    public static Object[] removeElement(Object object, Object[] objectArray, Object[] objectArray2) {
        int n = ArrayUtils.indexOf(objectArray, object, 0, false);
        if (n >= 0) {
            System.arraycopy(objectArray, n + 1, objectArray, n, objectArray.length - (n + 1));
            System.arraycopy(objectArray, 0, objectArray2, 0, objectArray2.length);
            objectArray = objectArray2;
        }
        return objectArray;
    }
}

