/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.eou.toolkit.util;

public class Normalizer {
    private static String copyright() {
        return "\n\n(c) Copyright IBM Corporation 1999 (1996).\n\n";
    }

    protected Normalizer() {
    }

    public static long normalizeNearest(long l, long l2, long l3, long l4, long l5) {
        if (l2 - l > l5 - l4) {
            return ((l3 - l) * (l5 - l4) + (l2 - l) / 2L) / (l2 - l) + l4;
        }
        if (l2 == l) {
            return l4;
        }
        return (l3 - l) * (l5 - l4) / (l2 - l) + l4;
    }

    public static int normalizeNearest(long l, long l2, long l3, int n, int n2) {
        long l4 = Normalizer.normalizeNearest(l, l2, l3, (long)n, (long)n2);
        if (l4 < Integer.MIN_VALUE || l4 > Integer.MAX_VALUE) {
            throw new ArithmeticException("Integer overflow while normalizing range: " + l4);
        }
        return (int)l4;
    }

    public static long normalizeNearest(double d, double d2, double d3, long l, long l2) {
        return (long)((d3 - d) * (double)(l2 - l) / (d2 - d) + 0.5) + l;
    }

    public static int normalizeNearest(double d, double d2, double d3, int n, int n2) {
        long l = n;
        long l2 = n2;
        if ((l = (long)((d3 - d) * (double)(l2 - l) / (d2 - d) + 0.5) + l) < Integer.MIN_VALUE || l > Integer.MAX_VALUE) {
            throw new ArithmeticException("Integer overflow while normalizing range: " + l);
        }
        return (int)l;
    }

    public static long normalizeBalanced(long l, long l2, long l3, long l4, long l5) {
        if (l5 == l4 || l2 == l) {
            return l4;
        }
        return (l3 - l) * (l5 - l4 + 1L) / (l2 - l + 1L) + l4;
    }

    public static long unNormalizeBalanced(long l, long l2, long l3, long l4, long l5) {
        if (l2 == l) {
            return l4;
        }
        return ((l3 - l) * (l5 - l4 + 1L) + l2 - l) / (l2 - l + 1L) + l4;
    }

    public static long normalizeDown(long l, long l2, long l3, long l4, long l5) {
        if (l2 == l) {
            return l4;
        }
        return (l3 - l) * (l5 - l4) / (l2 - l) + l4;
    }

    public static long normalizeUp(long l, long l2, long l3, long l4, long l5) {
        if (l2 == l) {
            return l4;
        }
        return ((l3 - l) * (l5 - l4) + l2 - l - 1L) / (l2 - l) + l4;
    }

    public static int normalizeBalanced(long l, long l2, long l3, int n, int n2) {
        long l4 = n2;
        long l5 = n;
        long l6 = l5 = l4 == l5 || l2 == l ? l5 : (l3 - l) * (l4 - l5 + 1L) / (l2 - l + 1L) + l5;
        if (l5 < Integer.MIN_VALUE || l5 > Integer.MAX_VALUE) {
            throw new Error("Fatal error - Integer overflow while normalizing range: " + l5);
        }
        return (int)l5;
    }

    public static int normalizeDown(long l, long l2, long l3, int n, int n2) {
        long l4 = n;
        long l5 = n2;
        long l6 = l4 = l2 == l ? l4 : (l3 - l) * (l5 - l4) / (l2 - l) + l4;
        if (l4 < Integer.MIN_VALUE || l4 > Integer.MAX_VALUE) {
            throw new Error("Fatal error - Integer overflow while normalizing range: " + l4);
        }
        return (int)l4;
    }

    public static int normalizeUp(long l, long l2, long l3, int n, int n2) {
        long l4 = n;
        long l5 = n2;
        long l6 = l4 = l2 == l ? l4 : ((l3 - l) * (l5 - l4) + l2 - l - 1L) / (l2 - l) + l4;
        if (l4 < Integer.MIN_VALUE || l4 > Integer.MAX_VALUE) {
            throw new Error("Fatal error - Integer overflow while normalizing range: " + l4);
        }
        return (int)l4;
    }

    public static double normalize(long l, long l2, long l3, double d, double d2) {
        if (l2 == l) {
            return d;
        }
        return (double)(l3 - l) * (d2 - d) / (double)(l2 - l) + d;
    }
}

