/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.webrunner.util;

import java.io.Serializable;
import java.util.Enumeration;

public class IntegerVector
implements Cloneable,
Serializable {
    public static final int DEFAULT_CAPACITY = 100;
    public static final int DEFAULT_INCREMENT = 50;
    private int fCount;
    private int fIncrement;
    private int[] fData;

    public IntegerVector() {
        this(100, 50);
    }

    public IntegerVector(int n) {
        this(n, 50);
    }

    public IntegerVector(int n, int n2) {
        this.fIncrement = n2;
        this.fData = new int[n];
    }

    public IntegerVector(IntegerVector integerVector) {
        this.fCount = integerVector.fCount;
        this.fIncrement = integerVector.fIncrement;
        this.fData = new int[integerVector.fData.length];
        System.arraycopy(integerVector.fData, 0, this.fData, 0, this.fData.length);
    }

    public synchronized void addElement(int n) {
        this.ensureCapacity(this.fCount + 1);
        this.fData[this.fCount++] = n;
    }

    public synchronized int capacity() {
        return this.fData.length;
    }

    public Object clone() {
        return new IntegerVector(this);
    }

    public synchronized boolean contains(int n) {
        int n2 = 0;
        while (n2 < this.fCount) {
            if (this.fData[n2] == n) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public synchronized void copyInto(int[] nArray) {
        int n = nArray == null ? 0 : (nArray.length < this.fCount ? nArray.length : this.fCount);
        System.arraycopy(this.fData, 0, nArray, 0, n);
    }

    public int elementAt(int n) {
        if (n >= this.fCount) {
            throw new ArrayIndexOutOfBoundsException(String.valueOf(n) + " >= " + this.fCount);
        }
        try {
            return this.fData[n];
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new ArrayIndexOutOfBoundsException(String.valueOf(n) + " < 0");
        }
    }

    public Enumeration elements() {
        return new 1(this);
    }

    public synchronized void ensureCapacity(int n) {
        if (this.fData.length < n) {
            int n2 = n - this.fData.length;
            int n3 = n2 / this.fIncrement + 1;
            int n4 = this.fData.length + n3 * this.fIncrement;
            int[] nArray = new int[n4];
            System.arraycopy(this.fData, 0, nArray, 0, this.fCount);
            this.fData = nArray;
        }
    }

    public synchronized int firstElement() {
        if (this.fCount > 0) {
            return this.fData[0];
        }
        return -1;
    }

    public int indexOf(int n) {
        return this.indexOf(n, 0);
    }

    public synchronized int indexOf(int n, int n2) {
        int n3 = n2;
        while (n3 < this.fCount) {
            if (this.fData[n3] == n) {
                return n3;
            }
            ++n3;
        }
        return -1;
    }

    public synchronized void insertElementAt(int n, int n2) {
        this.ensureCapacity(this.fCount + 1);
        int n3 = this.fCount - n2;
        int[] nArray = new int[n3];
        System.arraycopy(this.fData, n2, nArray, 0, n3);
        System.arraycopy(nArray, 0, this.fData, n2 + 1, n3);
        this.fData[n2] = n;
        ++this.fCount;
    }

    public boolean isEmpty() {
        return this.fCount == 0;
    }

    public synchronized int lastElement() {
        if (this.fCount > 0) {
            return this.fData[this.fCount - 1];
        }
        return -1;
    }

    public int lastIndexOf(int n) {
        return this.lastIndexOf(n, 0);
    }

    public synchronized int lastIndexOf(int n, int n2) {
        int n3 = this.fCount - 1;
        while (n3 >= n2) {
            if (this.fData[n3] == n) {
                return n3;
            }
            --n3;
        }
        return -1;
    }

    public synchronized void removeAllElements() {
        this.fCount = 0;
    }

    public synchronized void removeElement(int n) {
        int n2 = this.indexOf(n);
        if (n2 == -1) {
            return;
        }
        this.removeElementAt(n2);
    }

    public synchronized void removeElementAt(int n) {
        int n2 = this.fCount - n - 1;
        System.arraycopy(this.fData, n + 1, this.fData, n, n2);
        --this.fCount;
    }

    public synchronized void setElementAt(int n, int n2) {
        if (n2 < 0 || n2 >= this.fCount) {
            return;
        }
        this.fData[n2] = n;
    }

    public synchronized void setSize(int n) {
        this.ensureCapacity(n);
        if (n < this.fCount) {
            this.fCount = n;
            this.trimToSize();
        }
    }

    public int size() {
        return this.fCount;
    }

    public synchronized void trimToSize() {
        int[] nArray = new int[this.fCount];
        System.arraycopy(this.fData, 0, nArray, 0, this.fCount);
        this.fData = nArray;
    }

    public synchronized String toString() {
        StringBuffer stringBuffer = new StringBuffer(this.getClass().getName());
        stringBuffer.append('[');
        stringBuffer.append("count=" + this.fCount);
        stringBuffer.append(",capacity=" + this.fData.length);
        stringBuffer.append(",increment=" + this.fIncrement);
        stringBuffer.append(",data={");
        int n = 0;
        while (n < this.fCount) {
            stringBuffer.append(this.fData[n]);
            if (n != this.fCount - 1) {
                stringBuffer.append(',');
            }
            ++n;
        }
        stringBuffer.append('}');
        stringBuffer.append(']');
        return stringBuffer.toString();
    }

    private final class 1
    implements Enumeration {
        private IntegerVector fCopy;
        private int fPlace;

        public Object nextElement() {
            return new Integer(this.fCopy.elementAt(this.fPlace++));
        }

        public boolean hasMoreElements() {
            return this.fPlace < this.fCopy.size();
        }

        /* synthetic */ 1(IntegerVector integerVector) {
            this.fCopy = new IntegerVector(integerVector);
        }
    }
}

