/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.webrunner.widget;

import com.ibm.webrunner.widget.Caption;
import com.ibm.webrunner.widget.event.CaptionBarEvent;
import com.ibm.webrunner.widget.event.CaptionBarListener;
import java.awt.Adjustable;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.Vector;

public class CaptionBar
extends Canvas
implements MouseListener,
MouseMotionListener,
AdjustmentListener {
    public static final Color DEFAULT_BACKGROUND_COLOR = Color.lightGray;
    private static final long serialVersionUID = 4683695671942799690L;
    public static final int MINIMUM_CAPTION_LENGTH = 12;
    private static final int DRAG_AREA_OFFSET = 3;
    private Adjustable fHAdjuster;
    private Vector fCaptionBarListeners = new Vector();
    private Vector fCaptions = new Vector();
    private transient boolean fDragPossible;
    private transient boolean fDragging;
    private transient int fPreviousX;
    private transient int fCaptionDragged;
    private boolean fContinuousDrag = false;
    private int fCaptionSelected;
    private transient int fCaptionOn;
    private transient int fClickCount;
    private transient Image fBackgroundImage;
    private transient Image fBuffer;
    private transient Graphics fBufferGraphics;
    private transient Dimension fBufferSize;
    private boolean fBorder = true;

    public CaptionBar() {
        this.setBackground(DEFAULT_BACKGROUND_COLOR);
        this.init();
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
    }

    private void init() {
        this.fDragPossible = false;
        this.fDragging = false;
        this.fPreviousX = 0;
    }

    private void readObject(ObjectInputStream objectInputStream) throws ClassNotFoundException, IOException {
        objectInputStream.defaultReadObject();
        this.init();
    }

    public synchronized void setHorizontalAdjuster(Adjustable adjustable) {
        if (this.fHAdjuster != null) {
            this.fHAdjuster.removeAdjustmentListener(this);
        }
        this.fHAdjuster = adjustable;
        this.fHAdjuster.addAdjustmentListener(this);
        this.repaint();
    }

    public Caption addCaption(String string) {
        return this.addCaption(string, 50);
    }

    public Caption addCaption(String string, int n) {
        Caption caption = new Caption();
        caption.setLabel(string);
        caption.setLength(n);
        if (!this.fBorder) {
            caption.setBorderVisible(this.fBorder);
        }
        return this.addCaption(caption);
    }

    public Caption addCaption(Caption caption) {
        this.fCaptions.addElement(caption);
        if (this.fCaptions.size() == 1) {
            caption.setSelected(true);
        }
        int n = this.fCaptions.size();
        int n2 = 0;
        int n3 = 0;
        while (n3 < n) {
            n2 += ((Caption)this.fCaptions.elementAt(n3)).getLength();
            ++n3;
        }
        Dimension dimension = this.getSize();
        if (n2 > dimension.width) {
            this.setSize(n2, dimension.height);
        }
        this.repaint();
        return caption;
    }

    public int getCaptionCount() {
        return this.fCaptions.size();
    }

    public int getSelectedCaptionIndex() {
        int n = this.fCaptions.size();
        int n2 = 0;
        while (n2 < n) {
            if (((Caption)this.fCaptions.elementAt(n2)).isSelected()) {
                return n2;
            }
            ++n2;
        }
        return -1;
    }

    public Caption getCaption(int n) {
        if (n < 0 || n >= this.fCaptions.size()) {
            return null;
        }
        return (Caption)this.fCaptions.elementAt(n);
    }

    public void removeCaption(int n) {
        this.fCaptions.removeElementAt(n);
        this.repaint();
    }

    public void removeAll() {
        this.fCaptions.removeAllElements();
        this.repaint();
    }

    public CaptionBar setContinuousDrag(boolean bl) {
        this.fContinuousDrag = bl;
        return this;
    }

    public boolean getContinuousDrag() {
        return this.fContinuousDrag;
    }

    public Dimension getPreferredSize() {
        return this.getMinimumSize();
    }

    public Dimension getMinimumSize() {
        return new Dimension(100, 20);
    }

    public void setBackgroundImage(Image image) {
        this.fBackgroundImage = image;
        this.repaint();
    }

    public Image getBackgroundImage() {
        return this.fBackgroundImage;
    }

    protected void setBorderVisible(boolean bl) {
        CaptionBar captionBar = this;
        synchronized (captionBar) {
            if (this.fBorder != bl) {
                this.fBorder = bl;
            }
        }
        int n = this.fCaptions.size();
        int n2 = 0;
        while (n2 < n) {
            ((Caption)this.fCaptions.elementAt(n2)).setBorderVisible(bl);
            ++n2;
        }
    }

    protected boolean isBorderVisible() {
        return this.fBorder;
    }

    public void update(Graphics graphics) {
        this.paint(graphics);
    }

    public void paint(Graphics graphics) {
        int n;
        int n2;
        int n3;
        int n4;
        Graphics graphics2 = this.fBufferGraphics;
        Dimension dimension = this.getSize();
        try {
            if (this.fBuffer == null || this.fBufferSize.width != dimension.width || this.fBufferSize.height != dimension.height) {
                if (this.fBuffer != null) {
                    this.fBuffer.flush();
                    this.fBuffer = null;
                    this.fBufferGraphics.dispose();
                }
                this.fBufferSize = dimension;
                this.fBuffer = this.createImage(this.fBufferSize.width, this.fBufferSize.height);
                graphics2 = this.fBufferGraphics = this.fBuffer.getGraphics();
                graphics2.setClip(0, 0, dimension.width, dimension.height);
            }
        }
        catch (Exception exception) {
            graphics2 = graphics;
        }
        int n5 = n4 = this.fHAdjuster != null ? -this.fHAdjuster.getValue() : 0;
        if (this.fBackgroundImage == null) {
            graphics2.setColor(this.getBackground());
            graphics2.fillRect(0, 0, dimension.width, dimension.height);
        } else {
            int n6 = this.fBackgroundImage.getWidth(this);
            int n7 = this.fBackgroundImage.getHeight(this);
            int n8 = dimension.width / n6 + 2;
            n3 = dimension.height / n7 + 1;
            n2 = n4 % n6;
            int n9 = n4;
            while (n9 < n8) {
                n = 0;
                while (n < n3) {
                    graphics2.drawImage(this.fBackgroundImage, n2 + n9 * n6, n * n7, this);
                    ++n;
                }
                ++n9;
            }
        }
        Color color = this.getBackground();
        Vector vector = this.fCaptions;
        synchronized (vector) {
            n3 = this.fCaptions.size();
            if (n3 > 0) {
                n2 = 0;
                while (n2 < n3) {
                    Caption caption = (Caption)this.fCaptions.elementAt(n2);
                    if (caption.isVisible()) {
                        n = caption.getLength();
                        if (n4 + n < 0) {
                            n4 += n;
                        } else {
                            graphics2.setClip(n4, 0, n, dimension.height);
                            graphics2.setColor(color);
                            caption.paint(graphics2);
                            if ((n4 += n) > dimension.width) break;
                        }
                    }
                    ++n2;
                }
                graphics2.setClip(n4, 0, dimension.width - n4, dimension.height);
                graphics2.setColor(color);
                ((Caption)this.fCaptions.firstElement()).paintBackground(graphics2);
            } else if (this.fBorder) {
                Color color2 = color.brighter().brighter().brighter();
                Color color3 = color.darker().darker().darker();
                graphics2.setColor(color2);
                graphics2.drawLine(0, 0, dimension.width - 1, 0);
                graphics2.drawLine(0, 1, 0, dimension.height - 1);
                graphics2.setColor(color3);
                graphics2.drawLine(dimension.width - 1, 0, dimension.width - 1, dimension.height - 1);
                graphics2.drawLine(0, dimension.height - 1, dimension.width - 2, dimension.height - 1);
            }
        }
        graphics2.setClip(0, 0, dimension.width, dimension.height);
        if (this.fBuffer != null && graphics2 == this.fBufferGraphics) {
            graphics.drawImage(this.fBuffer, 0, 0, this);
        }
    }

    public void addCaptionBarListener(CaptionBarListener captionBarListener) {
        this.fCaptionBarListeners.addElement(captionBarListener);
    }

    public void removeCaptionBarListener(CaptionBarListener captionBarListener) {
        this.fCaptionBarListeners.removeElement(captionBarListener);
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
        int n = this.fHAdjuster != null ? this.fHAdjuster.getValue() : 0;
        int n2 = mouseEvent.getX() + n;
        if (this.fDragPossible) {
            this.fDragging = true;
        }
        int n3 = this.fCaptions.size();
        int n4 = 0;
        this.fCaptionOn = -1;
        int n5 = 0;
        while (n5 < n3) {
            Caption caption = (Caption)this.fCaptions.elementAt(n5);
            if (caption.isVisible()) {
                int n6 = caption.getLength();
                if (n2 >= n4 && n2 < n4 + n6) {
                    this.fCaptionOn = n5;
                    this.fClickCount = mouseEvent.getClickCount();
                    return;
                }
                n4 += n6;
            }
            ++n5;
        }
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        if (this.fDragging) {
            int n = mouseEvent.getClickCount();
            this.setCursor(Cursor.getDefaultCursor());
            this.fDragging = false;
            if (!this.fContinuousDrag || n > 1) {
                Vector vector;
                Vector vector2 = this.fCaptionBarListeners;
                synchronized (vector2) {
                    vector = (Vector)this.fCaptionBarListeners.clone();
                }
                int n2 = vector.size();
                if (n2 > 0) {
                    CaptionBarEvent captionBarEvent = new CaptionBarEvent(this, 2001, this.fCaptionDragged, n, mouseEvent.getModifiers());
                    int n3 = 0;
                    while (n3 < n2) {
                        ((CaptionBarListener)vector.elementAt(n3)).captionResized(captionBarEvent);
                        ++n3;
                    }
                }
                return;
            }
        } else if (this.fCaptionOn != -1) {
            Serializable serializable;
            int n = this.fHAdjuster != null ? this.fHAdjuster.getValue() : 0;
            int n4 = mouseEvent.getX() + n;
            int n5 = this.fCaptions.size();
            int n6 = 0;
            int n7 = 0;
            while (n7 < n5) {
                serializable = (Caption)this.fCaptions.elementAt(n7);
                if (((Caption)serializable).isVisible()) {
                    int n8 = ((Caption)serializable).getLength();
                    if (n4 >= n6 && n4 < n6 + n8) {
                        if (n7 != this.fCaptionOn || n7 == this.fCaptionSelected) break;
                        ((Caption)this.fCaptions.elementAt(this.fCaptionSelected)).setSelected(false);
                        ((Caption)serializable).setSelected(true);
                        this.fCaptionSelected = n7;
                        break;
                    }
                    n6 += n8;
                }
                ++n7;
            }
            this.repaint();
            Serializable serializable2 = this.fCaptionBarListeners;
            synchronized (serializable2) {
                serializable = (Vector)this.fCaptionBarListeners.clone();
            }
            n5 = ((Vector)serializable).size();
            if (n5 > 0) {
                serializable2 = new CaptionBarEvent(this, 2000, this.fCaptionSelected, this.fClickCount, mouseEvent.getModifiers());
                int n9 = 0;
                while (n9 < n5) {
                    ((CaptionBarListener)((Vector)serializable).elementAt(n9)).captionSelected((CaptionBarEvent)serializable2);
                    ++n9;
                }
            }
        }
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
        if (!this.fDragging) {
            this.setCursor(Cursor.getDefaultCursor());
        }
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        if (this.fDragging) {
            int n = this.fHAdjuster != null ? this.fHAdjuster.getValue() : 0;
            int n2 = mouseEvent.getX() + n;
            Caption caption = (Caption)this.fCaptions.elementAt(this.fCaptionDragged);
            int n3 = n2 - this.fPreviousX;
            int n4 = caption.getLength();
            if (n3 > 0) {
                caption.setLength(n4 + n3);
                this.fPreviousX = n2;
                this.repaint();
            } else if (n3 < 0 && n4 > 12) {
                if (n4 + n3 >= 10) {
                    caption.setLength(n4 + n3);
                    this.fPreviousX = n2;
                } else {
                    caption.setLength(12);
                }
                this.repaint();
            }
            if (this.fContinuousDrag) {
                Vector vector;
                Serializable serializable = this.fCaptionBarListeners;
                synchronized (serializable) {
                    vector = (Vector)this.fCaptionBarListeners.clone();
                }
                serializable = new CaptionBarEvent(this, 2001, this.fCaptionDragged, this.fClickCount, mouseEvent.getModifiers());
                int n5 = vector.size();
                int n6 = 0;
                while (n6 < n5) {
                    ((CaptionBarListener)vector.elementAt(n6)).captionResized((CaptionBarEvent)serializable);
                    ++n6;
                }
            }
        }
    }

    public void mouseMoved(MouseEvent mouseEvent) {
        int n = this.fHAdjuster != null ? this.fHAdjuster.getValue() : 0;
        int n2 = mouseEvent.getX() + n;
        int n3 = this.fCaptions.size();
        int n4 = 0;
        int n5 = 0;
        while (n5 < n3) {
            Caption caption = (Caption)this.fCaptions.elementAt(n5);
            if (caption.isVisible() && caption.isResizable() && n2 >= (n4 += caption.getLength()) - 3 && n2 <= n4 + 3) {
                this.setCursor(Cursor.getPredefinedCursor(11));
                this.fDragPossible = true;
                this.fCaptionDragged = n5;
                this.fPreviousX = n4;
                return;
            }
            ++n5;
        }
        if (this.fDragPossible) {
            this.setCursor(Cursor.getDefaultCursor());
            this.fDragPossible = false;
        }
    }

    public void adjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
        Object object = adjustmentEvent.getSource();
        if (object == this.fHAdjuster) {
            this.repaint();
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(this.getClass().getName());
        stringBuffer.append("[");
        int n = this.fCaptions.size();
        stringBuffer.append("count=" + n);
        stringBuffer.append(",captions={");
        int n2 = 0;
        while (n2 < n) {
            stringBuffer.append(((Caption)this.fCaptions.elementAt(n2)).getLabel());
            if (n2 < n - 1) {
                stringBuffer.append(",");
            }
            ++n2;
        }
        stringBuffer.append("}");
        stringBuffer.append("]");
        return stringBuffer.toString();
    }
}

