/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.webrunner.widget;

import com.ibm.hci.toolkit.graphics.ImageSerializer;
import com.ibm.webrunner.widget.TileImage;
import com.sun.java.swing.JComponent;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.image.FilteredImageSource;
import java.awt.image.ImageFilter;
import java.awt.image.ImageObserver;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.net.URL;
import java.util.Vector;

public class ImageComponent
extends JComponent
implements ImageObserver,
Serializable {
    private static final String copyright = "Licensed Material - Property of IBM\nIBM(R) VisualAge(TM) for Java(TM) Version 2.0\n(C) Copyright IBM Corp. 1998 - All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.";
    private transient Image image;
    private transient Image invalidImage;
    private ImageSerializer serializer;
    private ImageSerializer invImgSerializer;
    private Color invalidImageColor = Color.gray;
    private String fileName;
    private URL imageURL;
    private boolean tile = false;
    private boolean useImageSizeForPreferredSize = true;
    private boolean error = false;
    private boolean stretch = false;
    private boolean maintainAspect = false;
    private transient Vector changeListeners;
    private float hAlignment = 0.0f;
    private float vAlignment = 0.0f;
    private Dimension preferredSize;
    private double horizontalScale = 1.0;
    private double verticalScale = 1.0;
    private ImageFilter filter;
    private byte[] imageData;
    private transient Image imageBuffer;
    private transient Graphics graphicsBuffer;
    private boolean doubleBuffer = true;

    public void setDoubleBuffer(boolean bl) {
        this.doubleBuffer = bl;
    }

    public boolean getDoubleBuffer() {
        return this.doubleBuffer;
    }

    public void setImageFilter(ImageFilter imageFilter) {
        this.filter = imageFilter;
    }

    public ImageFilter getimageFilter() {
        return this.filter;
    }

    public void setTileImage(boolean bl) {
        if (bl == this.tile) {
            return;
        }
        if (bl) {
            this.setStretch(false);
        }
        this.firePropertyChanged("tileImage", this.tile, bl);
        this.tile = bl;
        ((Component)((Object)this)).repaint();
    }

    public boolean getTileImage() {
        return this.tile;
    }

    public void setHorizontalScaleFactor(double d) {
        if (d == this.horizontalScale) {
            return;
        }
        this.fireDoublePropertyChanged("horizontalScaleFactor", this.horizontalScale, d);
        this.horizontalScale = d;
        ((Component)((Object)this)).repaint();
    }

    public double getHorizontalScaleFactor() {
        return this.horizontalScale;
    }

    public void setVerticalScaleFactor(double d) {
        if (d == this.verticalScale) {
            return;
        }
        this.fireDoublePropertyChanged("verticalScaleFactor", this.verticalScale, d);
        this.verticalScale = d;
        ((Component)((Object)this)).repaint();
    }

    public double getVerticalScaleFactor() {
        return this.verticalScale;
    }

    public void setMaintainAspectRatio(boolean bl) {
        if (bl == this.maintainAspect) {
            return;
        }
        this.firePropertyChanged("maintainAspectRatio", this.maintainAspect, bl);
        this.maintainAspect = bl;
        ((Component)((Object)this)).repaint();
    }

    public boolean getMaintainAspectRatio() {
        return this.maintainAspect;
    }

    public void setStretch(boolean bl) {
        if (this.stretch == bl) {
            return;
        }
        if (bl) {
            this.setTileImage(false);
        }
        this.firePropertyChanged("stretch", this.stretch, bl);
        this.stretch = bl;
        ((Component)((Object)this)).repaint();
    }

    public boolean getStretch() {
        return this.stretch;
    }

    public boolean getUseImageSizeForPreferredSize() {
        return this.useImageSizeForPreferredSize;
    }

    public void setUseImageSizeForPreferredSize(boolean bl) {
        if (this.useImageSizeForPreferredSize == bl) {
            return;
        }
        this.firePropertyChanged("useImageSizeForPreferredSize", this.useImageSizeForPreferredSize, bl);
        this.useImageSizeForPreferredSize = bl;
        this.revalidate();
        ((Component)((Object)this)).repaint();
    }

    public void setHorizontalAlignment(float f) {
        if (this.hAlignment == f) {
            return;
        }
        this.hAlignment = f;
        ((Component)((Object)this)).repaint();
        ((Container)((Object)this)).invalidate();
    }

    public float getHorizontalAlignment() {
        return this.hAlignment;
    }

    public void setVerticalAlignment(float f) {
        if (this.vAlignment == f) {
            return;
        }
        this.vAlignment = f;
        ((Component)((Object)this)).repaint();
        ((Container)((Object)this)).invalidate();
    }

    public float getVerticalAlignment() {
        return this.vAlignment;
    }

    private void resetBuffer() {
        if (this.doubleBuffer && this.imageBuffer != null) {
            this.graphicsBuffer.dispose();
            this.graphicsBuffer = null;
            this.imageBuffer.flush();
            this.imageBuffer = null;
        }
    }

    private void initImageBuffer() {
        if (this.doubleBuffer) {
            this.resetBuffer();
            this.imageBuffer = ((Component)((Object)this)).createImage(((Component)((Object)this)).getSize().width, ((Component)((Object)this)).getSize().height);
            this.graphicsBuffer = this.imageBuffer.getGraphics();
        }
    }

    public void paintComponent(Graphics graphics) {
        block43: {
            this.error = false;
            super.paintComponent(graphics);
            Insets insets = this.getInsets();
            if (this.doubleBuffer && this.imageBuffer == null) {
                this.initImageBuffer();
            }
            if (!this.doubleBuffer) {
                this.graphicsBuffer = graphics;
            }
            if (this.image != null) {
                try {
                    int n = insets.left;
                    int n2 = insets.top;
                    int n3 = ((Component)((Object)this)).getSize().width;
                    int n4 = ((Component)((Object)this)).getSize().height;
                    int n5 = this.image.getWidth(this);
                    if (n5 < 0) {
                        return;
                    }
                    int n6 = this.image.getHeight(this);
                    if (n6 < 0) {
                        return;
                    }
                    if (this.tile) {
                        TileImage.tileImage(this.image, this.graphicsBuffer, insets.left, insets.top, ((Component)((Object)this)).getSize().width - insets.left - insets.right, ((Component)((Object)this)).getSize().height - insets.top - insets.bottom, this, this.horizontalScale, this.verticalScale);
                        if (this.doubleBuffer) {
                            graphics.drawImage(this.imageBuffer, 0, 0, null);
                        }
                        return;
                    }
                    if (this.stretch && !this.maintainAspect) {
                        n5 = n3;
                        n6 = n4;
                    } else if (this.maintainAspect) {
                        double d = n3;
                        d /= (double)n5;
                        double d2 = n4;
                        d2 /= (double)n6;
                        if (n6 > n4) {
                            if (n5 > n3) {
                                if (d < d2) {
                                    n5 = n3;
                                    n6 = (int)((double)n6 * d);
                                } else {
                                    n6 = n4;
                                    n5 = (int)((double)n5 * d2);
                                }
                            } else {
                                n6 = n4;
                                n5 = (int)((double)n5 * d2);
                            }
                        } else if (n5 > n3) {
                            n5 = n3;
                            n6 = (int)((double)n6 * d);
                        } else if (this.stretch) {
                            if (d < d2) {
                                n5 = n3;
                                n6 = (int)((double)n6 * d);
                            } else {
                                n6 = n4;
                                n5 = (int)((double)n5 * d2);
                            }
                        }
                    }
                    n6 = (int)((double)n6 * this.verticalScale);
                    n5 = (int)((double)n5 * this.horizontalScale);
                    int n7 = 0;
                    if (this.hAlignment == 0.5f) {
                        n7 = 1;
                    } else if (this.hAlignment == 1.0f) {
                        n7 = 2;
                    }
                    int n8 = 0;
                    if (this.vAlignment == 0.5f) {
                        n8 = 1;
                    } else if (this.vAlignment == 1.0f) {
                        n8 = 2;
                    }
                    switch (n7) {
                        case 2: {
                            n = n3 - n5 - insets.right;
                            break;
                        }
                        case 1: {
                            int n9 = n3 - n5 - insets.right - insets.left;
                            n = insets.left + n9 / 2;
                            break;
                        }
                    }
                    switch (n8) {
                        case 2: {
                            n2 = n4 - n6 - insets.bottom;
                            break;
                        }
                        case 1: {
                            int n10 = n4 - n6 - insets.top - insets.bottom;
                            n2 = insets.top + n10 / 2;
                            break;
                        }
                    }
                    Rectangle rectangle = this.graphicsBuffer.getClipBounds();
                    this.graphicsBuffer.setClip(insets.left, insets.top, n3 - insets.right - insets.left - 1, n4 - insets.bottom - insets.top - 1);
                    if (this.doubleBuffer) {
                        Color color = this.graphicsBuffer.getColor();
                        this.graphicsBuffer.setColor(((Component)((Object)this)).getBackground());
                        this.graphicsBuffer.fillRect(insets.left, insets.top, ((Component)((Object)this)).getSize().width - insets.left - insets.right - 1, ((Component)((Object)this)).getSize().height - insets.top - insets.bottom - 1);
                        this.graphicsBuffer.setColor(color);
                    }
                    this.graphicsBuffer.drawImage(this.image, n, n2, n5, n6, this);
                    this.graphicsBuffer.setClip(rectangle);
                    if (this.doubleBuffer) {
                        graphics.drawImage(this.imageBuffer, 0, 0, null);
                        return;
                    }
                    break block43;
                }
                catch (Exception exception) {
                    System.out.println(exception);
                    return;
                }
            }
            Color color = this.graphicsBuffer.getColor();
            this.graphicsBuffer.setColor(this.invalidImageColor);
            this.graphicsBuffer.fillRect(insets.left, insets.top, ((Component)((Object)this)).getSize().width - insets.left - insets.right - 1, ((Component)((Object)this)).getSize().height - insets.top - insets.bottom - 1);
            this.graphicsBuffer.setColor(color);
            if (this.invalidImage != null) {
                try {
                    this.graphicsBuffer.drawImage(this.invalidImage, insets.left, insets.top, this);
                }
                catch (Exception exception) {}
            }
            if (this.doubleBuffer) {
                graphics.drawImage(this.imageBuffer, 0, 0, null);
            }
        }
    }

    public Dimension getPreferredSize() {
        if (this.preferredSize != null) {
            return this.preferredSize;
        }
        if (this.image != null && this.useImageSizeForPreferredSize) {
            this.error = false;
            int n = this.image.getHeight(this);
            while (n < 0 && !this.error) {
                n = this.image.getHeight(this);
            }
            if (this.error) {
                return super.getPreferredSize();
            }
            int n2 = this.image.getWidth(this);
            Dimension dimension = new Dimension((int)((double)n2 * this.horizontalScale), (int)((double)n * this.verticalScale));
            return dimension;
        }
        return new Dimension(50, 50);
    }

    public void setPreferredSize(Dimension dimension) {
        this.preferredSize = dimension;
    }

    public void setSize(Dimension dimension) {
        this.resetBuffer();
        this.setPreferredSize(dimension);
    }

    public void setInvalidImageColor(Color color) {
        this.invalidImageColor = color;
    }

    public Color getInvalidImageColor() {
        return this.invalidImageColor;
    }

    public void setInvalidImage(Image image) {
        this.invalidImage = image;
        this.invImgSerializer = null;
    }

    public Image getInvalidImage() {
        return this.invalidImage;
    }

    public void setObject(Object object) {
        this.fileName = null;
        this.imageURL = null;
        this.image = null;
        this.serializer = null;
        try {
            this.setBytes((byte[])object);
            return;
        }
        catch (Exception exception) {
            try {
                this.setImage((Image)object);
                return;
            }
            catch (Exception exception2) {
                return;
            }
        }
    }

    public void setImage(Image image) {
        this.image = image;
        this.serializer = null;
        if (this.filter != null) {
            this.image = ((Component)((Object)this)).getToolkit().createImage(new FilteredImageSource(this.image.getSource(), this.filter));
        }
        ((Component)((Object)this)).repaint();
        ((Container)((Object)this)).invalidate();
    }

    public Image getImage() {
        if (this.image == null && this.imageData != null) {
            this.setBytes(this.imageData);
        }
        return this.image;
    }

    public void setURL(URL uRL) {
        this.imageURL = uRL;
        this.fileName = null;
        this.image = null;
        this.serializer = null;
        try {
            this.image = ((Component)((Object)this)).getToolkit().getImage(uRL);
            if (this.filter != null) {
                this.image = ((Component)((Object)this)).getToolkit().createImage(new FilteredImageSource(this.image.getSource(), this.filter));
            }
        }
        catch (Exception exception) {
            this.image = null;
        }
        ((Component)((Object)this)).repaint();
        ((Container)((Object)this)).invalidate();
    }

    public URL getURL() {
        return this.imageURL;
    }

    public void setBytes(byte[] byArray) {
        this.fileName = null;
        this.imageURL = null;
        this.image = null;
        this.serializer = null;
        this.imageData = byArray;
        try {
            this.getInsets();
            this.image = ((Component)((Object)this)).getToolkit().createImage(byArray);
            if (this.filter != null) {
                this.image = ((Component)((Object)this)).getToolkit().createImage(new FilteredImageSource(this.image.getSource(), this.filter));
            }
        }
        catch (Exception exception) {
            this.image = null;
            System.out.println(exception);
        }
        ((Component)((Object)this)).repaint();
        ((Container)((Object)this)).invalidate();
    }

    public void setFileName(String string) {
        this.fileName = string;
        this.imageURL = null;
        this.image = null;
        this.serializer = null;
        try {
            this.image = ((Component)((Object)this)).getToolkit().getImage(this.fileName);
        }
        catch (Exception exception) {
            this.image = null;
        }
        ((Component)((Object)this)).repaint();
        ((Container)((Object)this)).invalidate();
    }

    public String getFileName() {
        return this.fileName;
    }

    public boolean imageUpdate(Image image, int n, int n2, int n3, int n4, int n5) {
        if ((n & 0x40) == 64) {
            this.error = true;
            this.image = null;
            this.serializer = null;
            ((Component)((Object)this)).repaint();
            return false;
        }
        if ((n & 0x20) == 32) {
            this.revalidate();
            ((Container)((Object)this)).invalidate();
            ((Component)((Object)this)).repaint();
            return false;
        }
        if ((n & 0x10) == 16) {
            ((Component)((Object)this)).repaint();
            return true;
        }
        return true;
    }

    public synchronized void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (this.changeListeners != null && this.changeListeners.contains(propertyChangeListener)) {
            Vector vector = (Vector)this.changeListeners.clone();
            vector.removeElement(propertyChangeListener);
            this.changeListeners = vector;
        }
    }

    public synchronized void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        Vector vector;
        Vector vector2 = vector = this.changeListeners == null ? new Vector(2) : (Vector)this.changeListeners.clone();
        if (!vector.contains(propertyChangeListener)) {
            vector.addElement(propertyChangeListener);
            this.changeListeners = vector;
        }
    }

    private void firePropertyChanged(String string, boolean bl, boolean bl2) {
        PropertyChangeEvent propertyChangeEvent = new PropertyChangeEvent(this, string, new Boolean(bl), new Boolean(bl2));
        if (this.changeListeners != null) {
            Vector vector = this.changeListeners;
            int n = vector.size();
            int n2 = 0;
            while (n2 < n) {
                ((PropertyChangeListener)vector.elementAt(n2)).propertyChange(propertyChangeEvent);
                ++n2;
            }
        }
    }

    private void fireDoublePropertyChanged(String string, double d, double d2) {
        PropertyChangeEvent propertyChangeEvent = new PropertyChangeEvent(this, string, new Double(d), new Double(d2));
        if (this.changeListeners != null) {
            Vector vector = this.changeListeners;
            int n = vector.size();
            int n2 = 0;
            while (n2 < n) {
                ((PropertyChangeListener)vector.elementAt(n2)).propertyChange(propertyChangeEvent);
                ++n2;
            }
        }
    }

    void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        if (this.image != null && this.serializer == null) {
            this.serializer = new ImageSerializer(this.image);
        }
        if (this.invalidImage != null && this.invImgSerializer == null) {
            this.invImgSerializer = new ImageSerializer(this.invalidImage);
        }
        objectOutputStream.defaultWriteObject();
    }

    void readObject(ObjectInputStream objectInputStream) throws ClassNotFoundException, IOException {
        objectInputStream.defaultReadObject();
        if (this.serializer != null) {
            this.image = this.serializer.getImage();
        }
        if (this.invImgSerializer != null) {
            this.invalidImage = this.invImgSerializer.getImage();
        }
    }
}

